/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import java.util.HashMap;
import optas.hydro.Identifiable;

public class ObjectPool<T extends Identifiable> {
    T[] pool;
    HashMap<Integer, Integer> map;
    int size = 0;
    int[] freeIndex;
    int lastFreeIndex;

    ObjectPool(T[] pool) {
        this.pool = pool;
        this.init(pool.length);
    }

    private void init(int size) {
        this.map = new HashMap();
        this.size = size;
        this.freeIndex = new int[size];
        this.reset();
    }

    T allocate() {
        return this.pool[this.freeIndex[this.lastFreeIndex--]];
    }

    public double load() {
        return 1.0 - (double)this.lastFreeIndex / (double)this.size;
    }

    void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.freeIndex[i] = i;
            this.map.put(this.pool[i].getID(), i);
        }
        this.lastFreeIndex = this.size - 1;
    }

    void free(T obj) {
        int index = this.map.get(obj.getID());
        this.freeIndex[++this.lastFreeIndex] = index;
    }
}

