/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import jams.data.JAMSCalendar;
import jams.gui.tools.GUIHelper;
import jams.workspace.stores.J2KTSDataStore;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import optas.data.DataCollection;
import optas.data.Efficiency;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.MCAT5.MCAT5Toolbar;
import optas.gui.wizard.HydrographChart;
import optas.hydro.OptimizationScheme;
import optas.hydro.ParameterGroup;
import optas.hydro.calculations.SlopeCalculations;
import optas.hydro.gui.GllobalSensitivityEfficiencyComparison;
import optas.hydro.gui.SelectionDialog;
import optas.hydro.gui.SimpleGlobalSensitivityAtPoint;
import optas.hydro.gui.WeightChart;
import optas.io.TSDataReader;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

@Deprecated
public class HydroAnalysisFrame
extends JFrame {
    final int MAX_WEIGHTS = 9;
    final Color[] weightColor = new Color[]{Color.blue, Color.black, Color.CYAN, Color.DARK_GRAY, Color.GREEN, Color.MAGENTA, Color.PINK, Color.ORANGE, Color.YELLOW};
    HydrographChart chart;
    WeightChart weightChart;
    JFreeChart dominantParameterChart;
    J2KTSDataStore store;
    JSlider peakSlider = new JSlider();
    JTextField peakNumberField = new JTextField(4);
    JSlider recessionSlider = new JSlider();
    JTextField recessionNumberField = new JTextField(4);
    JSlider groundwaterSlider = new JSlider();
    JTextField groundwaterThresholdField = new JTextField(4);
    JButton loadEnsemble = new JButton("Load Ensemble");
    JComboBox obsDatasets = new JComboBox();
    JComboBox simDatasets = new JComboBox();
    JComboBox effDatasets = new JComboBox();
    JComboBox paramDatasets = new JComboBox();
    JComboBox optimizationSchemes = new JComboBox();
    JList parameterGroups = new JList();
    JTextArea optimizationSchemeDesc = new JTextArea(15, 30);
    double[][] weights = null;
    String[] parameterIDs = null;
    DataCollection ensemble;
    XYLineAndShapeRenderer[] weightRenderer = new XYLineAndShapeRenderer[9];
    OptimizationScheme[] scheme = new OptimizationScheme[3];
    JFileChooser j2kFile_chooser = GUIHelper.getJFileChooser();
    JMenuItem startCalibrationWizard = new JMenuItem("Start Calibration Wizard");
    JMenuItem exportOptimizationScheme = new JMenuItem("Export");
    JMenuItem openEnsemble = new JMenuItem("open ensemble");
    JMenuItem openObservation = new JMenuItem("open hydrograph");

    private void calcOptimationScheme(int index) {
        String obsItem = (String)this.obsDatasets.getSelectedItem();
        String effItem = (String)this.effDatasets.getSelectedItem();
        if (this.weights == null) {
            this.calcWeights();
        }
        ((DefaultListModel)this.parameterGroups.getModel()).clear();
        int counter = 0;
        for (ParameterGroup p : this.scheme[index].solutionGroups) {
            ((DefaultListModel)this.parameterGroups.getModel()).addElement("Group" + counter++);
        }
        this.parameterGroups.clearSelection();
        this.optimizationSchemeDesc.setText("");
    }

    public HydroAnalysisFrame() {
        this.setDefaultCloseOperation(2);
        this.j2kFile_chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "j2k data";
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().endsWith("dat");
            }
        });
        this.setTitle("Optas - Hydro");
        this.setSize(new Dimension(1400, 1000));
        JMenu fileMenu = new JMenu("File");
        JMenu calculationMenu = new JMenu("Calculations");
        JMenuItem exit = new JMenuItem("exit");
        JMenu calcCalibrationSchema = new JMenu("Calculate Calibration Schema");
        JMenuItem calcGreedy = new JMenuItem("Greedy");
        calcGreedy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HydroAnalysisFrame.this.calcOptimationScheme(1);
            }
        });
        JMenuItem calcOptimal = new JMenuItem("Optimal");
        calcOptimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HydroAnalysisFrame.this.calcOptimationScheme(0);
            }
        });
        JMenuItem calcSimilarity = new JMenuItem("Similarity");
        calcSimilarity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HydroAnalysisFrame.this.calcOptimationScheme(2);
            }
        });
        calcCalibrationSchema.add(calcGreedy);
        calcCalibrationSchema.add(calcOptimal);
        calcCalibrationSchema.add(calcSimilarity);
        calculationMenu.add(calcCalibrationSchema);
        fileMenu.add(this.openEnsemble);
        fileMenu.add(this.openObservation);
        fileMenu.add(this.startCalibrationWizard);
        fileMenu.add(this.exportOptimizationScheme);
        fileMenu.add(exit);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HydroAnalysisFrame.this.setVisible(false);
            }
        });
        this.openObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = HydroAnalysisFrame.this.j2kFile_chooser.showOpenDialog(HydroAnalysisFrame.this);
                if (result == 0) {
                    TSDataReader reader = null;
                    try {
                        reader = new TSDataReader(HydroAnalysisFrame.this.j2kFile_chooser.getSelectedFile());
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(null, ioe.toString());
                        ioe.printStackTrace();
                        return;
                    }
                    ArrayList<Object> attr = reader.getNames();
                    SelectionDialog selectionDialog = new SelectionDialog(null, new TreeSet<Object>(attr));
                    String selectedName = (String)selectionDialog.getSelection();
                    int index = 0;
                    for (index = 0; index < attr.size() && !attr.get(index).equals(selectedName); ++index) {
                    }
                }
            }
        });
        this.openEnsemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = GUIHelper.getJFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "data collection";
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getAbsolutePath().endsWith("cdat");
                    }
                });
                int result = chooser.showOpenDialog(HydroAnalysisFrame.this);
                if (result == 0) {
                    HydroAnalysisFrame.this.ensemble = DataCollection.createFromFile(chooser.getSelectedFile());
                    Set<String> obsDatasets = HydroAnalysisFrame.this.ensemble.getDatasets(Measurement.class);
                    Set<String> paramDatasets = HydroAnalysisFrame.this.ensemble.getDatasets(Parameter.class);
                    Set<String> effDatasets = HydroAnalysisFrame.this.ensemble.getDatasets(Efficiency.class);
                    Set<String> simDatasets = HydroAnalysisFrame.this.ensemble.getDatasets(TimeSerie.class);
                    HydroAnalysisFrame.this.obsDatasets.removeAll();
                    HydroAnalysisFrame.this.paramDatasets.removeAll();
                    HydroAnalysisFrame.this.effDatasets.removeAll();
                    HydroAnalysisFrame.this.simDatasets.removeAll();
                    for (String s : obsDatasets) {
                        HydroAnalysisFrame.this.obsDatasets.addItem(s);
                    }
                    for (String s : paramDatasets) {
                        HydroAnalysisFrame.this.paramDatasets.addItem(s);
                    }
                    for (String s : effDatasets) {
                        HydroAnalysisFrame.this.effDatasets.addItem(s);
                    }
                    for (String s : simDatasets) {
                        HydroAnalysisFrame.this.simDatasets.addItem(s);
                    }
                    if (!obsDatasets.isEmpty()) {
                        Measurement measurement = (Measurement)HydroAnalysisFrame.this.ensemble.getDataSet(obsDatasets.iterator().next());
                        HydroAnalysisFrame.this.chart.setHydrograph(measurement);
                    }
                    HydroAnalysisFrame.this.optimizationSchemes.removeAllItems();
                    JOptionPane.showMessageDialog(HydroAnalysisFrame.this, "Ensemble loaded successfully!");
                }
                for (int i = 0; i < HydroAnalysisFrame.this.scheme.length; ++i) {
                    HydroAnalysisFrame.this.scheme[i] = null;
                }
                HydroAnalysisFrame.this.weights = null;
                ((DefaultListModel)HydroAnalysisFrame.this.parameterGroups.getModel()).clear();
                HydroAnalysisFrame.this.optimizationSchemeDesc.setText("");
            }
        });
        this.parameterGroups.setModel(new DefaultListModel());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(calculationMenu);
        this.setJMenuBar(menuBar);
        this.init();
        this.invalidate();
    }

    private void calcWeights() {
        int j;
        int n = 0;
        String simItem = (String)this.simDatasets.getSelectedItem();
        String obsItem = (String)this.obsDatasets.getSelectedItem();
        TimeSerieEnsemble tsEnsemble = this.ensemble.getTimeserieEnsemble(simItem);
        TimeSerie obsTS = (TimeSerie)this.ensemble.getDataSet(obsItem);
        this.weights = SlopeCalculations.calcParameterSensitivityTimeserie(this.ensemble, tsEnsemble, obsTS, 0.33);
        n = this.weights.length;
        TimeSeriesCollection[] collections = new TimeSeriesCollection[n];
        TimeSeries[] timeseries = new TimeSeries[n];
        SimpleEnsemble[] p = SlopeCalculations.getParameterEnsembles(this.ensemble);
        ArrayList<int[]> dominantParameters = OptimizationScheme.calcDominantParameters(this.weights, 0.8);
        for (j = 0; j < n; ++j) {
            collections[j] = new TimeSeriesCollection();
            timeseries[j] = new TimeSeries((Comparable)((Object)p[j].getName()));
            timeseries[j].setMaximumItemCount(dominantParameters.size());
            collections[j].addSeries(timeseries[j]);
        }
        this.parameterIDs = new String[n];
        for (j = 0; j < n; ++j) {
            this.dominantParameterChart.getXYPlot().setDataset(j, (XYDataset)collections[j]);
            this.dominantParameterChart.getXYPlot().setRenderer(j, (XYItemRenderer)this.weightRenderer[0]);
            this.parameterIDs[j] = p[j].getName();
        }
        for (int i = 0; i < dominantParameters.size(); ++i) {
            int[] list = dominantParameters.get(i);
            Arrays.sort(list);
            int c = 0;
            Day di = new Day(obsTS.getTime(i));
            for (int j2 = 0; j2 < n; ++j2) {
                if (list[c] < j2 || list[c] != j2 || c >= list.length - 1) continue;
                ++c;
            }
        }
        SymbolAxis symAxis = new SymbolAxis("parameter", this.parameterIDs);
        symAxis.setRange(-1.0, (double)(n + 1));
        symAxis.setTickUnit(new NumberTickUnit(1.0));
        this.dominantParameterChart.getXYPlot().setRangeAxis((ValueAxis)symAxis);
        this.dominantParameterChart.removeLegend();
    }

    private void init() {
        this.weightChart = new WeightChart();
        this.chart = new HydrographChart();
        this.chart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                HydroAnalysisFrame.this.weightChart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.chart.getXYPlot().getDomainAxis());
                HydroAnalysisFrame.this.dominantParameterChart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.chart.getXYPlot().getDomainAxis());
            }
        });
        this.weightChart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                HydroAnalysisFrame.this.chart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.weightChart.getXYPlot().getDomainAxis());
                HydroAnalysisFrame.this.dominantParameterChart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.weightChart.getXYPlot().getDomainAxis());
            }
        });
        this.dominantParameterChart = ChartFactory.createTimeSeriesChart((String)"Dominant Parameters", (String)"time", (String)"dominant parameters", null, (boolean)true, (boolean)true, (boolean)false);
        this.dominantParameterChart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                HydroAnalysisFrame.this.chart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.dominantParameterChart.getXYPlot().getDomainAxis());
                HydroAnalysisFrame.this.weightChart.getXYPlot().setDomainAxis(HydroAnalysisFrame.this.dominantParameterChart.getXYPlot().getDomainAxis());
            }
        });
        for (int i = 0; i < 9; ++i) {
            this.weightRenderer[i] = new XYLineAndShapeRenderer();
            this.weightRenderer[i].setBaseFillPaint((Paint)this.weightColor[i]);
            this.weightRenderer[i].setBaseLinesVisible(true);
            this.weightRenderer[i].setBaseShapesVisible(false);
            this.weightRenderer[i].setBaseSeriesVisible(true);
            this.weightRenderer[i].setDrawSeriesLineAsPath(true);
            this.weightRenderer[i].setStroke((Stroke)new BasicStroke(1.0f));
        }
        PatchedChartPanel weightChartPanel = new PatchedChartPanel(this.weightChart.getChart(), true);
        PatchedChartPanel chartPanel = new PatchedChartPanel(this.chart.getChart(), true);
        chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity e = event.getEntity();
                if (e != null && e instanceof XYItemEntity) {
                    XYItemEntity xy = (XYItemEntity)e;
                    int index = xy.getSeriesIndex();
                    int data = xy.getItem();
                    System.out.println("index:" + index);
                    System.out.println("data:" + data);
                    SimpleGlobalSensitivityAtPoint sgsat = new SimpleGlobalSensitivityAtPoint(data);
                    try {
                        DataRequestPanel d = new DataRequestPanel(sgsat, HydroAnalysisFrame.this.ensemble);
                        JFrame plotWindow = MCAT5Toolbar.getDefaultPlotWindow("test");
                        plotWindow.add((Component)d, "Center");
                        plotWindow.setVisible(true);
                    }
                    catch (MCAT5Plot.NoDataException nde) {
                        System.out.println(nde.toString());
                    }
                    TimeSeriesCollection collection = (TimeSeriesCollection)HydroAnalysisFrame.this.chart.getXYPlot().getDataset(index);
                    System.out.println(collection.getSeries(0).getDataItem(data).getPeriod());
                    System.out.println(collection.getSeries(0).getDataItem(data).getValue());
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        });
        PatchedChartPanel dominantParametersChartPanel = new PatchedChartPanel(this.dominantParameterChart, true);
        JPanel eastPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        JCheckBox showPeaks = new JCheckBox();
        showPeaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
            }
        });
        JPanel peakPanel = new JPanel();
        peakPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Peaks"));
        peakPanel.add(showPeaks);
        this.peakSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HydroAnalysisFrame.this.peakNumberField.setText(Integer.toString(HydroAnalysisFrame.this.peakSlider.getValue()));
            }
        });
        this.peakNumberField.setEditable(false);
        peakPanel.add(this.peakNumberField);
        JCheckBox showRecessions = new JCheckBox();
        showRecessions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
            }
        });
        JPanel recessionPanel = new JPanel();
        recessionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "recessions"));
        recessionPanel.add(showRecessions);
        recessionPanel.add(this.recessionSlider);
        this.recessionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HydroAnalysisFrame.this.recessionNumberField.setText(Integer.toString(HydroAnalysisFrame.this.recessionSlider.getValue()));
            }
        });
        this.recessionNumberField.setEditable(false);
        recessionPanel.add(this.recessionNumberField);
        JCheckBox showGroundwater = new JCheckBox();
        showGroundwater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
            }
        });
        JPanel groundwaterPanel = new JPanel();
        groundwaterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "groundwater"));
        groundwaterPanel.add(showGroundwater);
        JCheckBox showBaseFlowPeriods = new JCheckBox();
        showBaseFlowPeriods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
            }
        });
        JPanel baseFlowPanel = new JPanel();
        baseFlowPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "baseflow periods"));
        baseFlowPanel.add(showBaseFlowPeriods);
        baseFlowPanel.add(this.groundwaterSlider);
        this.groundwaterSlider.setMinimum(0);
        this.groundwaterSlider.setMaximum(1000);
        this.groundwaterSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HydroAnalysisFrame.this.groundwaterThresholdField.setText(Double.toString((double)HydroAnalysisFrame.this.groundwaterSlider.getValue() / 1000.0 * 5.0));
            }
        });
        this.groundwaterThresholdField.setEditable(false);
        baseFlowPanel.add(this.groundwaterThresholdField);
        eastPanel.add((Component)peakPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        eastPanel.add((Component)recessionPanel, c);
        c.gridx = 2;
        c.gridy = 0;
        eastPanel.add((Component)groundwaterPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        eastPanel.add((Component)baseFlowPanel, c);
        this.obsDatasets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Measurement measurement = (Measurement)HydroAnalysisFrame.this.ensemble.getDataSet((String)e.getItem());
                    HydroAnalysisFrame.this.chart.setHydrograph(measurement);
                }
            }
        });
        JButton efficiencySensitivityComparison = new JButton("Compare Efficiency with Sensitivity");
        efficiencySensitivityComparison.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GllobalSensitivityEfficiencyComparison comparingPlot = new GllobalSensitivityEfficiencyComparison();
                try {
                    DataRequestPanel d = new DataRequestPanel(comparingPlot, HydroAnalysisFrame.this.ensemble);
                    JFrame plotWindow = MCAT5Toolbar.getDefaultPlotWindow("test");
                    plotWindow.add((Component)d, "Center");
                    plotWindow.setVisible(true);
                }
                catch (MCAT5Plot.NoDataException nde) {
                    System.out.println(nde.toString());
                }
            }
        });
        this.parameterGroups.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ((JList)e.getSource()).getSelectedIndex();
                if (index == -1) {
                    return;
                }
                Object schemeItem = HydroAnalysisFrame.this.optimizationSchemes.getSelectedItem();
                if (schemeItem == null) {
                    return;
                }
                OptimizationScheme o = (OptimizationScheme)schemeItem;
                String text = o.solutionGroups.get(index).toString();
                HydroAnalysisFrame.this.optimizationSchemeDesc.setText(text);
            }
        });
        this.optimizationSchemes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                OptimizationScheme myScheme = (OptimizationScheme)HydroAnalysisFrame.this.optimizationSchemes.getSelectedItem();
                ((DefaultListModel)HydroAnalysisFrame.this.parameterGroups.getModel()).clear();
                if (myScheme == null) {
                    JOptionPane.showMessageDialog(HydroAnalysisFrame.this, "First select a method and start calculation!");
                    return;
                }
                int counter = 0;
                for (ParameterGroup p : myScheme.solutionGroups) {
                    ((DefaultListModel)HydroAnalysisFrame.this.parameterGroups.getModel()).addElement("Group" + counter++);
                }
                HydroAnalysisFrame.this.parameterGroups.clearSelection();
                HydroAnalysisFrame.this.optimizationSchemeDesc.setText("");
            }
        });
        this.startCalibrationWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizationScheme myScheme = (OptimizationScheme)HydroAnalysisFrame.this.optimizationSchemes.getSelectedItem();
                if (myScheme == null) {
                    JOptionPane.showMessageDialog(HydroAnalysisFrame.this, "First select a method and start calculation!");
                    return;
                }
            }
        });
        this.exportOptimizationScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizationScheme myScheme = (OptimizationScheme)HydroAnalysisFrame.this.optimizationSchemes.getSelectedItem();
                if (myScheme == null) {
                    JOptionPane.showMessageDialog(HydroAnalysisFrame.this, "First select a method and start calculation!");
                    return;
                }
                JFileChooser chooser = GUIHelper.getJFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "data collection";
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getAbsolutePath().endsWith("xml");
                    }
                });
                try {
                    BeanInfo info = Introspector.getBeanInfo(JAMSCalendar.class);
                    PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
                    for (int i = 0; i < propertyDescriptors.length; ++i) {
                        PropertyDescriptor pd = propertyDescriptors[i];
                        if (pd.getName().equals("milliSeconds") || pd.getName().equals("dateFormat")) continue;
                        pd.setValue("transient", Boolean.TRUE);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                int result = chooser.showSaveDialog(HydroAnalysisFrame.this);
                if (result == 0) {
                    try {
                        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(chooser.getSelectedFile())));
                        encoder.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("Could not save scheme:" + ioe.toString());
                        return;
                    }
                }
            }
        });
        JPanel subPanel = new JPanel(new FlowLayout());
        subPanel.add(efficiencySensitivityComparison);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 4;
        c.anchor = 17;
        eastPanel.add((Component)subPanel, c);
        JPanel subPanel2 = new JPanel(new FlowLayout());
        subPanel2.add(this.obsDatasets);
        subPanel2.add(this.effDatasets);
        subPanel2.add(this.paramDatasets);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        c.anchor = 17;
        eastPanel.add((Component)subPanel2, c);
        JScrollPane optimizationSchemePane = new JScrollPane(this.optimizationSchemeDesc);
        JPanel schemePanel = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.fill = 1;
        schemePanel.add((Component)this.optimizationSchemes, con);
        con.gridx = 0;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 10;
        schemePanel.add((Component)this.parameterGroups, con);
        con.gridx = 1;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 12;
        schemePanel.add((Component)optimizationSchemePane, con);
        c.gridx = 0;
        c.gridy = 5;
        c.gridheight = 6;
        c.gridwidth = 4;
        eastPanel.add((Component)schemePanel, c);
        JPanel mainPanel = new JPanel(new GridLayout(2, 2));
        mainPanel.add((Component)((Object)chartPanel), 0, 0);
        mainPanel.add((Component)((Object)weightChartPanel), 0, 1);
        mainPanel.add((Component)((Object)dominantParametersChartPanel), 1, 0);
        mainPanel.add(eastPanel, 1, 1);
        mainPanel.updateUI();
        this.add(mainPanel);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HydroAnalysisFrame frame = new HydroAnalysisFrame();
        frame.setVisible(true);
    }
}

