/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.Context;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.tools.JAMSTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import optas.gui.wizard.OPTASWizardException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class metaModelOptimizer {
    private static Hashtable<String, AttributeReadWriteSet> mergeTables(Hashtable<String, AttributeReadWriteSet> table, Hashtable<String, AttributeReadWriteSet> subTable) {
        for (String context : subTable.keySet()) {
            AttributeReadWriteSet set = subTable.get(context);
            AttributeReadWriteSet parent_set = table.get(context);
            if (parent_set == null) {
                table.put(context, set);
                continue;
            }
            for (String key : set.attrReadingComponents.keySet()) {
                Set<String> set1 = set.attrReadingComponents.get(key);
                if (parent_set.attrReadingComponents.get(key) != null) {
                    parent_set.attrReadingComponents.get(key).addAll(set1);
                    continue;
                }
                parent_set.attrReadingComponents.put(key, set1);
            }
            for (String key : set.attrWritingComponents.keySet()) {
                Set<String> set1 = set.attrWritingComponents.get(key);
                if (parent_set.attrWritingComponents.get(key) != null) {
                    parent_set.attrWritingComponents.get(key).addAll(set1);
                    continue;
                }
                parent_set.attrWritingComponents.put(key, set1);
            }
        }
        return table;
    }

    private static Hashtable<String, AttributeReadWriteSet> unifyContexts(Hashtable<String, AttributeReadWriteSet> table, Hashtable<String, String> contextEntityAttributes) {
        Hashtable<String, AttributeReadWriteSet> mergedCDGs = new Hashtable<String, AttributeReadWriteSet>();
        for (String key : table.keySet()) {
            AttributeReadWriteSet e = table.get(key);
            Iterator<String> iter2 = mergedCDGs.keySet().iterator();
            boolean EntityAdded = false;
            while (iter2.hasNext()) {
                AttributeReadWriteSet e2 = mergedCDGs.get(iter2.next());
                if (contextEntityAttributes.get(e.contextName) == null || contextEntityAttributes.get(e2.contextName) == null || !contextEntityAttributes.get(e.contextName).equals(contextEntityAttributes.get(e2.contextName))) continue;
                for (String key1 : e.attrReadingComponents.keySet()) {
                    Set<String> set1 = e.attrReadingComponents.get(key1);
                    if (e2.attrReadingComponents.get(key1) != null) {
                        e2.attrReadingComponents.get(key1).addAll(set1);
                        continue;
                    }
                    e2.attrReadingComponents.put(key1, set1);
                }
                for (String key1 : e.attrWritingComponents.keySet()) {
                    Set<String> set1 = e.attrWritingComponents.get(key1);
                    if (e2.attrWritingComponents.get(key1) != null) {
                        e2.attrWritingComponents.get(key1).addAll(set1);
                        continue;
                    }
                    e2.attrWritingComponents.put(key1, set1);
                }
                EntityAdded = true;
            }
            if (EntityAdded) continue;
            mergedCDGs.put(key, e);
        }
        return mergedCDGs;
    }

    public static Set<String> CollectAttributeWritingComponents(Node root, Model model, String attribute, String context) {
        if (context == null || attribute == null) {
            System.err.println("error: no context or attribute for:" + context + "." + attribute);
            return null;
        }
        Hashtable<String, String> contextEntityAttributes = new Hashtable<String, String>();
        Hashtable<String, AttributeReadWriteSet> result = metaModelOptimizer.getAttributeReadWriteSet(root, (Component)model, model.getName(), contextEntityAttributes);
        if (result == null) {
            System.err.println("error: could not get attribute read write set!");
            return null;
        }
        AttributeReadWriteSet attrRwSet = result.get(context);
        if (attrRwSet == null) {
            System.err.println("error: no rw set for context: " + context + "and attribute:" + attribute);
            return null;
        }
        return result.get((Object)context).attrWritingComponents.get(attribute);
    }

    public static Hashtable<String, AttributeReadWriteSet> getAttributeReadWriteSet(Node root, Component parent, String currentContext, Hashtable<String, String> contextEntityAttributes) {
        NodeList childs = root.getChildNodes();
        Hashtable<String, AttributeReadWriteSet> table = new Hashtable<String, AttributeReadWriteSet>();
        for (int index = 0; index < childs.getLength(); ++index) {
            Hashtable<String, AttributeReadWriteSet> subTable;
            Component comp;
            String name;
            Element elem;
            Node node = childs.item(index);
            if (node.getNodeName().equals("contextcomponent") || node.getNodeName().equals("model")) {
                elem = (Element)node;
                name = elem.getAttribute("name");
                comp = ((Context)parent).getComponent(name);
                subTable = metaModelOptimizer.getAttributeReadWriteSet(node, comp, name, contextEntityAttributes);
                table = metaModelOptimizer.mergeTables(subTable, table);
            }
            if (node.getNodeName().equals("component")) {
                elem = (Element)node;
                name = elem.getAttribute("name");
                comp = ((Context)parent).getComponent(name);
                subTable = metaModelOptimizer.getAttributeReadWriteSet(node, comp, currentContext, contextEntityAttributes);
                table = metaModelOptimizer.mergeTables(subTable, table);
            }
            if (!node.getNodeName().equals("var")) continue;
            elem = (Element)node;
            name = elem.getAttribute("name");
            String attr = elem.getAttribute("attribute");
            String context = null;
            if (attr.equals("")) continue;
            context = elem.getAttribute("context");
            if (context.equals("")) {
                context = currentContext;
            }
            if (parent instanceof JAMSContext) {
                contextEntityAttributes.put(currentContext, attr);
            }
            Field f = null;
            try {
                f = JAMSTools.getField(parent.getClass(), (String)name);
                AttributeReadWriteSet attrRWSet = table.get(context);
                if (attrRWSet == null) {
                    attrRWSet = new AttributeReadWriteSet();
                    table.put(context, attrRWSet);
                    attrRWSet.contextName = context;
                }
                StringTokenizer tok = new StringTokenizer(attr, ";");
                while (tok.hasMoreTokens()) {
                    TreeSet<String> attrSet;
                    String singleAttr = tok.nextToken();
                    if (Attribute.Entity.class.isAssignableFrom(f.getType()) || Attribute.EntityCollection.class.isAssignableFrom(f.getType())) {
                        if (attrRWSet.attrReadingComponents.get(singleAttr) != null) {
                            attrRWSet.attrReadingComponents.get(singleAttr).add(parent.getInstanceName());
                        } else {
                            attrSet = new TreeSet<String>();
                            attrSet.add(parent.getInstanceName());
                            attrRWSet.attrReadingComponents.put(singleAttr, attrSet);
                        }
                        if (attrRWSet.attrWritingComponents.get(singleAttr) != null) {
                            attrRWSet.attrWritingComponents.get(singleAttr).add(parent.getInstanceName());
                        } else {
                            attrSet = new TreeSet();
                            attrSet.add(parent.getInstanceName());
                            attrRWSet.attrWritingComponents.put(singleAttr, attrSet);
                        }
                    } else if (f.getAnnotation(JAMSVarDescription.class).access() == JAMSVarDescription.AccessType.READ || f.getAnnotation(JAMSVarDescription.class).access() == JAMSVarDescription.AccessType.READWRITE) {
                        if (attrRWSet.attrReadingComponents.get(singleAttr) != null) {
                            attrRWSet.attrReadingComponents.get(singleAttr).add(parent.getInstanceName());
                        } else {
                            attrSet = new TreeSet();
                            attrSet.add(parent.getInstanceName());
                            attrRWSet.attrReadingComponents.put(singleAttr, attrSet);
                        }
                    }
                    if (f.getAnnotation(JAMSVarDescription.class).access() != JAMSVarDescription.AccessType.WRITE && f.getAnnotation(JAMSVarDescription.class).access() != JAMSVarDescription.AccessType.READWRITE && !Attribute.Entity.class.isAssignableFrom(f.getType()) && !Attribute.EntityCollection.class.isAssignableFrom(f.getType())) continue;
                    if (attrRWSet.attrWritingComponents.get(singleAttr) != null) {
                        attrRWSet.attrWritingComponents.get(singleAttr).add(parent.getInstanceName());
                        continue;
                    }
                    attrSet = new TreeSet();
                    attrSet.add(parent.getInstanceName());
                    attrRWSet.attrWritingComponents.put(singleAttr, attrSet);
                }
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        return table;
    }

    public static void ExportGDLFile(Hashtable<String, Set<String>> edges, Set<String> removedNodes, String fileName) {
        if (removedNodes == null) {
            removedNodes = new TreeSet<String>();
        }
        TreeSet<String> nodes = new TreeSet<String>();
        for (String key : edges.keySet()) {
            nodes.add(key);
            Set<String> endNodes = edges.get(key);
            nodes.addAll(endNodes);
        }
        String GDLContext = new String();
        GDLContext = "graph: {layoutalgorithm : forcedir\ncolorentry 32: 219 44 44\nfinetuning: yes\norientation: left_to_right\ncolorentry 1: 210 218 255\nnode.color      : 1\nnode.textcolor  : black\nsmanhattanedges: yes\narrowmode:free\nnode.fontname   : \"Times New Roman\"\nnode.borderwidth: 1\nedge.thickness  : 1\nedge.color      : black\nedge.arrowstyle : solid\nedge.arrowsize :  10\narrowmode       : free\nportsharing     : yes\nnode.shape: ellipse\nattraction   : 80\nrepulsion    : 1000\nenergetic : yes\nenergetic overlapping : 10000\nenergetic border : 0\nenergetic attraction: 0\nenergetic crossing:0\nenergetic repulsion:0\nenergetic gravity:0\ngravity      : 10.0\nfdmax        : 50\ntempmax      : 254\ntemptreshold : 3\ntempscheme   : 2\ntempfactor   : 1.08\nrandomfactor : 100\n";
        for (String name : nodes) {
            if (removedNodes.contains(name)) {
                GDLContext = GDLContext + "node: {color:red title: \"" + name + "\"}\n";
                continue;
            }
            GDLContext = GDLContext + "node: {title: \"" + name + "\"}\n";
        }
        for (String key : edges.keySet()) {
            for (String dest : edges.get(key)) {
                GDLContext = GDLContext + "edge: { source: \"" + key + "\" target:\"" + dest + "\" }";
            }
        }
        GDLContext = GDLContext + "}";
        try {
            BufferedWriter GDLFileWriter = new BufferedWriter(new FileWriter(fileName));
            GDLFileWriter.write(GDLContext);
            GDLFileWriter.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static Hashtable<String, Set<String>> getDependencyGraph(Node root, Model model) {
        Hashtable<String, Set<String>> edges = new Hashtable<String, Set<String>>();
        Hashtable<String, String> contextEntityAttributes = new Hashtable<String, String>();
        Hashtable<String, AttributeReadWriteSet> CAttrRWSet = metaModelOptimizer.unifyContexts(metaModelOptimizer.getAttributeReadWriteSet(root, (Component)model, model.getInstanceName(), contextEntityAttributes), contextEntityAttributes);
        HashMap<String, Set<String>> writeAccessComponents = null;
        HashMap<String, Set<String>> readAccessComponents = null;
        Iterator<String> iter = CAttrRWSet.keySet().iterator();
        while (iter.hasNext()) {
            AttributeReadWriteSet e = CAttrRWSet.get(iter.next());
            writeAccessComponents = e.attrWritingComponents;
            readAccessComponents = e.attrReadingComponents;
            for (String attr : writeAccessComponents.keySet()) {
                Set writeAccess = (Set)writeAccessComponents.get(attr);
                Set readAccess = (Set)readAccessComponents.get(attr);
                if (readAccess == null || writeAccess == null) continue;
                for (String writeAccessComponent : writeAccess) {
                    for (String readAccessComponent : readAccess) {
                        if (edges.containsKey(readAccessComponent)) {
                            edges.get(readAccessComponent).add(writeAccessComponent);
                            continue;
                        }
                        TreeSet<String> list = new TreeSet<String>();
                        list.add(writeAccessComponent);
                        edges.put(readAccessComponent, list);
                    }
                }
            }
        }
        return edges;
    }

    public static Hashtable<String, Set<String>> TransitiveClosure(Hashtable<String, Set<String>> graph) {
        Hashtable<String, Set<String>> TransitiveClosure = new Hashtable<String, Set<String>>();
        Set<String> keys = graph.keySet();
        for (String key : keys) {
            Set<String> value = graph.get(key);
            TreeSet<String> set = new TreeSet<String>();
            set.addAll(value);
            TransitiveClosure.put(key, set);
        }
        boolean change = true;
        while (change) {
            change = false;
            Set<String> aSet = TransitiveClosure.keySet();
            for (String a : keys) {
                Set<String> bSet = TransitiveClosure.get(a);
                if (bSet == null) continue;
                Iterator<String> b_iter = bSet.iterator();
                TreeSet<String> modification = new TreeSet<String>();
                while (b_iter.hasNext()) {
                    String b = b_iter.next();
                    Set<String> cSet = TransitiveClosure.get(b);
                    if (cSet == null) continue;
                    for (String c : cSet) {
                        if (bSet.contains(c)) continue;
                        modification.add(c);
                        change = true;
                    }
                }
                bSet.addAll(modification);
            }
        }
        return TransitiveClosure;
    }

    public static Node getNodeByName(Node root, String name) {
        if (root.getNodeName().equals(name)) {
            return root;
        }
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node model = metaModelOptimizer.getNodeByName(childs.item(i), name);
            if (model == null) continue;
            return model;
        }
        return null;
    }

    public static ArrayList<String> RemoveGUIComponents(Node root) throws OPTASWizardException {
        ArrayList<String> removedComponents = new ArrayList<String>();
        NodeList childs = root.getChildNodes();
        Document mainRoot = root.getOwnerDocument();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        for (int index = 0; index < childs.getLength(); ++index) {
            Element comp;
            Node node = childs.item(index);
            if (node.getNodeName().equals("contextcomponent")) {
                removedComponents.addAll(metaModelOptimizer.RemoveGUIComponents(node));
                continue;
            }
            if (!node.getNodeName().equals("component") || !(comp = (Element)node).getAttribute("class").contains("jams.components.gui")) continue;
            childsToRemove.add(node);
        }
        for (int i = 0; i < childsToRemove.size(); ++i) {
            Element elem = (Element)childsToRemove.get(i);
            removedComponents.add(elem.getAttribute("name"));
            root.removeChild((Node)childsToRemove.get(i));
        }
        if (metaModelOptimizer.getNodeByName(mainRoot, "launcher") != null) {
            metaModelOptimizer.removeUnlinkedProperties(root);
        }
        removedComponents.addAll(metaModelOptimizer.RemoveEmptyContextes(root));
        return removedComponents;
    }

    public static ArrayList<String> RemoveEmptyContextes(Node root) {
        NodeList childs = root.getChildNodes();
        ArrayList<String> removedNodes = new ArrayList<String>();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        for (int index = 0; index < childs.getLength(); ++index) {
            int subIndex;
            boolean isEmpty;
            NodeList subChilds;
            Node node = childs.item(index);
            if (node.getNodeName().equals("subgroup")) {
                subChilds = node.getChildNodes();
                isEmpty = true;
                for (subIndex = 0; subIndex < subChilds.getLength(); ++subIndex) {
                    if (!subChilds.item(subIndex).getNodeName().equals("property")) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    childsToRemove.add(node);
                }
            }
            if (node.getNodeName().equals("group")) {
                subChilds = node.getChildNodes();
                isEmpty = true;
                for (subIndex = 0; subIndex < subChilds.getLength(); ++subIndex) {
                    if (!subChilds.item(subIndex).getNodeName().equals("subgroup") && !subChilds.item(subIndex).getNodeName().equals("property")) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    childsToRemove.add(node);
                }
            }
            if (node.getNodeName().equals("contextcomponent")) {
                subChilds = node.getChildNodes();
                isEmpty = true;
                for (subIndex = 0; subIndex < subChilds.getLength(); ++subIndex) {
                    if (!subChilds.item(subIndex).getNodeName().equals("component") && !subChilds.item(subIndex).getNodeName().equals("contextcomponent")) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    childsToRemove.add(node);
                }
            }
            removedNodes.addAll(metaModelOptimizer.RemoveEmptyContextes(node));
        }
        for (int i = 0; i < childsToRemove.size(); ++i) {
            Element elem = (Element)childsToRemove.get(i);
            removedNodes.add(elem.getAttribute("name"));
            root.removeChild(elem);
        }
        if (removedNodes.size() > 0) {
            removedNodes.addAll(metaModelOptimizer.RemoveEmptyContextes(root));
        }
        return removedNodes;
    }

    public static ArrayList<String> RemoveNotListedComponents(Node root, Set<String> list) throws OPTASWizardException {
        NodeList childs = root.getChildNodes();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        ArrayList<String> removedNodes = new ArrayList<String>();
        Document mainRoot = root.getOwnerDocument();
        for (int index = 0; index < childs.getLength(); ++index) {
            Element comp;
            Node node = childs.item(index);
            if (node.getNodeName().equals("contextcomponent")) {
                removedNodes.addAll(metaModelOptimizer.RemoveNotListedComponents(node, list));
                continue;
            }
            if (!node.getNodeName().equals("component") || list.contains((comp = (Element)node).getAttribute("name"))) continue;
            childsToRemove.add(node);
        }
        for (int i = 0; i < childsToRemove.size(); ++i) {
            Element elem = (Element)childsToRemove.get(i);
            removedNodes.add(elem.getAttribute("name"));
            root.removeChild((Node)childsToRemove.get(i));
        }
        if (metaModelOptimizer.getNodeByName(mainRoot, "launcher") != null) {
            metaModelOptimizer.removeUnlinkedProperties(root);
        }
        removedNodes.addAll(metaModelOptimizer.RemoveEmptyContextes(root));
        return removedNodes;
    }

    public static Node getNode(Node root, String owner) {
        Element elem;
        if (root.getNodeName().equals("context") && (elem = (Element)root).getAttribute("name").equals(owner)) {
            return root;
        }
        if (root.getNodeName().equals("component") && (elem = (Element)root).getAttribute("name").equals(owner)) {
            return root;
        }
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node value = metaModelOptimizer.getNode(childs.item(i), owner);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static void removeUnlinkedProperties(Node root) throws OPTASWizardException {
        Element launcherNode = (Element)metaModelOptimizer.getNodeByName(root, "launcher");
        if (launcherNode == null) {
            throw new OPTASWizardException("model does not contain launcher node!");
        }
        ArrayList<Element> nodesToRemove = new ArrayList<Element>();
        NodeList groupNodes = launcherNode.getElementsByTagName("group");
        for (int gindex = 0; gindex < groupNodes.getLength(); ++gindex) {
            Node node = groupNodes.item(gindex);
            Element element = (Element)node;
            NodeList groupChildNodes = element.getChildNodes();
            for (int pindex = 0; pindex < groupChildNodes.getLength(); ++pindex) {
                Element propertyElement;
                String comp;
                node = groupChildNodes.item(pindex);
                if (node.getNodeName().equalsIgnoreCase("property") && metaModelOptimizer.getNode(root, comp = (propertyElement = (Element)node).getAttribute("component")) == null) {
                    nodesToRemove.add(propertyElement);
                }
                if (!node.getNodeName().equalsIgnoreCase("subgroup")) continue;
                Element subgroupElement = (Element)node;
                NodeList propertyNodes = subgroupElement.getElementsByTagName("property");
                for (int kindex = 0; kindex < propertyNodes.getLength(); ++kindex) {
                    Element propertyElement2 = (Element)propertyNodes.item(kindex);
                    String comp2 = propertyElement2.getAttribute("component");
                    if (metaModelOptimizer.getNode(root, comp2) != null) continue;
                    nodesToRemove.add(propertyElement2);
                }
            }
        }
        for (Node node : nodesToRemove) {
            node.getParentNode().removeChild(node);
        }
    }

    public static Set<String> GetRelevantComponentsList(Hashtable<String, Set<String>> dependencyGraph, Set<String> EffWritingComponentsList) {
        TreeSet<String> compList = new TreeSet<String>();
        for (String wr_comp : EffWritingComponentsList) {
            Set<String> set = dependencyGraph.get(wr_comp);
            if (set != null) {
                compList.addAll(set);
            }
            compList.add(wr_comp);
        }
        return compList;
    }

    public static class AttributeReadWriteSet {
        String contextName;
        HashMap<String, Set<String>> attrWritingComponents = new HashMap();
        HashMap<String, Set<String>> attrReadingComponents = new HashMap();

        AttributeReadWriteSet() {
        }
    }
}

