/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.gui.input.TableInput;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import optas.data.TimeFilter;
import optas.data.TimeFilterCollection;
import optas.data.TimeSerie;
import optas.gui.wizard.TimeFilterDialog;

class TimeFilterTableInput
extends TableInput {
    TimeSerie timeserie;
    TimeFilterDialog tfd = null;
    ArrayList<TimeFilterTableInputListener> listeners = new ArrayList();
    ArrayList<Integer> selectedRows = new ArrayList();

    public TimeFilterTableInput(TimeSerie timeserie) {
        super(new String[]{JAMS.i18n((String)"enabled"), JAMS.i18n((String)"inverted"), JAMS.i18n((String)"log_operation"), JAMS.i18n((String)"description")}, new Class[]{Boolean.class, Boolean.class, Boolean.class, String.class}, new boolean[]{true, true, true, false}, true);
        this.timeserie = timeserie;
        this.getTable().setAutoResizeMode(4);
        int width = 75;
        TableColumn col = this.getTable().getColumnModel().getColumn(0);
        col.setPreferredWidth(width);
        col = this.getTable().getColumnModel().getColumn(1);
        col.setPreferredWidth(width);
        col = this.getTable().getColumnModel().getColumn(2);
        col.setPreferredWidth(width);
        col.setCellRenderer(new AndOrRenderer(true));
        col = this.getTable().getColumnModel().getColumn(3);
        col.setPreferredWidth(4 * width);
        this.getTable().setRowHeight(25);
        ((AbstractTableModel)this.getTable().getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                for (Object[] row : TimeFilterTableInput.this.tableData.getValue()) {
                    if (row[0] instanceof Boolean) {
                        ((TimeFilter)row[3]).setEnabled((Boolean)row[0]);
                    }
                    if (row[1] instanceof Boolean) {
                        ((TimeFilter)row[3]).setInverted((Boolean)row[1]);
                    }
                    if (!(row[2] instanceof Boolean)) continue;
                    ((TimeFilter)row[3]).setAdditive((Boolean)row[2]);
                }
                for (TimeFilterTableInputListener tftiListener : TimeFilterTableInput.this.listeners) {
                    tftiListener.itemChanged(TimeFilterTableInput.this);
                }
            }
        });
        this.setPreferredSize(new Dimension(375, 200));
        if (timeserie == null) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public void addChangeListener(TimeFilterTableInputListener tftiListener) {
        this.listeners.add(tftiListener);
    }

    public void removeChangeListener(TimeFilterTableInputListener tftiListener) {
        this.listeners.remove(tftiListener);
    }

    public void clear() {
        this.tableData.setValue(new ArrayList());
    }

    protected void editItem() {
        int selection = this.getTable().getSelectedRow();
        if (selection == -1) {
            return;
        }
        Object selectedData = this.tableData.getElementAt(selection)[3];
        if (selectedData instanceof TimeFilter) {
            this.tfd = new TimeFilterDialog(this.timeserie);
            this.tfd.init(this.timeserie, (TimeFilter)selectedData);
            this.tfd.setModal(true);
            this.tfd.setVisible(true);
            if (this.tfd.getApproval()) {
                TimeFilter filter = this.tfd.getFilter();
                this.tableData.setElementAt(selection, new Object[]{new Boolean(filter.isEnabled()), new Boolean(filter.isInverted()), new Boolean(filter.isAdditive()), filter});
                for (TimeFilterTableInputListener tftiListener : this.listeners) {
                    tftiListener.tableChanged(this);
                }
            }
        }
    }

    protected void removeItem() {
        super.removeItem();
        for (TimeFilterTableInputListener tftiListener : this.listeners) {
            tftiListener.tableChanged(this);
        }
    }

    private void addItem(TimeFilter filter) {
        if (filter != null) {
            this.tableData.addElement(new Object[]{new Boolean(filter.isEnabled()), new Boolean(filter.isInverted()), new Boolean(filter.isAdditive()), filter});
            this.setTableData(this.tableData.getValue());
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
        }
        for (TimeFilterTableInputListener tftiListener : this.listeners) {
            tftiListener.tableChanged(this);
        }
    }

    protected void addItem() {
        this.tfd = new TimeFilterDialog(this.timeserie);
        this.tfd.setVisible(true);
        if (this.tfd.getApproval()) {
            TimeFilter filter = this.tfd.getFilter();
            this.addItem(filter);
        }
    }

    public TimeFilterCollection getTimeFilters() {
        TimeFilterCollection timeFilters = new TimeFilterCollection();
        for (Object[] o : this.getTableData()) {
            timeFilters.add((TimeFilter)o[3]);
        }
        return timeFilters;
    }

    public void setSelectedItem(TimeFilter selection) {
        if (selection == null) {
            this.getTable().getSelectionModel().clearSelection();
            return;
        }
        int i = 0;
        for (Object[] o : this.getTableData()) {
            if (selection.equals((TimeFilter)o[3])) {
                this.getTable().getSelectionModel().addSelectionInterval(i, i);
            }
            ++i;
        }
    }

    public void setTimeFilters(TimeFilterCollection timeFilters) {
        this.clear();
        for (TimeFilter filter : timeFilters.get()) {
            this.tableData.addElement(new Object[]{new Boolean(filter.isEnabled()), new Boolean(filter.isInverted()), new Boolean(filter.isAdditive()), filter});
        }
        this.setTableData(this.tableData.getValue());
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
        for (TimeFilterTableInputListener tftiListener : this.listeners) {
            tftiListener.tableChanged(this);
        }
    }

    public void setTimeSeries(TimeSerie timeserie) {
        this.timeserie = timeserie;
    }

    public class AndOrRenderer
    extends JButton
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public AndOrRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object andor, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean newValue = (Boolean)andor;
            this.setMargin(new Insets(1, 1, 1, 1));
            if (newValue.booleanValue()) {
                this.setText("AND");
            } else {
                this.setText("OR");
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    public static abstract class TimeFilterTableInputListener {
        int event;

        public abstract void tableChanged(TimeFilterTableInput var1);

        public abstract void itemChanged(TimeFilterTableInput var1);
    }
}

