/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.gui.input.CalendarInput;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import optas.data.DataCollection;
import optas.data.TimeFilter;
import optas.data.TimeFilterFactory;
import optas.data.TimeSerie;
import optas.gui.wizard.HydrographChart;
import optas.tools.PatchedChartPanel;

public class TimeFilterDialog
extends JDialog {
    TimeSerie timeserie;
    TimeFilter filter;
    JList yearList = new JList();
    JCheckBox hydrologicYearBox = new JCheckBox(JAMS.i18n((String)"Hydrologic_Year"));
    private final JList monthList = new JList<String>(new String[]{JAMS.i18n((String)"January"), JAMS.i18n((String)"Febuary"), JAMS.i18n((String)"March"), JAMS.i18n((String)"April"), JAMS.i18n((String)"May"), JAMS.i18n((String)"June"), JAMS.i18n((String)"July"), JAMS.i18n((String)"August"), JAMS.i18n((String)"September"), JAMS.i18n((String)"October"), JAMS.i18n((String)"November"), JAMS.i18n((String)"December")});
    static final String springString = JAMS.i18n((String)"Spring");
    static final String summerString = JAMS.i18n((String)"Summer");
    static final String autumnString = JAMS.i18n((String)"Autumn");
    static final String winterString = JAMS.i18n((String)"Winter");
    static final String winterHalfYearString = JAMS.i18n((String)"Winter_halfyear");
    static final String summerHalfYearString = JAMS.i18n((String)"Summer_halfyear");
    JComboBox seasonBox = new JComboBox<String>(new String[]{springString, summerString, autumnString, winterString, winterHalfYearString, summerHalfYearString});
    JTextField baseFlowRunoffQuantity = new JTextField(10);
    JRadioButton baseFlowFixedEstimation = new JRadioButton(JAMS.i18n((String)"constant_threshold"));
    JRadioButton baseFlowLocalMiniumEstimation = new JRadioButton(JAMS.i18n((String)"Local_minimum"));
    HydrographChart hydrographBaseFlow = null;
    HydrographChart eventFilterHydrograph = null;
    HydrographChart rangeFilterHydrograph = null;
    JButton updateBn = new JButton(JAMS.i18n((String)"update"));
    static final String raisingEdgeString = JAMS.i18n((String)"raising_limb");
    static final String peakString = JAMS.i18n((String)"peak");
    static final String fallingEdgeString = JAMS.i18n((String)"falling_limb");
    JComboBox hydroEventTypeBox = new JComboBox<String>(new String[]{raisingEdgeString, peakString, fallingEdgeString});
    JTextField windowSizeField = new JTextField(10);
    JSlider qualitySlider = new JSlider();
    JLabel timeperiodLabel = new JLabel();
    JTextField qualitySliderValue = new JTextField(10);
    CalendarInput rangeFilterStartDateInput = new CalendarInput();
    CalendarInput rangeFilterEndDateInput = new CalendarInput();
    boolean isApproved = false;
    ActionListener updateHydroEventListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeFilterDialog.this.eventFilterHydrograph.clearTimeFilter();
            TimeFilterDialog.this.eventFilterHydrograph.addTimeFilter(TimeFilterDialog.this.constructHydroEventFilter());
        }
    };
    ActionListener updateBaseFlowListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeFilterDialog.this.hydrographBaseFlow.clearTimeFilter();
            TimeFilterDialog.this.hydrographBaseFlow.addTimeFilter(TimeFilterDialog.this.constructBaseFlowFilter());
        }
    };

    public TimeFilterDialog(TimeSerie timeserie) {
        super(GUIState.getMainWindow());
        this.timeserie = timeserie;
        this.init(timeserie, null);
    }

    public static boolean isApplicable(DataCollection dc) {
        return !dc.getDatasets(TimeSerie.class).isEmpty();
    }

    private JPanel constructYearTimeFilterPanel(TimeFilterFactory.YearlyTimeFilter filter) {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Select_years")));
        Attribute.TimeInterval t = this.timeserie.getTimeDomain();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(t.getStart().getTime());
        int startYear = calendar.get(1);
        calendar.setTime(t.getEnd().getTime());
        int endYear = calendar.get(1);
        DefaultListModel<Integer> model = new DefaultListModel<Integer>();
        for (int i = 0; i <= endYear - startYear; ++i) {
            model.add(i, new Integer(i + startYear));
        }
        this.yearList.setModel(model);
        this.yearList.setSelectionMode(2);
        JScrollPane yearlyListScrollPane = new JScrollPane(this.yearList);
        filterPanel.add((Component)yearlyListScrollPane, "Center");
        if (filter != null) {
            int[] selectedYears = filter.getYears();
            int[] indicies = new int[selectedYears.length];
            for (int i = 0; i < indicies.length; ++i) {
                indicies[i] = selectedYears[i] - startYear;
            }
            this.yearList.setSelectedIndices(indicies);
            this.hydrologicYearBox.setSelected(filter.isHydrologicYear());
        }
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)this.hydrologicYearBox, "Center");
        dataPanel.add((Component)new JButton(JAMS.i18n((String)"OK")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object[] oYears = TimeFilterDialog.this.yearList.getSelectedValues();
                        int[] years = new int[oYears.length];
                        for (int i = 0; i < oYears.length; ++i) {
                            years[i] = (Integer)oYears[i];
                        }
                        TimeFilterDialog.this.filter = TimeFilterFactory.getYearlyFilter(years, TimeFilterDialog.this.hydrologicYearBox.isSelected());
                        TimeFilterDialog.this.isApproved = true;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        }, "South");
        filterPanel.add((Component)dataPanel, "South");
        return filterPanel;
    }

    private JPanel constructMonthlyTimeFilterPanel(TimeFilterFactory.MonthlyTimeFilter filter) {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Select months")));
        this.monthList.setSelectionMode(2);
        filterPanel.add((Component)this.monthList, "Center");
        if (filter != null) {
            this.monthList.setSelectedIndices(filter.getMonths());
        }
        this.seasonBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(springString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{3, 4, 5});
                }
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(summerString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{6, 7, 8});
                }
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(autumnString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{9, 10, 11});
                }
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(winterString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{0, 1, 2});
                }
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(summerHalfYearString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{4, 5, 6, 7, 8, 9});
                }
                if (TimeFilterDialog.this.seasonBox.getSelectedItem().equals(winterHalfYearString)) {
                    TimeFilterDialog.this.monthList.setSelectedIndices(new int[]{9, 10, 11, 0, 1, 2});
                }
            }
        });
        filterPanel.add((Component)this.seasonBox, "North");
        filterPanel.add((Component)new JButton(JAMS.i18n((String)"Ok")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] oMonths = TimeFilterDialog.this.monthList.getSelectedIndices();
                        TimeFilterDialog.this.filter = TimeFilterFactory.getMonthlyFilter(oMonths);
                        TimeFilterDialog.this.isApproved = true;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        }, "South");
        return filterPanel;
    }

    private TimeFilter constructHydroEventFilter() {
        int windowSize;
        try {
            windowSize = Integer.parseInt(this.windowSizeField.getText());
        }
        catch (NumberFormatException pe) {
            JOptionPane.showMessageDialog(this.rootPane, JAMS.i18n((String)"Please_enter_a_valid_window_size"));
            windowSize = TimeFilterFactory.EventFilter.DEFAULT_WINDOWSIZE;
        }
        TimeFilterFactory.EventFilter filter = null;
        if (this.hydroEventTypeBox.getSelectedItem().equals(raisingEdgeString)) {
            filter = TimeFilterFactory.getEventFilter(this.timeserie, TimeFilterFactory.EventFilter.EventType.RaisingEdge, windowSize);
        } else if (this.hydroEventTypeBox.getSelectedItem().equals(fallingEdgeString)) {
            filter = TimeFilterFactory.getEventFilter(this.timeserie, TimeFilterFactory.EventFilter.EventType.Recession, windowSize);
        } else if (this.hydroEventTypeBox.getSelectedItem().equals(peakString)) {
            filter = TimeFilterFactory.getEventFilter(this.timeserie, TimeFilterFactory.EventFilter.EventType.Peak, windowSize);
        }
        if (filter == null) {
            return null;
        }
        filter.setQualityThreshold((double)this.qualitySlider.getValue() / 100.0);
        this.qualitySlider.setMinimum((int)(filter.getMinQuality() * 100.0));
        this.qualitySlider.setMaximum((int)(filter.getMaxQuality() * 100.0));
        return filter;
    }

    private TimeFilter constructRangeFilter() {
        Attribute.Calendar cStart = this.rangeFilterStartDateInput.getCalendarValue();
        Attribute.Calendar cEnd = this.rangeFilterEndDateInput.getCalendarValue();
        if (cStart == null || cEnd == null) {
            return null;
        }
        Attribute.TimeInterval I = DefaultDataFactory.getDataFactory().createTimeInterval();
        I.setValue(this.timeserie.getTimeDomain().getValue());
        I.setStart(cStart);
        I.setEnd(cEnd);
        return TimeFilterFactory.getRangeFilter(I);
    }

    private JPanel constructRangeFilterPanel(TimeSerie m, TimeFilterFactory.RangeTimeFilter f) {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Define_range_filter")));
        this.rangeFilterHydrograph = new HydrographChart();
        JPanel northPanel = new JPanel(new FlowLayout());
        JPanel confPanel = new JPanel(new FlowLayout());
        confPanel.add(new JLabel(JAMS.i18n((String)"Select_start_date")));
        confPanel.add((Component)this.rangeFilterStartDateInput);
        confPanel.add(new JLabel(JAMS.i18n((String)"Select_end_date")));
        confPanel.add((Component)this.rangeFilterEndDateInput);
        confPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Configuration")));
        northPanel.add((Component)confPanel, "Center");
        filterPanel.add((Component)northPanel, "North");
        PatchedChartPanel chartPanel = this.rangeFilterHydrograph.getChartPanel();
        filterPanel.add((Component)((Object)chartPanel), "Center");
        filterPanel.add((Component)new JButton(JAMS.i18n((String)"Ok")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeFilterDialog.this.filter = TimeFilterDialog.this.constructRangeFilter();
                        TimeFilterDialog.this.isApproved = true;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        }, "South");
        this.rangeFilterStartDateInput.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                TimeFilterDialog.this.filter = TimeFilterDialog.this.constructRangeFilter();
                if (TimeFilterDialog.this.rangeFilterEndDateInput.getCalendarValue() == null) {
                    TimeFilterDialog.this.rangeFilterEndDateInput.setValue(TimeFilterDialog.this.rangeFilterStartDateInput.getValue());
                }
                if (TimeFilterDialog.this.filter == null) {
                    return;
                }
                TimeFilterDialog.this.rangeFilterHydrograph.clearTimeFilter();
                TimeFilterDialog.this.rangeFilterHydrograph.addTimeFilter(TimeFilterDialog.this.filter);
            }
        });
        this.rangeFilterEndDateInput.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                TimeFilterDialog.this.filter = TimeFilterDialog.this.constructRangeFilter();
                if (TimeFilterDialog.this.filter == null) {
                    return;
                }
                TimeFilterDialog.this.rangeFilterHydrograph.clearTimeFilter();
                TimeFilterDialog.this.rangeFilterHydrograph.addTimeFilter(TimeFilterDialog.this.filter);
            }
        });
        if (m != null && f == null) {
            this.rangeFilterStartDateInput.setValue(m.getTimeDomain().getStart());
            this.rangeFilterEndDateInput.setValue(m.getTimeDomain().getEnd());
        }
        if (f != null) {
            this.rangeFilterStartDateInput.setValue(f.getRange().getStart());
            this.rangeFilterEndDateInput.setValue(f.getRange().getEnd());
        }
        this.rangeFilterHydrograph.setHydrograph(m);
        return filterPanel;
    }

    private JPanel constructHydroEventFilterPanel(TimeSerie m, TimeFilterFactory.EventFilter filter) {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Select_hydrograph_event_filter")));
        this.eventFilterHydrograph = new HydrographChart();
        JPanel northPanel = new JPanel(new FlowLayout());
        JPanel confPanel = new JPanel(new FlowLayout());
        String windowSizeString = JAMS.i18n((String)"Select_window_size") + " " + JAMS.i18n((String)"in") + " ";
        switch (m.getTimeDomain().getTimeUnit()) {
            case 1: {
                windowSizeString = windowSizeString + JAMS.i18n((String)"years");
                break;
            }
            case 2: {
                windowSizeString = windowSizeString + JAMS.i18n((String)"months");
                break;
            }
            case 6: {
                windowSizeString = windowSizeString + JAMS.i18n((String)"days");
                break;
            }
            case 11: {
                windowSizeString = windowSizeString + JAMS.i18n((String)"hours");
            }
        }
        confPanel.add(new JLabel(windowSizeString));
        this.windowSizeField.setText(Integer.toString(TimeFilterFactory.EventFilter.DEFAULT_WINDOWSIZE));
        confPanel.add(this.windowSizeField);
        confPanel.add(new JLabel(JAMS.i18n((String)"Select_type_of_event")));
        confPanel.add(this.hydroEventTypeBox);
        confPanel.add(new JLabel(JAMS.i18n((String)"Select_event_quality")));
        confPanel.add(this.qualitySlider);
        confPanel.add(this.updateBn);
        confPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Configuration")));
        northPanel.add((Component)confPanel, "Center");
        filterPanel.add((Component)northPanel, "North");
        PatchedChartPanel chartPanel = this.eventFilterHydrograph.getChartPanel();
        filterPanel.add((Component)((Object)chartPanel), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        filterPanel.add((Component)buttonPanel, "South");
        buttonPanel.add(new JButton(JAMS.i18n((String)"OK")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeFilterDialog.this.filter = TimeFilterDialog.this.constructHydroEventFilter();
                        TimeFilterDialog.this.isApproved = true;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        });
        buttonPanel.add(new JButton(JAMS.i18n((String)"Cancel")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeFilterDialog.this.filter = null;
                        TimeFilterDialog.this.isApproved = false;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        });
        this.updateBn.addActionListener(this.updateHydroEventListener);
        if (filter != null) {
            TimeFilterFactory.EventFilter eventFilter = filter;
            this.timeserie = eventFilter.getTimeSerie();
            this.windowSizeField.setText(Integer.toString(eventFilter.getWindowSize()));
            switch (eventFilter.getFilteredEventType()) {
                case Peak: {
                    this.hydroEventTypeBox.setSelectedItem(peakString);
                    break;
                }
                case RaisingEdge: {
                    this.hydroEventTypeBox.setSelectedItem(raisingEdgeString);
                    break;
                }
                case Recession: {
                    this.hydroEventTypeBox.setSelectedItem(fallingEdgeString);
                    break;
                }
            }
            this.qualitySlider.setMinimum((int)(filter.getMinQuality() * 100.0));
            this.qualitySlider.setMaximum((int)(filter.getMaxQuality() * 100.0));
        }
        this.eventFilterHydrograph.setHydrograph(m);
        return filterPanel;
    }

    private TimeFilter constructBaseFlowFilter() {
        double threshold = 1.0;
        try {
            threshold = Double.parseDouble(this.baseFlowRunoffQuantity.getText());
        }
        catch (NumberFormatException pe) {
            JOptionPane.showMessageDialog(this.rootPane, JAMS.i18n((String)"Please_enter_a_valid_threshold"));
        }
        if (this.baseFlowFixedEstimation.isSelected()) {
            return TimeFilterFactory.getBaseFlowTimeFilter(this.timeserie, TimeFilterFactory.BaseFlowTimeFilter.Method.Fixed, threshold);
        }
        return TimeFilterFactory.getBaseFlowTimeFilter(this.timeserie, TimeFilterFactory.BaseFlowTimeFilter.Method.HYSEPLocalMinimum, threshold);
    }

    private JPanel constructBaseFlowTimeFilterPanel(TimeSerie m, TimeFilterFactory.BaseFlowTimeFilter filter) {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Select_baseflow_filter")));
        this.hydrographBaseFlow = new HydrographChart();
        ButtonGroup methodButtonGroup = new ButtonGroup();
        methodButtonGroup.add(this.baseFlowFixedEstimation);
        methodButtonGroup.add(this.baseFlowLocalMiniumEstimation);
        JPanel northPanel = new JPanel(new FlowLayout());
        JPanel methodPanel = new JPanel(new FlowLayout());
        methodPanel.add(this.baseFlowFixedEstimation);
        methodPanel.add(this.baseFlowLocalMiniumEstimation);
        methodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), JAMS.i18n((String)"Method")));
        northPanel.add((Component)methodPanel, "West");
        northPanel.add((Component)new JLabel(JAMS.i18n((String)"Threshold")), "Center");
        northPanel.add((Component)this.baseFlowRunoffQuantity, "East");
        filterPanel.add((Component)northPanel, "North");
        PatchedChartPanel chartPanel = this.hydrographBaseFlow.getChartPanel();
        filterPanel.add((Component)((Object)chartPanel), "Center");
        filterPanel.add((Component)new JButton(JAMS.i18n((String)"OK")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeFilterDialog.this.filter = TimeFilterDialog.this.constructBaseFlowFilter();
                        TimeFilterDialog.this.isApproved = true;
                        TimeFilterDialog.this.setVisible(false);
                    }
                });
            }
        }, "South");
        for (ActionListener l : this.baseFlowFixedEstimation.getActionListeners()) {
            this.baseFlowFixedEstimation.removeActionListener(l);
        }
        for (ActionListener l : this.baseFlowLocalMiniumEstimation.getActionListeners()) {
            this.baseFlowLocalMiniumEstimation.removeActionListener(l);
        }
        this.baseFlowFixedEstimation.addActionListener(this.updateBaseFlowListener);
        this.baseFlowLocalMiniumEstimation.addActionListener(this.updateBaseFlowListener);
        this.baseFlowRunoffQuantity.addActionListener(this.updateBaseFlowListener);
        if (filter != null) {
            TimeFilterFactory.BaseFlowTimeFilter baseFlowFilter = filter;
            this.timeserie = baseFlowFilter.getTimeSerie();
            this.baseFlowRunoffQuantity.setText(Double.toString(baseFlowFilter.getThreshold()));
            if (baseFlowFilter.getMethod() == TimeFilterFactory.BaseFlowTimeFilter.Method.Fixed) {
                this.baseFlowFixedEstimation.setSelected(true);
            } else {
                this.baseFlowLocalMiniumEstimation.setSelected(true);
            }
        } else {
            double value = m.getMin() + 0.1 * (m.getMax() - m.getMin());
            this.baseFlowRunoffQuantity.setText(Double.toString(value));
        }
        this.hydrographBaseFlow.setHydrograph(m);
        return filterPanel;
    }

    public void init(TimeSerie serie, TimeFilter filter) {
        TimeFilter yearlyFilter;
        this.filter = filter;
        this.setMaximumSize(new Dimension(1024, 800));
        JTabbedPane pane = new JTabbedPane();
        if (filter instanceof TimeFilterFactory.YearlyTimeFilter || filter == null) {
            yearlyFilter = null;
            if (filter != null) {
                yearlyFilter = (TimeFilterFactory.YearlyTimeFilter)filter;
            }
            pane.addTab(JAMS.i18n((String)"Yearly_Filter"), this.constructYearTimeFilterPanel((TimeFilterFactory.YearlyTimeFilter)yearlyFilter));
        }
        if (filter instanceof TimeFilterFactory.MonthlyTimeFilter || filter == null) {
            yearlyFilter = null;
            if (filter != null) {
                yearlyFilter = (TimeFilterFactory.MonthlyTimeFilter)filter;
            }
            pane.addTab(JAMS.i18n((String)"Monthly_Filter"), this.constructMonthlyTimeFilterPanel((TimeFilterFactory.MonthlyTimeFilter)yearlyFilter));
        }
        if (filter instanceof TimeFilterFactory.BaseFlowTimeFilter || filter == null) {
            TimeFilterFactory.BaseFlowTimeFilter baseFlowFilter = null;
            if (filter != null) {
                baseFlowFilter = (TimeFilterFactory.BaseFlowTimeFilter)filter;
            }
            pane.addTab(JAMS.i18n((String)"Baseflow_Filter"), this.constructBaseFlowTimeFilterPanel(serie, baseFlowFilter));
        }
        if (filter instanceof TimeFilterFactory.EventFilter || filter == null) {
            TimeFilterFactory.EventFilter eventFilter = null;
            if (filter != null) {
                eventFilter = (TimeFilterFactory.EventFilter)filter;
            }
            pane.addTab(JAMS.i18n((String)"Hydrograph_Event_Filter"), this.constructHydroEventFilterPanel(serie, eventFilter));
        }
        if (filter instanceof TimeFilterFactory.RangeTimeFilter || filter == null) {
            TimeFilterFactory.RangeTimeFilter rangeFilter = null;
            if (filter != null) {
                rangeFilter = (TimeFilterFactory.RangeTimeFilter)filter;
            }
            pane.addTab(JAMS.i18n((String)"Interval_Filter"), this.constructRangeFilterPanel(serie, rangeFilter));
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(pane);
        this.getContentPane().removeAll();
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setModal(true);
    }

    public boolean getApproval() {
        return this.isApproved;
    }

    public TimeFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.isApproved = false;
        }
        super.setVisible(b);
    }
}

