/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import optas.gui.wizard.Attribute;

public class Parameter
extends Attribute {
    private double lowerBound;
    private double upperBound;
    private double[] startValue;

    public Parameter(String name) {
        super(name);
    }

    public Parameter(Attribute a) {
        super(a);
    }

    public Parameter(ContextAttribute ca) {
        super(ca);
    }

    public Parameter(ComponentField cf) {
        super(cf);
    }

    public Parameter(ContextAttribute ca, Range range) {
        super(ca);
        if (range != null) {
            this.lowerBound = range.lowerBound;
            this.upperBound = range.upperBound;
        }
    }

    public Parameter(ComponentField cf, Range range) {
        super(cf);
        if (range != null) {
            this.lowerBound = range.lowerBound;
            this.upperBound = range.upperBound;
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double[] getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double[] startValue) {
        this.startValue = startValue;
    }

    public void setStartValue(String startvalue) throws NumberFormatException {
        String startvalue2 = startvalue.replace("[", "");
        startvalue2 = startvalue2.replace("]", "");
        String[] values = startvalue2.split(",");
        int m = values.length;
        this.startValue = new double[m];
        for (int i = 0; i < m; ++i) {
            this.startValue[i] = Double.parseDouble(values[i]);
        }
    }

    @Override
    public int compareTo(Object o) {
        return this.toString().compareToIgnoreCase(o.toString());
    }

    @Override
    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public static class Range {
        public double lowerBound;
        public double upperBound;

        public Range(double a, double b) {
            this.lowerBound = a;
            this.upperBound = b;
        }

        public Range(String s) throws NumberFormatException {
            String s2 = s.replace("[", "");
            s2 = s2.replace("]", "");
            String[] bounds = null;
            bounds = s2.contains(">") ? s2.split(">") : s2.split("&gt;");
            if (bounds.length != 2) {
                throw new NumberFormatException();
            }
            this.lowerBound = Double.parseDouble(bounds[0]);
            this.upperBound = Double.parseDouble(bounds[1]);
        }

        public String toString() {
            return this.lowerBound + "\t" + this.upperBound;
        }
    }
}

