/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.meta.ModelDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import optas.gui.wizard.NumericFocusListener;
import optas.gui.wizard.NumericKeyListener;
import optas.gui.wizard.OPTASWizardException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.Optimization;
import optas.gui.wizard.Parameter;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.StringOptimizerParameter;

public class OptimizerConfiguration
extends JPanel {
    final int TOTAL_WIDTH = 800;
    final int TOTAL_HEIGHT = 550;
    OptimizerDescription[] availableOptimizer = null;
    Set<Parameter> availableParameters = null;
    Set<Objective> availableObjectives = null;
    Optimization optimizationScheme = null;
    NumericKeyListener stdNumericKeyListener = new NumericKeyListener();
    NumericFocusListener stdFocusListener = new NumericFocusListener();
    JDialog dialog = null;
    JPanel optimizerConfigurationPanel = new JPanel(new GridBagLayout());
    JPanel parameterConfigurationPanel = new JPanel(new GridBagLayout());
    JPanel objectiveConfigurationPanel = new JPanel(new GridBagLayout());
    OptimizerDescription activeOptimizer = null;
    Logger logger = null;
    JButton okButton = new JButton(JAMS.i18n((String)"OK"));
    boolean success = false;
    JTable parameterTable = new JTable(){
        {
            this.setAutoResizeMode(4);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            ParameterTableModel model = (ParameterTableModel)this.getModel();
            if (this.getSelectedRow() != row) {
                if (((Boolean)model.getValueAt(row, 0)).booleanValue()) {
                    if ((Double)model.getValueAt(row, 3) >= (Double)model.getValueAt(row, 4) || model.getValueAt(row, 5) != null && ((Double)model.getValueAt(row, 5) < (Double)model.getValueAt(row, 3) || (Double)model.getValueAt(row, 5) > (Double)model.getValueAt(row, 4))) {
                        c.setBackground(Color.RED);
                    } else {
                        c.setBackground(Color.GREEN);
                    }
                } else {
                    c.setBackground(Color.WHITE);
                }
            } else {
                c.setBackground(Color.BLUE);
            }
            return c;
        }
    };
    JTable objectiveTable = new JTable(){
        {
            this.setAutoResizeMode(0);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            ObjectiveTableModel model = (ObjectiveTableModel)this.getModel();
            if (this.getSelectedRow() != row) {
                if (((Boolean)model.getValueAt(row, 0)).booleanValue()) {
                    c.setBackground(Color.GREEN);
                } else {
                    c.setBackground(Color.WHITE);
                }
            } else {
                c.setBackground(Color.BLUE);
            }
            return c;
        }
    };
    Dimension prefSize = new Dimension(800, 550);
    HashSet<ActionListener> listeners = new HashSet();

    public OptimizerConfiguration(ModelDescriptor md, Logger logger) throws OPTASWizardException {
        this.optimizationScheme = new Optimization(new ModelDescriptor(md));
        this.logger = logger;
        this.initData();
        this.initGUI();
        this.updateOptimizerPanel();
        this.parameterTable.setModel(new ParameterTableModel(this.optimizationScheme.getParameter(), this.optimizationScheme.getModelParameters()));
        this.parameterTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(1).setPreferredWidth(115);
        this.parameterTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.parameterTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(5).setPreferredWidth(50);
        this.parameterTable.getTableHeader().setPreferredSize(new Dimension(this.parameterTable.getTableHeader().getPreferredSize().width, 40));
        this.parameterTable.setAutoResizeMode(0);
        this.objectiveTable.setModel(new ObjectiveTableModel(this.optimizationScheme.getObjective(), this.optimizationScheme.getModelObjectives()));
        this.objectiveTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.objectiveTable.getColumnModel().getColumn(1).setPreferredWidth(115);
        this.objectiveTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.objectiveTable.getTableHeader().setPreferredSize(new Dimension(this.objectiveTable.getTableHeader().getPreferredSize().width, 40));
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public ModelDescriptor getModelDescriptor() {
        if (this.optimizationScheme != null) {
            return this.optimizationScheme.getModelDescriptor();
        }
        return null;
    }

    public boolean getSuccessState() {
        return this.success;
    }

    private void initGUI() {
        this.removeAll();
        JScrollPane scrollPaneOptimizerSpecificationPanel = new JScrollPane(this.optimizerConfigurationPanel);
        JComboBox<OptimizerDescription> selectOptimizer = new JComboBox<OptimizerDescription>(this.availableOptimizer);
        selectOptimizer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OptimizerConfiguration.this.activeOptimizer = (OptimizerDescription)e.getItem();
                    OptimizerConfiguration.this.optimizationScheme.setOptimizerDescription(OptimizerConfiguration.this.activeOptimizer);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptimizerConfiguration.this.updateOptimizerPanel();
                        }
                    });
                }
            }
        });
        scrollPaneOptimizerSpecificationPanel.setPreferredSize(new Dimension(800, 200));
        this.parameterConfigurationPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPaneParameterConfiguration = new JScrollPane(this.parameterTable);
        scrollPaneParameterConfiguration.setPreferredSize(new Dimension(350, 250));
        scrollPaneParameterConfiguration.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Parameter_Configuration")));
        this.objectiveConfigurationPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPaneObjectiveConfiguration = new JScrollPane(this.objectiveTable);
        scrollPaneObjectiveConfiguration.setPreferredSize(new Dimension(200, 250));
        scrollPaneObjectiveConfiguration.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Objective_Configuration")));
        GroupLayout mainLayout = new GroupLayout(this);
        this.setLayout(mainLayout);
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup().addComponent(selectOptimizer).addComponent(scrollPaneOptimizerSpecificationPanel).addGroup(mainLayout.createSequentialGroup().addComponent(scrollPaneParameterConfiguration).addComponent(scrollPaneObjectiveConfiguration)));
        mainLayout.setVerticalGroup(mainLayout.createSequentialGroup().addComponent(selectOptimizer).addComponent(scrollPaneOptimizerSpecificationPanel).addGap(20).addGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(scrollPaneParameterConfiguration).addComponent(scrollPaneObjectiveConfiguration)));
        this.revalidate();
    }

    public Optimization getOptimizer() {
        return this.optimizationScheme;
    }

    private void updateOptimizerPanel() {
        this.optimizerConfigurationPanel.removeAll();
        this.optimizerConfigurationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        int counter = 0;
        c.gridx = 0;
        c.gridy = counter++;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.insets = new Insets(5, 0, 5, 0);
        this.optimizerConfigurationPanel.add((Component)new JLabel(this.optimizationScheme.getOptimizerDescription().getShortName()){
            {
                Font f = this.getFont();
                this.setFont(f.deriveFont(20.0f));
            }
        }, c);
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 2, 0);
        for (OptimizerParameter p : this.optimizationScheme.getOptimizerDescription().getPropertyMap().values()) {
            c.gridx = 0;
            c.gridy = counter;
            c.anchor = 18;
            JLabel lbl = new JLabel("<HTML><BODY>" + p.getDescription() + "</BODY></HTML>");
            lbl.setVerticalTextPosition(1);
            lbl.setPreferredSize(new Dimension(440, 40));
            this.optimizerConfigurationPanel.add((Component)lbl, c);
            c.gridx = 1;
            c.anchor = 11;
            if (p instanceof NumericOptimizerParameter) {
                this.optimizerConfigurationPanel.add((Component)this.getNumericField((NumericOptimizerParameter)p), c);
            }
            if (p instanceof BooleanOptimizerParameter) {
                this.optimizerConfigurationPanel.add((Component)this.getBooleanField((BooleanOptimizerParameter)p), c);
            }
            if (p instanceof StringOptimizerParameter) {
                this.optimizerConfigurationPanel.add((Component)this.getStringField((StringOptimizerParameter)p), c);
            }
            c.gridx = 1;
            c.anchor = 11;
            ++counter;
        }
        if (600 > counter * 40) {
            c.insets = new Insets(0, 0, 560 - counter * 40, 0);
        }
        c.gridx = 0;
        c.gridy = counter;
        c.anchor = 18;
        BooleanOptimizerParameter doSpatial = this.optimizationScheme.getOptimizerDescription().getDoSpatialRelaxation();
        JLabel lbl = new JLabel("<HTML><BODY>" + doSpatial.getDescription() + "</BODY></HTML>");
        lbl.setVerticalTextPosition(1);
        lbl.setPreferredSize(new Dimension(440, 40));
        this.optimizerConfigurationPanel.add((Component)lbl, c);
        c.gridx = 1;
        c.gridy = counter;
        c.anchor = 11;
        this.optimizerConfigurationPanel.add((Component)this.getBooleanField(doSpatial), c);
        this.revalidate();
        this.updateGUI();
    }

    public JDialog showDialog(JFrame parent) {
        this.dialog = new JDialog(parent);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonBar = new JPanel(new FlowLayout());
        panel.add((Component)this, "Center");
        panel.add((Component)buttonBar, "South");
        buttonBar.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizerConfiguration.this.optimizationScheme.setOptimizerDescription(OptimizerConfiguration.this.activeOptimizer);
                OptimizerConfiguration.this.optimizationScheme.finish();
                OptimizerConfiguration.this.dialog.setVisible(false);
                OptimizerConfiguration.this.success = true;
                for (ActionListener listener : OptimizerConfiguration.this.listeners) {
                    listener.actionPerformed(new ActionEvent(OptimizerConfiguration.this, 1, "doc_modified"));
                }
            }
        });
        buttonBar.add(new JButton("Cancel"){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OptimizerConfiguration.this.dialog.setVisible(false);
                        OptimizerConfiguration.this.success = false;
                    }
                });
            }
        });
        this.dialog.getContentPane().add(panel);
        this.dialog.revalidate();
        this.dialog.setSize(this.prefSize);
        this.dialog.setLocationByPlatform(true);
        this.dialog.setVisible(true);
        return this.dialog;
    }

    private void initData() {
        Set<Optimizer> set = OptimizerLibrary.getAvailableOptimizer();
        this.availableOptimizer = new OptimizerDescription[set.size()];
        int c = 0;
        for (Optimizer o : set) {
            if (this.optimizationScheme.getOptimizerDescription().getOptimizerClassName().equals(o.getDescription().getOptimizerClassName())) {
                this.availableOptimizer[c++] = this.optimizationScheme.getOptimizerDescription();
                this.activeOptimizer = this.optimizationScheme.getOptimizerDescription();
                continue;
            }
            this.availableOptimizer[c++] = o.getDescription();
        }
        this.availableParameters = this.optimizationScheme.getModelParameters();
        this.availableObjectives = this.optimizationScheme.getModelObjectives();
        this.updateGUI();
    }

    private JComponent getNumericField(NumericOptimizerParameter p) {
        JTextField field = new JTextField(Double.toString(p.getValue()), 5);
        field.putClientProperty("property", p);
        field.putClientProperty("mode", new Integer(3));
        field.addKeyListener(this.stdNumericKeyListener);
        field.addFocusListener(this.stdFocusListener);
        return field;
    }

    private JComponent getBooleanField(BooleanOptimizerParameter p) {
        JCheckBox checkBox = new JCheckBox("", p.isValue());
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
                BooleanOptimizerParameter p = (BooleanOptimizerParameter)src.getClientProperty("property");
                if (src.isSelected()) {
                    p.setValue(true);
                } else {
                    p.setValue(false);
                }
            }
        });
        checkBox.putClientProperty("property", p);
        checkBox.putClientProperty("mode", new Integer(3));
        return checkBox;
    }

    private JComponent getStringField(StringOptimizerParameter p) {
        JTextField field = new JTextField(p.getValue(), 15);
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField src = (JTextField)e.getSource();
                StringOptimizerParameter p = (StringOptimizerParameter)src.getClientProperty("property");
                p.setValue(src.getText());
            }
        });
        field.putClientProperty("property", p);
        field.putClientProperty("mode", new Integer(3));
        return field;
    }

    private void updateGUI() {
        this.okButton.setEnabled(this.isValidConfiguration());
    }

    private boolean isValidConfiguration() {
        if (this.optimizationScheme.getParameter().isEmpty()) {
            return false;
        }
        if (this.optimizationScheme.getObjective().isEmpty()) {
            return false;
        }
        if (this.activeOptimizer == null) {
            return false;
        }
        for (Parameter p : this.optimizationScheme.getParameter()) {
            if (p.getLowerBound() >= p.getUpperBound()) {
                return false;
            }
            if (p.getStartValue() == null || p.getStartValue().length <= 0 || !(p.getStartValue()[0] < p.getLowerBound()) && !(p.getStartValue()[0] > p.getUpperBound())) continue;
            return false;
        }
        return true;
    }

    class ObjectiveTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{JAMS.i18n((String)"selected"), JAMS.i18n((String)"Name"), JAMS.i18n((String)"component")};
        private Objective[] dataObjects = null;

        ObjectiveTableModel(Set<Objective> selectedObjectives, Set<Objective> modelObjectives) {
            this.dataObjects = new Objective[modelObjectives.size()];
            int i = 0;
            Iterator<Objective> iterator = modelObjectives.iterator();
            while (iterator.hasNext()) {
                Objective p;
                this.dataObjects[i] = p = iterator.next();
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataObjects != null) {
                return this.dataObjects.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return OptimizerConfiguration.this.optimizationScheme.getObjective().contains(this.dataObjects[row]);
                }
                case 1: {
                    return this.dataObjects[row].getAttributeName();
                }
                case 2: {
                    return this.dataObjects[row].getParentName();
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            SetValueRunnable r = new SetValueRunnable();
            r.col = col;
            r.row = row;
            r.value = value;
            SwingUtilities.invokeLater(r);
        }

        class SetValueRunnable
        implements Runnable {
            int col;
            int row;
            Object value;

            SetValueRunnable() {
            }

            @Override
            public void run() {
                if (this.col == 0 && !((Boolean)this.value).booleanValue()) {
                    OptimizerConfiguration.this.optimizationScheme.removeObjective(ObjectiveTableModel.this.dataObjects[this.row]);
                } else if (this.col == 0 && ((Boolean)this.value).booleanValue()) {
                    OptimizerConfiguration.this.optimizationScheme.addObjective(ObjectiveTableModel.this.dataObjects[this.row]);
                }
                for (int i = 0; i < 3; ++i) {
                    ObjectiveTableModel.this.fireTableCellUpdated(this.row, i);
                }
                OptimizerConfiguration.this.updateGUI();
            }
        }
    }

    class ParameterTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{JAMS.i18n((String)"selected"), JAMS.i18n((String)"Name"), JAMS.i18n((String)"component"), "<HTML>" + JAMS.i18n((String)"lower_bound").replace(" ", "<br>") + "</HTML>", "<HTML>" + JAMS.i18n((String)"upper_bound").replace(" ", "<br>") + "</HTML>", "<HTML>" + JAMS.i18n((String)"start_value").replace(" ", "<br>") + "</HTML>"};
        private Parameter[] dataObjects = null;

        ParameterTableModel(Set<Parameter> selectedParameters, Set<Parameter> modelParameters) {
            this.dataObjects = new Parameter[modelParameters.size()];
            int i = 0;
            Iterator<Parameter> iterator = modelParameters.iterator();
            while (iterator.hasNext()) {
                Parameter p;
                this.dataObjects[i] = p = iterator.next();
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataObjects != null) {
                return this.dataObjects.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return OptimizerConfiguration.this.optimizationScheme.getParameter().contains(this.dataObjects[row]);
                }
                case 1: {
                    return this.dataObjects[row].getAttributeName();
                }
                case 2: {
                    return this.dataObjects[row].getParentName();
                }
                case 3: {
                    return this.dataObjects[row].getLowerBound();
                }
                case 4: {
                    return this.dataObjects[row].getUpperBound();
                }
                case 5: {
                    if (this.dataObjects[row].getStartValue() != null && this.dataObjects[row].getStartValue().length > 0) {
                        return this.dataObjects[row].getStartValue()[0];
                    }
                    return null;
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 3: {
                    return Double.class;
                }
                case 4: {
                    return Double.class;
                }
                case 5: {
                    return Double.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0 && !((Boolean)value).booleanValue()) {
                OptimizerConfiguration.this.optimizationScheme.removeParameter(this.dataObjects[row]);
            } else if (col == 0 && ((Boolean)value).booleanValue()) {
                OptimizerConfiguration.this.optimizationScheme.addParameter(this.dataObjects[row]);
            } else if (col == 3) {
                this.dataObjects[row].setLowerBound((Double)value);
                OptimizerConfiguration.this.optimizationScheme.update();
            } else if (col == 4) {
                this.dataObjects[row].setUpperBound((Double)value);
                OptimizerConfiguration.this.optimizationScheme.update();
            } else if (col == 5) {
                this.dataObjects[row].setStartValue(new double[]{(Double)value});
                OptimizerConfiguration.this.optimizationScheme.update();
            }
            for (int i = 0; i < 6; ++i) {
                this.fireTableCellUpdated(row, i);
            }
            OptimizerConfiguration.this.updateGUI();
        }
    }
}

