/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.data.Attribute;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import optas.gui.wizard.Attribute;
import optas.gui.wizard.ModelAnalyzer;
import optas.gui.wizard.ModelModifier;
import optas.gui.wizard.OPTASWizardException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.Parameter;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.SCE;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.SimpleOptimizationController;

public class Optimization
implements Serializable {
    private transient ModelModifier modifier;
    private transient ModelAnalyzer analyser;
    private OptimizerDescription optimizerDescription;
    private Set<Parameter> parameter = new TreeSet<Parameter>();
    private Set<Objective> objective = new TreeSet<Objective>();
    private String name;

    public Optimization(ModelDescriptor md) throws OPTASWizardException {
        if (md != null) {
            this.modifier = new ModelModifier(md);
            this.analyser = new ModelAnalyzer(md);
            if (!this.importFromModelDescriptor(md)) {
                this.optimizerDescription = this.modifier.addOptimizationContext();
            }
        } else {
            this.optimizerDescription = new OptimizerDescription();
        }
    }

    public void update() {
        this.modifier.updateObjectiveList(this.objective);
        this.modifier.updateParameterList(this.parameter);
    }

    public void finish() {
        ArrayList<Attribute> exportAttributes = new ArrayList<Attribute>();
        exportAttributes.addAll(this.parameter);
        exportAttributes.addAll(this.objective);
        this.modifier.finish(exportAttributes);
    }

    public ModelDescriptor getModelDescriptor() {
        return this.modifier.getModelDescriptor();
    }

    public boolean addParameter(Parameter p) {
        this.getParameter().add(p);
        if (this.modifier == null) {
            return true;
        }
        if (this.modifier.updateParameterList(this.getParameter())) {
            this.getParameter().add(p);
            return true;
        }
        return false;
    }

    public boolean removeParameter(Parameter p) {
        this.getParameter().remove(p);
        if (this.modifier == null) {
            return true;
        }
        return this.modifier.updateParameterList(this.getParameter());
    }

    public boolean removeObjective(Objective c) {
        this.getObjective().remove(c);
        if (this.modifier == null) {
            return true;
        }
        return this.modifier.updateObjectiveList(this.getObjective());
    }

    public boolean addObjective(Objective c) {
        this.getObjective().add(c);
        if (this.modifier == null) {
            return true;
        }
        if (this.modifier.updateObjectiveList(this.getObjective())) {
            this.getObjective().add(c);
            return true;
        }
        return false;
    }

    public Set<Parameter> getModelParameters() {
        SortedSet<Parameter> allParameters = this.analyser.getParameters();
        allParameters.addAll(this.parameter);
        return allParameters;
    }

    public Set<Objective> getModelObjectives() {
        SortedSet<Objective> allObjectives = this.analyser.getObjectives();
        allObjectives.addAll(this.objective);
        return allObjectives;
    }

    public OptimizerDescription getOptimizerDescription() {
        return this.optimizerDescription;
    }

    public void setOptimizerDescription(OptimizerDescription optimizerDescription) {
        if (this.modifier != null) {
            this.modifier.setOptimizerDescription(optimizerDescription);
        }
        this.optimizerDescription = optimizerDescription;
    }

    public Set<Parameter> getParameter() {
        return this.parameter;
    }

    public void setParameter(Set<Parameter> parameter) {
        this.parameter = parameter;
    }

    public Set<Objective> getObjective() {
        return this.objective;
    }

    public void setObjective(Set<Objective> objective) {
        this.objective = new TreeSet<Objective>();
        this.objective.addAll(objective);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean importFromModelDescriptor(ModelDescriptor md) throws OPTASWizardException {
        ComponentField objectiveField;
        Optimizer optimizer;
        ContextDescriptor optimizerContext = null;
        try {
            optimizerContext = (ContextDescriptor)md.getComponentDescriptor("optimizer");
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (optimizerContext == null) {
            return false;
        }
        if (!optimizerContext.getClazz().isAssignableFrom(SimpleOptimizationController.class)) {
            Logger.getGlobal().log(Level.WARNING, JAMS.i18n((String)"The_model_allready_contains_an_optimization_controller_which_is_not_compatible_with_SimpleOptimizationController!"));
            return false;
        }
        ComponentField classNameField = (ComponentField)optimizerContext.getComponentFields().get("optimizationClassName");
        if (classNameField == null) {
            Logger.getGlobal().log(Level.WARNING, JAMS.i18n((String)"There_is_allready_an_optimization_component_inside_the_model._But_the_optimizer_class_field_is_not_existing."));
            return false;
        }
        String className = classNameField.getValue();
        if (className == null) {
            Logger.getGlobal().log(Level.WARNING, JAMS.i18n((String)"There_is_allready_an_optimization_component_in_the_model._But_the_optimizer_class_was_not_set._Using_SCE_instead!"));
            className = SCE.class.getCanonicalName();
        }
        if ((optimizer = OptimizerLibrary.getOptimizer(className)) == null) {
            String errorMsg = JAMS.i18n((String)"Unable_to_load_optimization_component") + className + JAMS.i18n((String)".Please_check_your_optimizer_configuration!");
            Logger.getGlobal().log(Level.WARNING, errorMsg);
            throw new OPTASWizardException(errorMsg);
        }
        OptimizerDescription desc = optimizer.getDescription();
        ComponentField setupField = (ComponentField)optimizerContext.getComponentFields().get("parameterization");
        if (setupField != null && setupField.getValue() != null) {
            String[] setupList;
            for (String parameterValuePair : setupList = setupField.getValue().split(";")) {
                OptimizerParameter op;
                String[] entry = parameterValuePair.split("=");
                String name = entry[0];
                String value = entry[1];
                if (entry.length != 2 || (op = desc.getPropertyMap().get(name)) == null) continue;
                op.setString(value);
            }
        }
        this.setOptimizerDescription(desc);
        ComponentField parameterIDfield = (ComponentField)optimizerContext.getComponentFields().get("parameterIDs");
        ComponentField rangesField = (ComponentField)optimizerContext.getComponentFields().get("boundaries");
        ComponentField startValuesField = (ComponentField)optimizerContext.getComponentFields().get("startValue");
        if (parameterIDfield == null || rangesField == null) {
            Logger.getGlobal().log(Level.WARNING, JAMS.i18n((String)"The_optimization_controller_does_not_contain_either_parameter_ranges_or_parameter_ids!"));
            return false;
        }
        if (rangesField != null && rangesField.getValue() != null) {
            int n;
            String[] parameterIDs = parameterIDfield.getAttribute().split(";");
            String[] ranges = rangesField.getValue().split(";");
            if (ranges.length != (n = parameterIDs.length)) {
                Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"Error:_Number_of_parameters_is_not_equal_to_number_of_boundaries._Setting_default_range_of_0_1_for_missing_parameters!"));
                if (ranges.length < n) {
                    int k = ranges.length;
                    ranges = Arrays.copyOf(ranges, n);
                    for (int i = k; i < n; ++i) {
                        ranges[i] = "[0<1];";
                    }
                } else {
                    ranges = Arrays.copyOf(ranges, n);
                }
            }
            String[] startvalues = new String[n];
            if (startValuesField != null) {
                int counter = 0;
                if (startValuesField.getValue() == null) {
                    startValuesField.setValue("");
                }
                StringTokenizer tokStartValue = new StringTokenizer(startValuesField.getValue(), ";");
                ArrayList<double[]> x0List = new ArrayList<double[]>();
                while (tokStartValue.hasMoreTokens()) {
                    String param = tokStartValue.nextToken();
                    param = param.replace("[", "");
                    param = param.replace("]", "");
                    StringTokenizer subTokenizer = new StringTokenizer(param, ",");
                    double[] x0i = new double[subTokenizer.countTokens()];
                    int subCounter = 0;
                    if (x0i.length != n) {
                        Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"Component") + " " + JAMS.i18n((String)"startvalue_too_many_parameter"));
                    }
                    while (subTokenizer.hasMoreTokens()) {
                        try {
                            x0i[subCounter] = Double.valueOf(subTokenizer.nextToken());
                            ++subCounter;
                        }
                        catch (NumberFormatException e) {
                            Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"unparseable_number") + param);
                        }
                    }
                    x0List.add(x0i);
                    ++counter;
                }
                for (int i = 0; i < n; ++i) {
                    if (x0List.size() <= 0 || ((double[])x0List.get(0)).length != n) continue;
                    startvalues[i] = Double.toString(((double[])x0List.get(0))[i]);
                }
            }
            for (int i = 0; i < n; ++i) {
                String parameterID = parameterIDs[i];
                String rangeString = ranges[i];
                String startvalueString = startvalues[i];
                ContextAttribute ca = (ContextAttribute)optimizerContext.getStaticAttributes().get(parameterID);
                if (ca == null) {
                    ca = (ContextAttribute)optimizerContext.getDynamicAttributes().get(parameterID);
                    optimizerContext.addStaticAttribute(parameterID, Attribute.Double.class, "0.0");
                    if (ca == null) {
                        Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"parameter") + " " + parameterID + JAMS.i18n((String)"_was_not_found_in_optimizerContext._Adding_parameter_and_setting_value_to_zero!"));
                        ca = (ContextAttribute)optimizerContext.getStaticAttributes().get(parameterID);
                    } else {
                        Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"parameter") + " " + parameterID + JAMS.i18n((String)"_is_not_static_in_optimizer_context._Adding_static_reference_and_setting_value_to_zero!"));
                    }
                }
                Parameter.Range range = null;
                try {
                    range = new Parameter.Range(rangeString);
                }
                catch (NumberFormatException nfe) {
                    range = new Parameter.Range(0.0, 1.0);
                }
                Parameter parameter = new Parameter(ca, range);
                for (Parameter p : this.getModelParameters()) {
                    if (p.compareTo(parameter) != 0) continue;
                    parameter = p;
                    parameter.setLowerBound(range.lowerBound);
                    parameter.setUpperBound(range.upperBound);
                    break;
                }
                try {
                    if (startvalueString != null) {
                        parameter.setStartValue(startvalueString);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.addParameter(parameter);
            }
        }
        if ((objectiveField = (ComponentField)optimizerContext.getComponentFields().get("effValue")) == null) {
            Logger.getGlobal().log(Level.SEVERE, JAMS.i18n((String)"Optimization_controller_does_not_contain_an_effValue_field!"));
            return false;
        }
        if (objectiveField.getAttribute() != null && objectiveField.getAttribute().length() > 1) {
            for (String objectiveID : objectiveField.getAttribute().split(";")) {
                ContextAttribute ca = (ContextAttribute)objectiveField.getContext().getDynamicAttributes().get(objectiveID);
                if (ca != null && ca.getContext().getInstanceName().compareTo("optimizer") != 0) {
                    optimizerContext.addDynamicAttribute(objectiveID, Attribute.Double.class);
                    HashSet cpySet = (HashSet)ca.getFields().clone();
                    for (ComponentField cf : cpySet) {
                        cf.linkToAttribute(optimizerContext, objectiveID, true);
                    }
                    ca = (ContextAttribute)optimizerContext.getDynamicAttributes().get(objectiveID);
                } else if (ca == null) {
                    optimizerContext.addDynamicAttribute(objectiveID, Attribute.Double.class);
                    ca = (ContextAttribute)optimizerContext.getDynamicAttributes().get(objectiveID);
                }
                Objective obj = new Objective(ca);
                for (Objective o : this.getModelObjectives()) {
                    if (o.compareTo(obj) != 0) continue;
                    obj = o;
                    break;
                }
                this.addObjective(obj);
            }
        }
        return true;
    }
}

