/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.tools.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import optas.data.TimeFilter;
import optas.data.TimeFilterCollection;
import optas.data.TimeFilterFactory;
import optas.efficiencies.UniversalEfficiencyCalculator;
import optas.gui.wizard.Attribute;
import optas.gui.wizard.OPTASWizardException;

public class ObjectiveDescription {
    private String name;
    private String efficiency;
    private Attribute measurement;
    private Attribute simulation;
    private Attribute time;
    private TimeFilterCollection timeFilters = new TimeFilterCollection();
    private Attribute.TimeInterval modelTimeInterval = null;

    public ObjectiveDescription(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTimeAttribute(Attribute time) {
        this.time = time;
    }

    public Attribute getTimeAttribute() {
        return this.time;
    }

    public void setModelTimeInterval(Attribute.TimeInterval modelTimeInterval) {
        this.modelTimeInterval = modelTimeInterval;
    }

    public Attribute.TimeInterval getModelTimeInterval() {
        return this.modelTimeInterval;
    }

    public Attribute getMeasurementAttribute() {
        return this.measurement;
    }

    public Attribute getSimulationAttribute() {
        return this.simulation;
    }

    public void setMeasurementAttribute(Attribute measurement) {
        this.measurement = measurement;
    }

    public void setSimulationAttribute(Attribute simulation) {
        this.simulation = simulation;
    }

    public void setEfficiency(String efficiency) {
        this.efficiency = efficiency;
    }

    public TimeFilterCollection getTimeFilters() {
        return this.timeFilters;
    }

    public void setTimeFilters(ArrayList<TimeFilter> filters) {
        this.timeFilters.set(filters);
    }

    public void setTimeFilters(TimeFilterCollection timeFilters) {
        this.timeFilters = timeFilters;
    }

    public String getEfficiency() {
        return this.efficiency;
    }

    public static ObjectiveDescription importFromComponentDescriptor(ComponentDescriptor cd) throws OPTASWizardException {
        ObjectiveDescription od = new ObjectiveDescription(cd.getInstanceName());
        HashMap map = cd.getComponentFields();
        if (!UniversalEfficiencyCalculator.class.isAssignableFrom(cd.getClazz())) {
            throw new OPTASWizardException("TODO");
        }
        if (((ComponentField)map.get("measurement")).getContextAttributes() == null || ((ComponentField)map.get("measurement")).getContextAttributes().size() == 0) {
            throw new OPTASWizardException("TODO");
        }
        if (((ComponentField)map.get("simulation")).getContextAttributes() == null || ((ComponentField)map.get("simulation")).getContextAttributes().size() == 0) {
            throw new OPTASWizardException("TODO");
        }
        Attribute measurementAttribute = new Attribute((ContextAttribute)((ComponentField)map.get("measurement")).getContextAttributes().get(0));
        Attribute simulationAttribute = new Attribute((ContextAttribute)((ComponentField)map.get("simulation")).getContextAttributes().get(0));
        Attribute timeAttribute = new Attribute((ContextAttribute)((ComponentField)map.get("time")).getContextAttributes().get(0));
        od.setMeasurementAttribute(measurementAttribute);
        od.setSimulationAttribute(simulationAttribute);
        od.setTimeAttribute(timeAttribute);
        if (map.get("timeInterval") == null) {
            throw new OPTASWizardException("TODO");
        }
        String timeIntervalString = ((ComponentField)map.get("timeInterval")).getValue();
        if (timeIntervalString != null) {
            String[] timeIntervalStrings;
            for (String s : timeIntervalStrings = timeIntervalString.split(";")) {
                Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
                if (!StringTools.isEmptyString((String)s)) {
                    interval.setValue(s);
                }
                TimeFilter tf = TimeFilterFactory.getRangeFilter(interval);
                od.timeFilters.add(tf);
            }
        }
        return od;
    }

    public String toString() {
        return this.getName();
    }
}

