/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.data.Attribute;
import jams.gui.input.TimeintervalInput;
import jams.gui.input.ValueChangeListener;
import jams.meta.ComponentDescriptor;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import optas.data.TimeFilter;
import optas.data.TimeSerie;
import optas.efficiencies.UniversalEfficiencyCalculator;
import optas.gui.wizard.Attribute;
import optas.gui.wizard.HydrographChart;
import optas.gui.wizard.ModelAnalyzer;
import optas.gui.wizard.ModelModifier;
import optas.gui.wizard.OPTASWizardException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.ObjectiveDescription;
import optas.gui.wizard.TimeFilterTableInput;
import optas.io.TSDataReader;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.XYItemEntity;

public class ObjectiveConfiguration
extends JPanel {
    final Dimension preferredDimension = new Dimension(1220, 700);
    JComboBox contextList = new JComboBox();
    JComboBox measurementList = new JComboBox();
    JComboBox simulationList = new JComboBox();
    JComboBox objectivesList = new JComboBox();
    JComboBox timeList = new JComboBox();
    TimeFilterTableInput filterList = new TimeFilterTableInput(null);
    HydrographChart hydroChart = new HydrographChart();
    PatchedChartPanel chartPanel = null;
    JPanel timeIntervalPanel = new JPanel();
    JButton loadTimeSerie = new JButton(JAMS.i18n((String)"Load_Timeserie"));
    JButton okButton = new JButton(JAMS.i18n((String)"OK"));
    JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
    JComboBox recentTimeSeries = new JComboBox();
    TimeintervalInput modelTimeIntervalInput = new TimeintervalInput(true);
    JAMSProperties systemProperties = JAMSProperties.createProperties();
    File defaultPropertyFile = null;
    DefaultComboBoxModel<ObjectiveDescription> objectives = new DefaultComboBoxModel();
    HashSet<ActionListener> listeners = new HashSet();
    ModelDescriptor md = null;
    File savePath = null;
    JDialog dialog = null;
    JButton addObjective = new JButton("+");
    JButton rmObjective = new JButton("-");
    JButton editObjective = new JButton("..");
    JFileChooser timeseriesFileChooser = new JFileChooser();
    private ActionListener measurementListUpdateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ObjectiveConfiguration.this.measurementList.getSelectedItem() instanceof Attribute) {
                Attribute a = (Attribute)ObjectiveConfiguration.this.measurementList.getSelectedItem();
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                od.setMeasurementAttribute(a);
            }
        }
    };
    private ActionListener simulationListUpdateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ObjectiveConfiguration.this.simulationList.getSelectedItem() instanceof Attribute) {
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                od.setSimulationAttribute((Attribute)ObjectiveConfiguration.this.simulationList.getSelectedItem());
            }
        }
    };

    private void updateTimeList() {
        String context = (String)this.contextList.getSelectedItem();
        ContextDescriptor cd = (ContextDescriptor)this.md.getComponentDescriptor(context);
        TreeSet<Attribute> potentialTimeAttributes = new TreeSet<Attribute>();
        while (cd != null) {
            DefaultMutableTreeNode mtn;
            Object o;
            HashMap set = cd.getAttributes(Attribute.Calendar.class);
            for (ContextAttribute ca : set.values()) {
                potentialTimeAttributes.add(new Attribute(ca));
            }
            TreeNode node = cd.getNode().getParent();
            if (node == null) {
                cd = null;
                continue;
            }
            if (!(node instanceof DefaultMutableTreeNode) || !((o = (mtn = (DefaultMutableTreeNode)node).getUserObject()) instanceof ContextDescriptor)) continue;
            cd = (ContextDescriptor)o;
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(potentialTimeAttributes.toArray());
        this.timeList.setModel(model);
        this.timeList.setSelectedIndex(-1);
    }

    public ObjectiveConfiguration(ModelDescriptor md, File savePath, Logger logger) {
        this.md = md;
        this.savePath = savePath;
        this.updateRecentTimeseriesList(null);
        this.initGUI();
        this.addObjective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(JAMS.i18n((String)"Specify name for new objective"), (Object)"unnamed");
                if (name != null) {
                    ObjectiveDescription od = new ObjectiveDescription(name);
                    ((DefaultComboBoxModel)ObjectiveConfiguration.this.objectivesList.getModel()).addElement(od);
                    ObjectiveConfiguration.this.objectivesList.getModel().setSelectedItem(od);
                    ObjectiveConfiguration.this.measurementList.setSelectedIndex(-1);
                    ObjectiveConfiguration.this.simulationList.setSelectedIndex(-1);
                    ObjectiveConfiguration.this.timeList.setSelectedIndex(-1);
                    ObjectiveConfiguration.this.filterList.clear();
                    ObjectiveConfiguration.this.updateButtonStates();
                }
            }
        });
        this.rmObjective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveConfiguration.this.objectivesList.removeItem(ObjectiveConfiguration.this.objectivesList.getSelectedItem());
                ObjectiveConfiguration.this.updateButtonStates();
            }
        });
        this.editObjective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                String name = JOptionPane.showInputDialog(JAMS.i18n((String)"Specify new name for objective"), (Object)od.getName());
                if (name != null) {
                    od.setName(name);
                }
                ObjectiveConfiguration.this.objectivesList.invalidate();
                ObjectiveConfiguration.this.objectivesList.repaint();
                ObjectiveConfiguration.this.updateButtonStates();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveConfiguration.this.applyChanges();
                ObjectiveConfiguration.this.dialog.setVisible(false);
                ActionEvent evt = new ActionEvent(ObjectiveConfiguration.this, 0, "objective updated");
                for (ActionListener l : ObjectiveConfiguration.this.listeners) {
                    l.actionPerformed(evt);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveConfiguration.this.dialog.setVisible(false);
            }
        });
        this.recentTimeSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File((String)ObjectiveConfiguration.this.recentTimeSeries.getSelectedItem());
                if (f.exists()) {
                    ObjectiveConfiguration.this.loadTimeseries(f);
                    ObjectiveConfiguration.this.updateButtonStates();
                }
            }
        });
        this.objectivesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ObjectiveConfiguration.this.objectivesList.getSelectedItem() instanceof ObjectiveDescription) {
                    ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                    if (od.getMeasurementAttribute() != null) {
                        ObjectiveConfiguration.this.contextList.setSelectedItem(od.getMeasurementAttribute().getParentName());
                        ObjectiveConfiguration.this.measurementList.setSelectedItem(od.getMeasurementAttribute());
                        ObjectiveConfiguration.this.simulationList.setSelectedItem(od.getSimulationAttribute());
                        ObjectiveConfiguration.this.timeList.setSelectedItem(od.getTimeAttribute());
                    } else {
                        ObjectiveConfiguration.this.contextList.setSelectedIndex(-1);
                        ObjectiveConfiguration.this.measurementList.setSelectedIndex(-1);
                        ObjectiveConfiguration.this.simulationList.setSelectedIndex(-1);
                        ObjectiveConfiguration.this.timeList.setSelectedIndex(-1);
                    }
                    ObjectiveConfiguration.this.filterList.setTimeFilters(od.getTimeFilters());
                    ObjectiveConfiguration.this.filterList.updateUI();
                    ObjectiveConfiguration.this.updateButtonStates();
                }
            }
        });
        this.contextList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String context = (String)ObjectiveConfiguration.this.contextList.getSelectedItem();
                if (context != null) {
                    ModelAnalyzer analyzer = new ModelAnalyzer(ObjectiveConfiguration.this.md);
                    SortedSet<Objective> allAttributes = analyzer.getAttributesWithWriteAccess();
                    TreeSet<Objective> attributesInContext = new TreeSet<Objective>();
                    for (Objective o : allAttributes) {
                        if (!o.getParentName().equals(context)) continue;
                        attributesInContext.add(o);
                    }
                    DefaultComboBoxModel<Attribute> measurementModel = new DefaultComboBoxModel<Attribute>(attributesInContext.toArray(new Attribute[0]));
                    DefaultComboBoxModel<Attribute> simulationModel = new DefaultComboBoxModel<Attribute>(attributesInContext.toArray(new Attribute[0]));
                    ObjectiveConfiguration.this.measurementList.setModel(measurementModel);
                    ObjectiveConfiguration.this.simulationList.setModel(simulationModel);
                    for (ActionListener l : ObjectiveConfiguration.this.measurementList.getActionListeners()) {
                        ObjectiveConfiguration.this.measurementList.removeActionListener(l);
                    }
                    for (ActionListener l : ObjectiveConfiguration.this.simulationList.getActionListeners()) {
                        ObjectiveConfiguration.this.simulationList.removeActionListener(l);
                    }
                    ObjectiveConfiguration.this.simulationList.addActionListener(ObjectiveConfiguration.this.simulationListUpdateListener);
                    ObjectiveConfiguration.this.simulationList.setSelectedIndex(-1);
                    ObjectiveConfiguration.this.measurementList.addActionListener(ObjectiveConfiguration.this.measurementListUpdateListener);
                    ObjectiveConfiguration.this.measurementList.setSelectedIndex(-1);
                    ObjectiveConfiguration.this.updateTimeList();
                    ObjectiveConfiguration.this.updateButtonStates();
                }
            }
        });
        this.measurementList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveConfiguration.this.updateButtonStates();
            }
        });
        this.simulationList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectiveConfiguration.this.updateButtonStates();
            }
        });
        this.timeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = ObjectiveConfiguration.this.timeList.getSelectedItem();
                if (o == null) {
                    return;
                }
                Attribute a = (Attribute)o;
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                od.setTimeAttribute(a);
                ObjectiveConfiguration.this.updateButtonStates();
            }
        });
        this.measurementList.addActionListener(this.measurementListUpdateListener);
        this.simulationList.addActionListener(this.simulationListUpdateListener);
        this.loadTimeSerie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = ObjectiveConfiguration.this.timeseriesFileChooser.showOpenDialog(ObjectiveConfiguration.this.dialog);
                if (result == 0) {
                    File f = ObjectiveConfiguration.this.timeseriesFileChooser.getSelectedFile();
                    ObjectiveConfiguration.this.loadTimeseries(f);
                    ObjectiveConfiguration.this.updateButtonStates();
                }
            }
        });
        this.filterList.addChangeListener(new TimeFilterTableInput.TimeFilterTableInputListener(){

            @Override
            public void tableChanged(TimeFilterTableInput tfti) {
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                od.setTimeFilters(ObjectiveConfiguration.this.filterList.getTimeFilters());
                ObjectiveConfiguration.this.hydroChart.setTimeFilters(ObjectiveConfiguration.this.filterList.getTimeFilters());
                ObjectiveConfiguration.this.filterList.updateUI();
            }

            @Override
            public void itemChanged(TimeFilterTableInput tfti) {
                ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectivesList.getSelectedItem();
                od.setTimeFilters(ObjectiveConfiguration.this.filterList.getTimeFilters());
                ObjectiveConfiguration.this.hydroChart.setTimeFilters(ObjectiveConfiguration.this.filterList.getTimeFilters(), true);
                ObjectiveConfiguration.this.filterList.updateUI();
            }
        });
        this.filterList.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DefaultListSelectionModel source;
                int index;
                if (!e.getValueIsAdjusting() && (index = (source = (DefaultListSelectionModel)e.getSource()).getMinSelectionIndex()) != -1) {
                    TimeFilter f = ObjectiveConfiguration.this.filterList.getTimeFilters().get(index);
                    ObjectiveConfiguration.this.hydroChart.setSelectedTimeFilter(f);
                }
                ObjectiveConfiguration.this.filterList.updateUI();
            }
        });
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getTrigger().getButton() != 1) {
                    return;
                }
                if (cme.getTrigger().getClickCount() != 1) {
                    return;
                }
                XYItemEntity entity = (XYItemEntity)cme.getEntity();
                if (entity == null) {
                    return;
                }
                int index = entity.getItem();
                Date time = ObjectiveConfiguration.this.hydroChart.hydrograph.getTime(index);
                TimeFilter filter = null;
                if (!ObjectiveConfiguration.this.hydroChart.filters.combine().isFiltered(time)) {
                    for (int i = 0; i < ObjectiveConfiguration.this.hydroChart.filters.size(); ++i) {
                        TimeFilter f = ObjectiveConfiguration.this.hydroChart.filters.get(i);
                        boolean isFiltered = f.isFiltered(time);
                        if (!f.isEnabled()) continue;
                        if (f.isInverted()) {
                            boolean bl = isFiltered = !isFiltered;
                        }
                        if (isFiltered) continue;
                        filter = f;
                        break;
                    }
                }
                ObjectiveConfiguration.this.hydroChart.setSelectedTimeFilter(filter);
                ObjectiveConfiguration.this.filterList.setSelectedItem(filter);
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
        if (md != null) {
            Enumeration e = md.getRootNode().breadthFirstEnumeration();
            this.objectives.addElement(null);
            while (e.hasMoreElements()) {
                ComponentDescriptor cd;
                Object o;
                Object nodeObj = e.nextElement();
                if (!(nodeObj instanceof DefaultMutableTreeNode) || !((o = ((DefaultMutableTreeNode)nodeObj).getUserObject()) instanceof ComponentDescriptor) || !UniversalEfficiencyCalculator.class.isAssignableFrom((cd = (ComponentDescriptor)o).getClazz())) continue;
                try {
                    ObjectiveDescription od = ObjectiveDescription.importFromComponentDescriptor(cd);
                    this.objectives.addElement(od);
                }
                catch (OPTASWizardException owe) {
                    System.out.println("TODO");
                    owe.printStackTrace();
                }
            }
            this.objectivesList.setModel(this.objectives);
            this.objectivesList.setSelectedIndex(0);
            DefaultComboBoxModel<String> contextModel = new DefaultComboBoxModel<String>();
            for (ComponentDescriptor c : md.getComponentDescriptors().values()) {
                if (!(c instanceof ContextDescriptor)) continue;
                contextModel.addElement(c.getInstanceName());
            }
            this.contextList.setModel(contextModel);
            this.contextList.setSelectedIndex(-1);
            this.modelTimeIntervalInput.setValue("1900-11-01 00:00 2100-11-01 00:00 6 1");
            this.modelTimeIntervalInput.addValueChangeListener(new ValueChangeListener(){

                public void valueChanged() {
                    ObjectiveDescription od = (ObjectiveDescription)ObjectiveConfiguration.this.objectives.getSelectedItem();
                    if (od != null) {
                        od.setModelTimeInterval(ObjectiveConfiguration.this.modelTimeIntervalInput.getTimeInterval());
                    }
                }
            });
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.objectivesList.getSelectedItem() == null) {
            this.rmObjective.setEnabled(false);
            this.editObjective.setEnabled(false);
            this.contextList.setEnabled(false);
            this.filterList.setEnabled(false);
        } else {
            this.rmObjective.setEnabled(true);
            this.editObjective.setEnabled(true);
            this.contextList.setEnabled(true);
            this.filterList.setEnabled(true);
        }
        if (this.contextList.getSelectedIndex() != -1 && this.contextList.isEnabled()) {
            this.measurementList.setEnabled(true);
            this.simulationList.setEnabled(true);
            this.timeList.setEnabled(true);
        } else {
            this.measurementList.setEnabled(false);
            this.simulationList.setEnabled(false);
            this.timeList.setEnabled(false);
        }
        if (this.filterList.timeserie == null) {
            this.filterList.setEnabled(false);
        } else {
            this.filterList.setEnabled(true);
        }
        boolean enableOkButton = true;
        for (int i = 0; i < this.objectives.getSize(); ++i) {
            ObjectiveDescription od = this.objectives.getElementAt(i);
            if (od == null) {
                enableOkButton = this.objectives.getSize() > 1;
                continue;
            }
            if (od.getMeasurementAttribute() == null) {
                enableOkButton = false;
            }
            if (od.getSimulationAttribute() == null) {
                enableOkButton = false;
            }
            if (od.getTimeAttribute() == null) {
                enableOkButton = false;
            }
            if (od.getName() != null) continue;
            enableOkButton = false;
        }
        this.okButton.setEnabled(enableOkButton);
    }

    private void loadTimeseries(File f) {
        TSDataReader tsr = null;
        try {
            tsr = new TSDataReader(f);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.dialog, JAMS.i18n((String)"An error occured .. ") + ioe.toString());
        }
        if (tsr != null) {
            TimeSerie ts = null;
            try {
                ts = tsr.getData(0);
            }
            catch (OPTASWizardException owe) {
                JOptionPane.showMessageDialog(this.dialog, owe.toString());
            }
            this.modelTimeIntervalInput.setValue(ts.getTimeDomain().getValue());
            if (ts != null) {
                this.hydroChart.setTimeFilters(this.filterList.getTimeFilters());
                this.hydroChart.setHydrograph(ts);
                JAMSTools.addToRecentFiles((SystemProperties)this.systemProperties, (String)"objectiveconfiguration_recent_timeseries", (String)f.getAbsolutePath());
                this.updateRecentTimeseriesList(f);
            }
            this.filterList.setTimeSeries(ts);
            this.filterList.updateUI();
        }
    }

    private void updateRecentTimeseriesList(File lastFile) {
        DefaultComboBoxModel<String> recentTimeSeriesModel = new DefaultComboBoxModel<String>(JAMSTools.getRecentFiles((SystemProperties)this.systemProperties, (String)"objectiveconfiguration_recent_timeseries"));
        recentTimeSeriesModel.insertElementAt("", 0);
        this.recentTimeSeries.setModel(recentTimeSeriesModel);
        if (lastFile == null) {
            this.recentTimeSeries.setSelectedIndex(0);
        } else {
            this.recentTimeSeries.setSelectedItem(lastFile.getAbsolutePath());
        }
    }

    public ModelDescriptor getModelDescriptor() {
        return this.md;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void applyChanges() {
        ModelModifier modifier = new ModelModifier(this.md);
        ObjectiveDescription[] odList = new ObjectiveDescription[this.objectives.getSize()];
        for (int i = 0; i < odList.length; ++i) {
            odList[i] = this.objectives.getElementAt(i);
        }
        try {
            modifier.updateObjectiveCalculators(odList);
        }
        catch (OPTASWizardException owe) {
            owe.printStackTrace();
        }
    }

    private void initGUI() {
        File f = !StringTools.isEmptyString((String)this.md.getWorkspacePath()) ? new File(this.md.getWorkspacePath()) : this.savePath;
        this.timeseriesFileChooser.setSelectedFile(f);
        GroupLayout layout = new GroupLayout(this);
        this.hydroChart.setFilterMode(HydrographChart.FilterMode.SINGLE_ROW);
        this.objectivesList.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Objectives")));
        this.measurementList.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Measured_Property")));
        this.simulationList.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Simulated_Property")));
        this.contextList.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Context")));
        this.objectivesList.setMaximumSize(new Dimension(200, 40));
        this.objectivesList.setEditable(false);
        this.measurementList.setMaximumSize(new Dimension(200, 40));
        this.simulationList.setMaximumSize(new Dimension(200, 40));
        this.contextList.setMaximumSize(new Dimension(200, 40));
        this.recentTimeSeries.setMaximumSize(new Dimension(200, 25));
        this.modelTimeIntervalInput.setBorder((Border)BorderFactory.createTitledBorder(JAMS.i18n((String)"Model_time_interval")));
        this.modelTimeIntervalInput.setEnabled(false);
        this.timeList.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Time_Attribute")));
        this.timeList.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.filterList));
        scrollPane.setPreferredSize(new Dimension(520, 400));
        scrollPane.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"time_filters")));
        this.timeIntervalPanel.setLayout(new BorderLayout());
        this.timeIntervalPanel.add((Component)scrollPane, "West");
        this.chartPanel = new PatchedChartPanel(this.hydroChart.getChart(), true);
        JPanel hydroChartPanel = new JPanel();
        GroupLayout hydroChartLayout = new GroupLayout(hydroChartPanel);
        hydroChartPanel.setLayout(hydroChartLayout);
        hydroChartLayout.setHorizontalGroup(hydroChartLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)((Object)this.chartPanel)).addGroup(hydroChartLayout.createSequentialGroup().addComponent(this.loadTimeSerie).addComponent(this.recentTimeSeries)));
        hydroChartLayout.setVerticalGroup(hydroChartLayout.createSequentialGroup().addComponent((Component)((Object)this.chartPanel)).addGroup(hydroChartLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loadTimeSerie).addComponent(this.recentTimeSeries)));
        JPanel generalInformationPanel = new JPanel();
        GroupLayout layout2 = new GroupLayout(generalInformationPanel);
        generalInformationPanel.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup().addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup().addComponent(this.objectivesList).addGap(5).addComponent(this.contextList).addGap(5).addComponent(this.simulationList).addGap(5).addComponent(this.measurementList).addGap(5).addComponent(this.timeList).addGap(5)).addGroup(layout2.createParallelGroup().addGroup(layout2.createSequentialGroup().addComponent(this.addObjective).addComponent(this.rmObjective).addComponent(this.editObjective)).addComponent((Component)this.modelTimeIntervalInput))));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout2.createSequentialGroup().addComponent(this.objectivesList).addGap(5).addComponent(this.contextList).addGap(5).addComponent(this.simulationList).addGap(5).addComponent(this.measurementList).addGap(5).addComponent(this.timeList).addGap(5)).addGroup(layout2.createSequentialGroup().addGap(15).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.addObjective).addComponent(this.rmObjective).addComponent(this.editObjective)).addGap(10).addComponent((Component)this.modelTimeIntervalInput))));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(generalInformationPanel).addComponent(this.timeIntervalPanel)).addComponent(hydroChartPanel)).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addComponent(this.cancelButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(generalInformationPanel).addComponent(this.timeIntervalPanel)).addComponent(hydroChartPanel)).addGroup(layout.createParallelGroup().addComponent(this.okButton).addComponent(this.cancelButton)).addGap(15));
        this.setLayout(layout);
        this.invalidate();
    }

    public JDialog showDialog(JFrame parent) {
        this.dialog = new JDialog((Frame)parent, JAMS.i18n((String)"Efficiency_Configuration"));
        this.dialog.getContentPane().add(this);
        this.dialog.revalidate();
        this.dialog.setSize(this.preferredDimension);
        this.dialog.setLocationByPlatform(true);
        this.dialog.setVisible(true);
        return this.dialog;
    }
}

