/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.JAMSException;
import jams.data.Attribute;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelNode;
import jams.meta.OutputDSDescriptor;
import jams.model.GUIComponent;
import jams.model.JAMSContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.MutableTreeNode;
import optas.efficiencies.UniversalEfficiencyCalculator;
import optas.gui.wizard.Attribute;
import optas.gui.wizard.OPTASWizardException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.ObjectiveDescription;
import optas.gui.wizard.Parameter;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.SimpleOptimizationController;

public class ModelModifier {
    private ModelDescriptor md;
    static final String OPTIMIZER_CONTEXT_NAME = "optimizer";
    static final String OBJECTIVE_COMPONENT_NAME = "objective";
    static final String CONNECT_STRING = "___";

    public ModelModifier(ModelDescriptor md) {
        this.md = md;
    }

    private ContextDescriptor createStandardOptimizerComponent() {
        try {
            ContextDescriptor cd = new ContextDescriptor(OPTIMIZER_CONTEXT_NAME, SimpleOptimizationController.class);
            cd.setComponentAttribute_("optimizationClassName", OptimizerLibrary.getDefaultOptimizer().getClass().getCanonicalName());
            return cd;
        }
        catch (ComponentDescriptor.NullClassException nce) {
            return null;
        }
    }

    public void setOptimizerDescription(OptimizerDescription od) {
        ComponentDescriptor optimizerContext = this.md.getComponentDescriptor(OPTIMIZER_CONTEXT_NAME);
        optimizerContext.setComponentAttribute_("optimizationClassName", od.getOptimizerClassName());
        optimizerContext.setComponentAttribute_("parameterization", this.getOptimizerParameterString(od));
    }

    public ModelDescriptor getModelDescriptor() {
        return this.md;
    }

    private String getOptimizerParameterString(OptimizerDescription opt) {
        String parameter = "";
        for (OptimizerParameter p : opt.getPropertyMap().values()) {
            parameter = parameter + p.getString() + ";";
        }
        return parameter;
    }

    /*
     * WARNING - void declaration
     */
    public boolean updateObjectiveList(Set<Objective> oList) {
        void var4_9;
        TreeSet<Objective> list = new TreeSet<Objective>();
        for (Objective objective : oList) {
            list.add(objective);
        }
        oList = list;
        ContextDescriptor optimizerContext = (ContextDescriptor)this.md.getComponentDescriptor(OPTIMIZER_CONTEXT_NAME);
        try {
            for (Objective o : oList) {
                ContextAttribute ca;
                String attributeName;
                if (o.field instanceof ComponentField) {
                    ComponentField cf = (ComponentField)o.field;
                    attributeName = cf.getParent().getInstanceName() + CONNECT_STRING + cf.getName();
                    optimizerContext.addDynamicAttribute(attributeName, Attribute.Double.class);
                    if (cf.getContextAttributes().size() != 0) {
                        for (ContextAttribute ca2 : cf.getContextAttributes()) {
                            HashSet cpySet = (HashSet)ca2.getFields().clone();
                            for (ComponentField field : cpySet) {
                                field.unlinkFromAttribute(ca2);
                                field.linkToAttribute(optimizerContext, attributeName);
                            }
                        }
                    }
                    cf.linkToAttribute(optimizerContext, attributeName);
                    cf.setValue("");
                    o.field = optimizerContext.getDynamicAttributes().get(attributeName);
                }
                if (!(o.field instanceof ContextAttribute) || (ca = (ContextAttribute)o.field).getContext() == optimizerContext) continue;
                attributeName = ca.getContext().getInstanceName() + CONNECT_STRING + ca.getName();
                if (!optimizerContext.getDynamicAttributes().containsKey(attributeName)) {
                    optimizerContext.addDynamicAttribute(attributeName, Attribute.Double.class);
                }
                while (ca.getFields().size() > 0) {
                    ComponentField field = (ComponentField)ca.getFields().iterator().next();
                    field.unlinkFromAttribute(ca);
                    field.linkToAttribute(optimizerContext, attributeName);
                }
                ca.getContext().removeStaticAttribute(ca.getName());
                o.field = optimizerContext.getDynamicAttributes().get(attributeName);
            }
        }
        catch (JAMSException jAMSException) {
            jAMSException.printStackTrace();
        }
        String string = "";
        ComponentField cf = (ComponentField)optimizerContext.getComponentFields().get("effValue");
        cf.unlinkFromAttribute();
        for (Objective o : oList) {
            if (!(o.field instanceof ContextAttribute)) continue;
            ContextAttribute ca = (ContextAttribute)o.field;
            String string2 = (String)var4_9 + ca.getName() + ";";
            try {
                cf.linkToAttribute(ca.getContext(), ca.getName(), false);
            }
            catch (JAMSException ale) {
                ale.printStackTrace();
                return false;
            }
        }
        optimizerContext.setComponentAttribute_("effMethodName", (String)var4_9);
        return true;
    }

    public boolean updateParameterList(Set<Parameter> pList) {
        ContextDescriptor optimizerContext = (ContextDescriptor)this.md.getComponentDescriptor(OPTIMIZER_CONTEXT_NAME);
        try {
            for (Parameter p : pList) {
                ContextAttribute ca;
                String attributeName;
                if (p.field instanceof ComponentField) {
                    ComponentField cf = (ComponentField)p.field;
                    attributeName = cf.getParent().getInstanceName() + CONNECT_STRING + cf.getName();
                    optimizerContext.addStaticAttribute(attributeName, Attribute.Double.class, cf.getValue());
                    cf.linkToAttribute(optimizerContext, attributeName);
                    cf.setValue("");
                    p.field = optimizerContext.getStaticAttributes().get(attributeName);
                }
                if (!(p.field instanceof ContextAttribute) || (ca = (ContextAttribute)p.field).getContext() == optimizerContext) continue;
                attributeName = ca.getContext().getInstanceName() + CONNECT_STRING + ca.getName();
                optimizerContext.addStaticAttribute(attributeName, Attribute.Double.class, ca.getValue());
                for (ComponentField field : ca.getFields()) {
                    field.unlinkFromAttribute(ca);
                    field.linkToAttribute(optimizerContext, attributeName);
                }
                for (ComponentDescriptor cd : ca.getContext().getComponentRepository().getComponentDescriptors().values()) {
                    for (ComponentField cf : cd.getComponentFields().values()) {
                        if (cf.getContext() == null || !cf.getContext().equals(ca.getContext()) || !cf.getAttribute().equals(ca.getName())) continue;
                        cf.linkToAttribute(optimizerContext, attributeName, true);
                    }
                }
                ca.getContext().removeStaticAttribute(ca.getName());
                p.field = optimizerContext.getStaticAttributes().get(attributeName);
            }
        }
        catch (JAMSException ale) {
            ale.printStackTrace();
        }
        String parameterNames = "";
        String boundaries = "";
        String startvalues = "[";
        ComponentField cf = (ComponentField)optimizerContext.getComponentFields().get("parameterIDs");
        cf.unlinkFromAttribute();
        for (Parameter p : pList) {
            if (!(p.field instanceof ContextAttribute)) continue;
            ContextAttribute ca = (ContextAttribute)p.field;
            parameterNames = parameterNames + ca.getName() + ";";
            boundaries = boundaries + "[" + p.getLowerBound() + ">" + p.getUpperBound() + "];";
            String startvalue = null;
            if (p.getStartValue() != null && p.getStartValue().length > 0) {
                startvalue = Double.toString(p.getStartValue()[0]);
            }
            startvalues = startvalue != null && startvalues != null ? (startvalues.length() > 1 ? startvalues + "," + startvalue : startvalues + startvalue) : null;
            try {
                cf.linkToAttribute(ca.getContext(), ca.getName(), false);
            }
            catch (JAMSException ale) {
                ale.printStackTrace();
                return false;
            }
        }
        if (startvalues != null) {
            startvalues = startvalues + "]";
        }
        optimizerContext.setComponentAttribute_("parameterNames", parameterNames);
        optimizerContext.setComponentAttribute_("boundaries", boundaries);
        if (startvalues == null) {
            optimizerContext.setComponentAttribute_("startValue", "");
        } else {
            optimizerContext.setComponentAttribute_("startValue", startvalues);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateObjectiveCalculators(ObjectiveDescription[] odList) throws OPTASWizardException {
        for (ObjectiveDescription od : odList) {
            if (od == null) continue;
            String name = od.getName();
            if (od.getMeasurementAttribute() == null) {
                throw new OPTASWizardException("Please specify a measuremed attribute!");
            }
            if (od.getSimulationAttribute() == null) {
                throw new OPTASWizardException("Please specify a simulated attribute!");
            }
            ComponentDescriptor measurementContext = this.md.getComponentDescriptor(od.getMeasurementAttribute().getParentName());
            ComponentDescriptor simulationContext = this.md.getComponentDescriptor(od.getSimulationAttribute().getParentName());
            if (simulationContext != measurementContext) {
                throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration_context_of_measurement_attribute_does_not_fit_context_of_simulation_attribute(%1 vs. %2)").replace("%1", measurementContext.getInstanceName()).replace("%2", simulationContext.getInstanceName()));
            }
            if (!(measurementContext instanceof ContextDescriptor)) {
                throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration:Componente_%1_is_not_a_context!").replace("%1", measurementContext.getInstanceName()));
            }
            ContextDescriptor context = (ContextDescriptor)measurementContext;
            ContextDescriptor modelContext = (ContextDescriptor)this.md.getComponentDescriptor(this.md.getModelName());
            ComponentDescriptor cd = this.md.getComponentDescriptor(name);
            boolean allreadyExisting = false;
            if (cd != null && UniversalEfficiencyCalculator.class.isAssignableFrom(cd.getClazz()) && context.getComponentRepository().getComponentDescriptors().containsValue(cd)) {
                allreadyExisting = true;
                HashMap fields = cd.getComponentFields();
                ((ComponentField)fields.get("measurementAttributeName")).setValue("measurement");
                ((ComponentField)fields.get("measurement")).linkToAttribute(context, od.getMeasurementAttribute().getAttributeName(), true);
                ((ComponentField)fields.get("simulationAttributeName")).setValue("simulation");
                ((ComponentField)fields.get("simulation")).linkToAttribute(context, od.getSimulationAttribute().getAttributeName(), true);
                if (((ComponentField)fields.get("e1")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("e1")).linkToAttribute(modelContext, name + "_e1");
                }
                if (((ComponentField)fields.get("e2")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("e2")).linkToAttribute(modelContext, name + "_e2");
                }
                if (((ComponentField)fields.get("le1")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("le1")).linkToAttribute(modelContext, name + "_e1");
                }
                if (((ComponentField)fields.get("le2")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("le2")).linkToAttribute(modelContext, name + "_e2");
                }
                if (((ComponentField)fields.get("ave")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("ave")).linkToAttribute(modelContext, name + "_ave");
                }
                if (((ComponentField)fields.get("r2")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("r2")).linkToAttribute(modelContext, name + "_r2");
                }
                if (((ComponentField)fields.get("bias")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("bias")).linkToAttribute(modelContext, name + "_bias");
                }
                if (((ComponentField)fields.get("e1_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("e1_normalized")).linkToAttribute(modelContext, name + "_e1_normalized");
                }
                if (((ComponentField)fields.get("e2_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("e2_normalized")).linkToAttribute(modelContext, name + "_e2_normalized");
                }
                if (((ComponentField)fields.get("le1_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("le1_normalized")).linkToAttribute(modelContext, name + "_le1_normalized");
                }
                if (((ComponentField)fields.get("le2_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("le2_normalized")).linkToAttribute(modelContext, name + "_le2_normalized");
                }
                if (((ComponentField)fields.get("ave_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("ave_normalized")).linkToAttribute(modelContext, name + "_ave_normalized");
                }
                if (((ComponentField)fields.get("r2_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("r2_normalized")).linkToAttribute(modelContext, name + "_r2_normalized");
                }
                if (((ComponentField)fields.get("bias_normalized")).getContextAttributes().isEmpty()) {
                    ((ComponentField)fields.get("bias_normalized")).linkToAttribute(modelContext, name + "_bias_normalized");
                }
                if (od.getTimeFilters().get().size() > 0) {
                    Attribute.TimeInterval[] timeIntervals;
                    String timeIntervalString = "";
                    for (Attribute.TimeInterval timeInterval : timeIntervals = od.getTimeFilters().toTimeIntervals(od.getModelTimeInterval())) {
                        timeIntervalString = timeIntervalString + timeInterval.toString() + ";";
                    }
                    ((ComponentField)fields.get("timeInterval")).setValue(timeIntervalString);
                }
                if (od.getTimeAttribute() != null) {
                    ComponentDescriptor timeComponent = this.md.getComponentDescriptor(od.getTimeAttribute().getParentName());
                    if (timeComponent == null || !(timeComponent instanceof ContextDescriptor)) {
                        throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration:Componente_%1_is_not_a_context!").replace("%1", timeComponent.getInstanceName()));
                    }
                    ContextDescriptor timeContext = (ContextDescriptor)timeComponent;
                    String timeAttributeName = od.getTimeAttribute().getAttributeName();
                    if (!timeContext.getAttributes(Attribute.Calendar.class).containsKey(timeAttributeName)) {
                        throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration:Context_%1_does_not_contain_time_attribute!").replace("%1", timeContext.getInstanceName()));
                    }
                    ((ComponentField)fields.get("time")).linkToAttribute(timeContext, timeAttributeName, true);
                }
            }
            if (!allreadyExisting) {
                String originalName = name;
                int counter = 1;
                while (this.md.getComponentDescriptor(name) != null) {
                    name = originalName + counter++;
                }
                od.setName(name);
                ComponentDescriptor objectiveComponent = new ComponentDescriptor(name, UniversalEfficiencyCalculator.class);
                HashMap fields = objectiveComponent.getComponentFields();
                ((ComponentField)fields.get("measurementAttributeName")).setValue("measurement");
                ((ComponentField)fields.get("measurement")).linkToAttribute(context, od.getMeasurementAttribute().getAttributeName(), true);
                ((ComponentField)fields.get("simulationAttributeName")).setValue("simulation");
                ((ComponentField)fields.get("simulation")).linkToAttribute(context, od.getSimulationAttribute().getAttributeName(), true);
                ((ComponentField)fields.get("e1")).linkToAttribute(modelContext, name + "_e1");
                ((ComponentField)fields.get("e2")).linkToAttribute(modelContext, name + "_e2");
                ((ComponentField)fields.get("le1")).linkToAttribute(modelContext, name + "_le1");
                ((ComponentField)fields.get("le2")).linkToAttribute(modelContext, name + "_le2");
                ((ComponentField)fields.get("ave")).linkToAttribute(modelContext, name + "_ave");
                ((ComponentField)fields.get("r2")).linkToAttribute(modelContext, name + "_r2");
                ((ComponentField)fields.get("bias")).linkToAttribute(modelContext, name + "_bias");
                ((ComponentField)fields.get("e1_normalized")).linkToAttribute(modelContext, name + "_e1_normalized");
                ((ComponentField)fields.get("e2_normalized")).linkToAttribute(modelContext, name + "_e2_normalized");
                ((ComponentField)fields.get("le1_normalized")).linkToAttribute(modelContext, name + "_le1_normalized");
                ((ComponentField)fields.get("le2_normalized")).linkToAttribute(modelContext, name + "_le2_normalized");
                ((ComponentField)fields.get("ave_normalized")).linkToAttribute(modelContext, name + "_ave_normalized");
                ((ComponentField)fields.get("r2_normalized")).linkToAttribute(modelContext, name + "_r2_normalized");
                ((ComponentField)fields.get("bias_normalized")).linkToAttribute(modelContext, name + "_bias_normalized");
                if (od.getTimeFilters().get().size() > 0) {
                    Attribute.TimeInterval[] timeIntervals;
                    String timeIntervalString = "";
                    for (Attribute.TimeInterval I2 : timeIntervals = od.getTimeFilters().toTimeIntervals(od.getModelTimeInterval())) {
                        timeIntervalString = timeIntervalString + I2.toString() + ";";
                    }
                    ((ComponentField)fields.get("timeInterval")).setValue(timeIntervalString);
                }
                if (od.getTimeAttribute() != null) {
                    ComponentDescriptor timeComponent = this.md.getComponentDescriptor(od.getTimeAttribute().getParentName());
                    if (timeComponent == null || !(timeComponent instanceof ContextDescriptor)) {
                        throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration:Componente_%1_is_not_a_context!").replace("%1", timeComponent.getInstanceName()));
                    }
                    ContextDescriptor timeContext = (ContextDescriptor)timeComponent;
                    String string = od.getTimeAttribute().getAttributeName();
                    if (!timeContext.getAttributes(Attribute.Calendar.class).containsKey(string)) {
                        throw new OPTASWizardException(JAMS.i18n((String)"Error_during_objective_configuration:Context_%1_does_not_contain_time_attribute!").replace("%1", timeContext.getInstanceName()));
                    }
                    ((ComponentField)fields.get("time")).linkToAttribute(timeContext, string, true);
                }
                ModelNode objectiveNode = new ModelNode((Object)objectiveComponent);
                objectiveNode.setType(0);
                context.getNode().insert((MutableTreeNode)objectiveNode, context.getNode().getChildCount() - 1);
            }
            boolean wasChangedInLastIteration = true;
            while (wasChangedInLastIteration) {
                wasChangedInLastIteration = false;
                block5: for (ComponentDescriptor cd2 : this.md.getComponentDescriptors().values()) {
                    void var19_34;
                    if (!UniversalEfficiencyCalculator.class.isAssignableFrom(cd2.getClazz())) continue;
                    boolean isInList = false;
                    ObjectiveDescription[] objectiveNode = odList;
                    int timeContext = objectiveNode.length;
                    boolean bl = false;
                    while (var19_34 < timeContext) {
                        ObjectiveDescription od2 = objectiveNode[var19_34];
                        if (od2 != null && od2.getName().equals(cd2.getInstanceName())) {
                            isInList = true;
                            break;
                        }
                        ++var19_34;
                    }
                    if (isInList) continue;
                    Enumeration nodes = this.md.getRootNode().breadthFirstEnumeration();
                    while (nodes.hasMoreElements()) {
                        ModelNode node = (ModelNode)nodes.nextElement();
                        if (!cd2.equals((ComponentDescriptor)node.getUserObject())) continue;
                        ((ModelNode)node.getParent()).remove((MutableTreeNode)node);
                        wasChangedInLastIteration = true;
                        continue block5;
                    }
                }
            }
        }
    }

    public OptimizerDescription addOptimizationContext() {
        try {
            ModelNode rootNode = this.md.getRootNode();
            ContextDescriptor optimizerContext = this.createStandardOptimizerComponent();
            ModelNode optimizerNode = new ModelNode((Object)optimizerContext);
            optimizerNode.setType(1);
            ModelNode contextNode = rootNode;
            optimizerNode.insert((MutableTreeNode)contextNode, 0);
            ContextDescriptor containerContext = new ContextDescriptor("container", JAMSContext.class);
            ModelNode containerNode = new ModelNode((Object)containerContext);
            containerNode.setType(1);
            containerNode.insert((MutableTreeNode)optimizerNode, 0);
            this.md.setRootNode(containerNode);
            this.md.registerComponentDescriptor(OPTIMIZER_CONTEXT_NAME, OPTIMIZER_CONTEXT_NAME, (ComponentDescriptor)optimizerContext);
            this.md.registerComponentDescriptor("container", "container", (ComponentDescriptor)containerContext);
        }
        catch (ComponentDescriptor.NullClassException nce) {
            nce.printStackTrace();
            return null;
        }
        return OptimizerLibrary.getDefaultOptimizer().getDescription();
    }

    private boolean configOutput(ArrayList<Attribute> attributeList) {
        OutputDSDescriptor ds = (OutputDSDescriptor)this.md.getDatastores().get(OPTIMIZER_CONTEXT_NAME);
        if (ds == null) {
            ds = new OutputDSDescriptor((ContextDescriptor)this.md.getComponentDescriptor(OPTIMIZER_CONTEXT_NAME));
            ds.setName(OPTIMIZER_CONTEXT_NAME);
            this.md.addOutputDataStore(ds);
        }
        ArrayList outputDSList = ds.getContextAttributes();
        for (Attribute a : attributeList) {
            if (!(a.field instanceof ContextAttribute)) continue;
            ContextAttribute ca = (ContextAttribute)a.field;
            boolean containsAttribute = false;
            for (ContextAttribute outputCa : outputDSList) {
                if (!outputCa.getName().equals(ca.getName())) continue;
                containsAttribute = true;
                break;
            }
            if (containsAttribute) continue;
            ds.getContextAttributes().add(ca);
        }
        ds.setEnabled(true);
        return true;
    }

    private boolean disableGUIComponents() {
        Enumeration nodes = this.md.getRootNode().breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            ComponentDescriptor cd = (ComponentDescriptor)((ModelNode)nodes.nextElement()).getUserObject();
            if (!GUIComponent.class.isAssignableFrom(cd.getClazz())) continue;
            cd.setEnabled(false);
        }
        return true;
    }

    public void finish(ArrayList<Attribute> exportAttributes) {
        this.configOutput(exportAttributes);
        this.disableGUIComponents();
    }
}

