/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import optas.SA.TemporalSensitivityAnalysis;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.DottyPlot;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.MCAT5.MCAT5Toolbar;
import optas.gui.wizard.HydrographChart;
import optas.hydro.gui.WeightChart;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeriesCollection;

public class TemporalSensitivityAnalysisGUI
extends MCAT5Plot {
    int MAX_WEIGHTS = 37;
    Color[] standardColorList = TemporalSensitivityAnalysisGUI.getDifferentColors(this.MAX_WEIGHTS);
    HydrographChart chart;
    WeightChart weightChart;
    XYLineAndShapeRenderer[] weightRenderer = new XYLineAndShapeRenderer[this.MAX_WEIGHTS];
    JTable parameterTable = new JTable(new Object[][]{{Boolean.TRUE, Boolean.TRUE, "test", Color.black}}, new String[]{"x", "y", "z", "a"});
    JLabel infoLabel = new JLabel("Dominance:?");
    SimpleEnsemble[] p = null;
    EfficiencyEnsemble e = null;
    TimeSerieEnsemble ts = null;
    Measurement obs = null;
    TemporalSensitivityAnalysis temporalAnalysis = null;
    JPanel mainPanel = null;
    JCheckBox selectAll = new JCheckBox("selectAll");
    JCheckBox selectNone = new JCheckBox("selectNone");
    JCheckBox enableAll = new JCheckBox("enableAll");
    JCheckBox enableNone = new JCheckBox("enableNone");

    public static Color[] getDifferentColors(int n) {
        Color[] cols = new Color[153];
        for (int i = 0; i < n; ++i) {
            cols[i] = Color.getHSBColor((float)(i * n % 153) / 152.0f, 1.0f, 1.0f);
        }
        return cols;
    }

    public TemporalSensitivityAnalysisGUI() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        this.weightChart = new WeightChart();
        this.chart = new HydrographChart();
        this.chart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                TemporalSensitivityAnalysisGUI.this.weightChart.getXYPlot().setDomainAxis(TemporalSensitivityAnalysisGUI.this.chart.getXYPlot().getDomainAxis());
            }
        });
        this.weightChart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                TemporalSensitivityAnalysisGUI.this.chart.getXYPlot().setDomainAxis(TemporalSensitivityAnalysisGUI.this.weightChart.getXYPlot().getDomainAxis());
            }
        });
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemporalSensitivityAnalysisGUI.this.selectAll.isEnabled()) {
                    int n = TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().getRowCount();
                    for (int i = 0; i < n; ++i) {
                        TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().setValueAt(Boolean.TRUE, i, 0);
                    }
                }
            }
        });
        this.selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemporalSensitivityAnalysisGUI.this.selectAll.isEnabled()) {
                    int n = TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().getRowCount();
                    for (int i = 0; i < n; ++i) {
                        TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().setValueAt(Boolean.FALSE, i, 0);
                    }
                }
            }
        });
        this.enableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemporalSensitivityAnalysisGUI.this.selectAll.isEnabled()) {
                    int n = TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().getRowCount();
                    for (int i = 0; i < n; ++i) {
                        TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().setValueAt(Boolean.TRUE, i, 2);
                    }
                }
            }
        });
        this.enableNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemporalSensitivityAnalysisGUI.this.selectAll.isEnabled()) {
                    int n = TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().getRowCount();
                    for (int i = 0; i < n; ++i) {
                        TemporalSensitivityAnalysisGUI.this.parameterTable.getModel().setValueAt(Boolean.FALSE, i, 2);
                    }
                }
            }
        });
        for (int i = 0; i < this.MAX_WEIGHTS; ++i) {
            this.weightRenderer[i] = new XYLineAndShapeRenderer();
            this.weightRenderer[i].setBaseFillPaint((Paint)this.standardColorList[i]);
            this.weightRenderer[i].setBaseLinesVisible(true);
            this.weightRenderer[i].setBaseShapesVisible(false);
            this.weightRenderer[i].setBaseSeriesVisible(true);
            this.weightRenderer[i].setDrawSeriesLineAsPath(true);
            this.weightRenderer[i].setStroke((Stroke)new BasicStroke(1.0f));
        }
        PatchedChartPanel weightChartPanel = new PatchedChartPanel(this.weightChart.getChart(), true);
        weightChartPanel.setMinimumDrawWidth(0);
        weightChartPanel.setMinimumDrawHeight(0);
        weightChartPanel.setMaximumDrawWidth(2000);
        weightChartPanel.setMaximumDrawHeight(2000);
        PatchedChartPanel chartPanel = new PatchedChartPanel(this.chart.getChart(), true);
        chartPanel.setMinimumDrawWidth(0);
        chartPanel.setMinimumDrawHeight(0);
        chartPanel.setMaximumDrawWidth(2000);
        chartPanel.setMaximumDrawHeight(2000);
        chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity e = event.getEntity();
                if (e != null && e instanceof XYItemEntity) {
                    XYItemEntity xy = (XYItemEntity)e;
                    int index = xy.getSeriesIndex();
                    int data = xy.getItem();
                    System.out.println("index:" + index);
                    System.out.println("data:" + data);
                    DataCollection dc = new DataCollection();
                    dc.addEnsemble(TemporalSensitivityAnalysisGUI.this.ts.get(data));
                    for (int i = 0; i < TemporalSensitivityAnalysisGUI.this.p.length; ++i) {
                        dc.addEnsemble(TemporalSensitivityAnalysisGUI.this.p[i]);
                    }
                    try {
                        DataRequestPanel d = new DataRequestPanel(new DottyPlot(), dc);
                        JFrame plotWindow = MCAT5Toolbar.getDefaultPlotWindow("test");
                        plotWindow.add((Component)d, "Center");
                        plotWindow.setVisible(true);
                    }
                    catch (MCAT5Plot.NoDataException nde) {
                        System.out.println(nde.toString());
                    }
                    TimeSeriesCollection collection = (TimeSeriesCollection)TemporalSensitivityAnalysisGUI.this.chart.getXYPlot().getDataset(index);
                    System.out.println(collection.getSeries(0).getDataItem(data).getPeriod());
                    System.out.println(collection.getSeries(0).getDataItem(data).getValue());
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        });
        PatchedChartPanel hydrographChartPanel = new PatchedChartPanel(this.chart.getChart(), true);
        hydrographChartPanel.setMinimumDrawWidth(0);
        hydrographChartPanel.setMinimumDrawHeight(0);
        hydrographChartPanel.setMaximumDrawWidth(2000);
        hydrographChartPanel.setMaximumDrawHeight(2000);
        this.parameterTable.setAutoResizeMode(4);
        this.parameterTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.parameterTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        JScrollPane parameterTablePane = new JScrollPane(this.parameterTable);
        parameterTablePane.setPreferredSize(new Dimension(300, 500));
        JPanel sideBar = new JPanel();
        GroupLayout sideLayout = new GroupLayout(sideBar);
        sideLayout.setAutoCreateGaps(true);
        sideLayout.setAutoCreateContainerGaps(true);
        sideBar.setLayout(sideLayout);
        sideLayout.setHorizontalGroup(sideLayout.createParallelGroup().addComponent(parameterTablePane).addGroup(sideLayout.createSequentialGroup().addComponent(this.enableAll).addComponent(this.enableNone).addComponent(this.selectAll).addComponent(this.selectNone)).addComponent(this.infoLabel));
        sideLayout.setVerticalGroup(sideLayout.createSequentialGroup().addComponent(parameterTablePane, 0, -1, 5000).addGroup(sideLayout.createParallelGroup().addComponent(this.enableAll).addComponent(this.enableNone).addComponent(this.selectAll).addComponent(this.selectNone)).addComponent(this.infoLabel).addGap(0, 0, 5000));
        this.mainPanel = new JPanel();
        GroupLayout mainLayout = new GroupLayout(this.mainPanel);
        mainLayout.setAutoCreateGaps(true);
        mainLayout.setAutoCreateContainerGaps(true);
        this.mainPanel.setLayout(mainLayout);
        mainLayout.setHorizontalGroup(mainLayout.createSequentialGroup().addGroup(mainLayout.createParallelGroup().addComponent((Component)((Object)weightChartPanel)).addComponent((Component)((Object)hydrographChartPanel))).addComponent(sideBar));
        mainLayout.setVerticalGroup(mainLayout.createParallelGroup().addGroup(mainLayout.createSequentialGroup().addComponent((Component)((Object)weightChartPanel)).addComponent((Component)((Object)hydrographChartPanel))).addComponent(sideBar));
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] data = this.getData(new int[]{0, 1, 2});
        this.ts = (TimeSerieEnsemble)data[0].get(0);
        this.obs = (Measurement)data[1].get(0);
        this.e = (EfficiencyEnsemble)data[2].get(0);
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        this.p = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String name : xSet) {
            this.p[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.parameterTable.setModel(new ParameterTableModel(this.p));
        this.parameterTable.setDefaultEditor(Color.class, new ColorEditor());
        this.parameterTable.getColumnModel().getColumn(3).setCellRenderer(new ColorRenderer(true));
        this.parameterTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TemporalSensitivityAnalysisGUI.this.weightChart.update(TemporalSensitivityAnalysisGUI.this.temporalAnalysis.calculate(), null, TemporalSensitivityAnalysisGUI.this.p, TemporalSensitivityAnalysisGUI.this.obs, TemporalSensitivityAnalysisGUI.this.getEnableList(), TemporalSensitivityAnalysisGUI.this.getShowList(), TemporalSensitivityAnalysisGUI.this.standardColorList);
            }
        });
        this.parameterTable.setAutoResizeMode(4);
        this.parameterTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.parameterTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.parameterTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.parameterTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.parameterTable.getColumnModel().getColumn(3).setMaxWidth(50);
        this.temporalAnalysis = new TemporalSensitivityAnalysis(this.p, this.e, this.ts, this.obs);
        this.temporalAnalysis.calculate();
        this.chart.setHydrograph(this.obs);
        this.weightChart.update(this.temporalAnalysis.calculate(), null, this.p, this.obs, this.getEnableList(), this.getShowList(), this.standardColorList);
    }

    private boolean[] getEnableList() {
        ParameterTableModel model = (ParameterTableModel)this.parameterTable.getModel();
        boolean[] parameterActive = new boolean[model.getRowCount()];
        for (int i = 0; i < parameterActive.length; ++i) {
            parameterActive[i] = (Boolean)model.getValueAt(i, 2) == true;
        }
        return parameterActive;
    }

    private boolean[] getShowList() {
        ParameterTableModel model = (ParameterTableModel)this.parameterTable.getModel();
        boolean[] parameterActive = new boolean[model.getRowCount()];
        for (int i = 0; i < parameterActive.length; ++i) {
            parameterActive[i] = (Boolean)model.getValueAt(i, 0) == true;
        }
        return parameterActive;
    }

    class ParameterTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"show", "name", "enabled", "color"};
        private Object[][] data = null;

        ParameterTableModel(SimpleEnsemble[] p) {
            this.data = new Object[p.length][3];
            for (int i = 0; i < p.length; ++i) {
                this.data[i][0] = Boolean.TRUE;
                this.data[i][1] = p[i];
                this.data[i][2] = Boolean.TRUE;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 3) {
                return TemporalSensitivityAnalysisGUI.this.standardColorList[row];
            }
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Color.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2 && !((Boolean)value).booleanValue()) {
                this.setValueAt(Boolean.FALSE, row, 0);
            }
            if (col == 0 && ((Boolean)value).booleanValue()) {
                this.setValueAt(Boolean.TRUE, row, 2);
            }
            if (col == 3) {
                TemporalSensitivityAnalysisGUI.this.standardColorList[row] = (Color)value;
            } else {
                this.data[row][col] = value;
            }
            TemporalSensitivityAnalysisGUI.this.selectAll.setSelected(false);
            TemporalSensitivityAnalysisGUI.this.selectNone.setSelected(false);
            TemporalSensitivityAnalysisGUI.this.enableAll.setSelected(false);
            TemporalSensitivityAnalysisGUI.this.enableNone.setSelected(false);
            this.fireTableCellUpdated(row, col);
        }
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

