/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import optas.SA.UniversalSensitivityAnalyzer;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.regression.SimpleInterpolation;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class SensitivityToolbox
extends MCAT5Plot {
    JPanel panel = null;
    JTextField sampleCountField = new JTextField(10);
    JTextField regressionErrorField = new JTextField(10);
    JTextField sampleCountFieldRegression = new JTextField("1000");
    JCheckBox doVarianceEstimation = new JCheckBox("Estimate Uncertainty of Sensitivity");
    JCheckBox doQualityEstimation = new JCheckBox("Estimate Quality");
    JCheckBox useANNRegression = new JCheckBox("Use ANN Regression");
    JComboBox regressionMethod = new JComboBox<String>(new String[]{"Neural Network"});
    JComboBox parameterNormalizationMethod = new JComboBox<SimpleInterpolation.NormalizationMethod>(SimpleInterpolation.NormalizationMethod.values());
    JComboBox objectiveNormalizationMethod = new JComboBox<SimpleInterpolation.NormalizationMethod>(SimpleInterpolation.NormalizationMethod.values());
    String rsaString = "Regional Sensitivity Analysis";
    String mgeString = "Maximum Gradient Estimation";
    String eemString = "Morris Method";
    String eem2String = "Morris Method (not absolute)";
    String eem3String = "Morris Method (Variance)";
    String fosiString = "FAST (First Order)";
    String fosiString2 = "Sobol (First Order)";
    String tosiString = "Sobol (Total)";
    String interactionString = "Interaction Analysis";
    String linearRegString = "Linear Regression";
    JComboBox sensitivityMethod = new JComboBox<String>(new String[]{this.rsaString, this.mgeString, this.eemString, this.eem2String, this.eem3String, this.fosiString, this.fosiString2, this.tosiString, this.interactionString, this.linearRegString});
    CategoryDataset dataset1 = null;
    CategoryDataset dataset2 = null;
    JFreeChart chart = null;
    JButton recalcButton = null;

    public SensitivityToolbox() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        this.panel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel southPanel = new JPanel(new GridBagLayout());
        int rowCounter = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.ipadx = 5;
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Number of Samples(total)"), c);
        c.gridx = 1;
        c.fill = 2;
        this.sampleCountField.setEditable(false);
        southPanel.add((Component)this.sampleCountField, c);
        c.anchor = 17;
        c.ipadx = 5;
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Number of Samples(Regression) "), c);
        c.gridx = 1;
        c.fill = 2;
        this.sampleCountField.setEditable(false);
        southPanel.add((Component)this.sampleCountFieldRegression, c);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        southPanel.add((Component)this.useANNRegression, c);
        this.useANNRegression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SensitivityToolbox.this.useANNRegression.isSelected()) {
                    SensitivityToolbox.this.sampleCountFieldRegression.setEditable(true);
                    SensitivityToolbox.this.regressionMethod.setEnabled(true);
                    SensitivityToolbox.this.doVarianceEstimation.setEnabled(true);
                    SensitivityToolbox.this.parameterNormalizationMethod.setEnabled(true);
                    SensitivityToolbox.this.objectiveNormalizationMethod.setEnabled(true);
                    SensitivityToolbox.this.sensitivityMethod.setModel(new DefaultComboBoxModel<String>(new String[]{SensitivityToolbox.this.rsaString, SensitivityToolbox.this.mgeString, SensitivityToolbox.this.eem2String, SensitivityToolbox.this.eem3String, SensitivityToolbox.this.eemString, SensitivityToolbox.this.fosiString, SensitivityToolbox.this.fosiString2, SensitivityToolbox.this.tosiString, SensitivityToolbox.this.interactionString, SensitivityToolbox.this.linearRegString}));
                    SensitivityToolbox.this.recalcButton.setEnabled(true);
                } else {
                    SensitivityToolbox.this.sampleCountFieldRegression.setEditable(false);
                    SensitivityToolbox.this.regressionMethod.setEnabled(false);
                    SensitivityToolbox.this.regressionErrorField.setText("--");
                    SensitivityToolbox.this.doVarianceEstimation.setEnabled(false);
                    SensitivityToolbox.this.parameterNormalizationMethod.setEnabled(false);
                    SensitivityToolbox.this.objectiveNormalizationMethod.setEnabled(false);
                    SensitivityToolbox.this.sensitivityMethod.setModel(new DefaultComboBoxModel<String>(new String[]{SensitivityToolbox.this.rsaString, SensitivityToolbox.this.linearRegString}));
                    SensitivityToolbox.this.recalcButton.setEnabled(false);
                }
                SensitivityToolbox.this.redraw();
            }
        });
        c.gridwidth = 1;
        this.useANNRegression.setSelected(true);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Method for Regression"), c);
        c.gridx = 1;
        c.fill = 2;
        southPanel.add((Component)this.regressionMethod, c);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Parameter normalization method"), c);
        c.gridx = 1;
        c.fill = 2;
        southPanel.add((Component)this.parameterNormalizationMethod, c);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Objective normalization method"), c);
        c.gridx = 1;
        c.fill = 2;
        southPanel.add((Component)this.objectiveNormalizationMethod, c);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Method for Sensitivity Analysis"), c);
        c.gridx = 1;
        c.fill = 2;
        southPanel.add((Component)this.sensitivityMethod, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = rowCounter++;
        c.fill = 0;
        southPanel.add((Component)new JLabel("Quality of Regression (E2)"), c);
        c.gridx = 1;
        c.fill = 2;
        this.regressionErrorField.setEditable(false);
        southPanel.add((Component)this.regressionErrorField, c);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 10;
        this.regressionErrorField.setEditable(false);
        southPanel.add((Component)this.doVarianceEstimation, c);
        this.doVarianceEstimation.setSelected(false);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 10;
        this.regressionErrorField.setEditable(false);
        southPanel.add((Component)this.doQualityEstimation, c);
        this.doQualityEstimation.setSelected(false);
        c.gridx = 0;
        c.gridy = rowCounter++;
        c.gridwidth = 2;
        c.fill = 0;
        c.anchor = 10;
        this.recalcButton = new JButton(new AbstractAction("Recalculate Regression"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensitivityToolbox.this.redraw();
            }
        });
        southPanel.add((Component)this.recalcButton, c);
        this.chart = ChartFactory.createStackedBarChart((String)"Sensitivity of Parameters", (String)"Parameter", (String)"Sensitivity (%)", (CategoryDataset)this.dataset1, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.lightGray);
        this.chart.getCategoryPlot().setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        PatchedChartPanel chartPanel = new PatchedChartPanel(this.chart);
        chartPanel.setMinimumDrawWidth(0);
        chartPanel.setMinimumDrawHeight(0);
        chartPanel.setMaximumDrawWidth(2000);
        chartPanel.setMaximumDrawHeight(2000);
        this.chart.getPlot().setBackgroundPaint((Paint)Color.white);
        ((StackedBarRenderer)this.chart.getCategoryPlot().getRenderer()).setShadowVisible(false);
        ((BarRenderer)this.chart.getCategoryPlot().getRenderer()).setBarPainter((BarPainter)new StandardBarPainter());
        ((StackedBarRenderer)this.chart.getCategoryPlot().getRenderer()).setToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset cd, int i, int i1) {
                double s0 = cd.getValue(0, i1).doubleValue();
                double s1 = cd.getValue(1, i1).doubleValue();
                double s2 = cd.getValue(2, i1).doubleValue();
                return "<html>min: " + String.format(Locale.ENGLISH, "%.2f", s0) + "<br>mean: " + String.format(Locale.ENGLISH, "%.2f", s0 + s1) + "<br>max: " + String.format(Locale.ENGLISH, "%.2f", s0 + s1 + s2) + "</html>";
            }
        });
        centerPanel.add((Component)((Object)chartPanel));
        this.panel.add((Component)centerPanel, "Center");
        this.panel.add((Component)southPanel, "South");
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        EfficiencyEnsemble p2 = (EfficiencyEnsemble)p[1].get(0);
        SimpleEnsemble[] xData = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String name : xSet) {
            xData[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        UniversalSensitivityAnalyzer uniSA = new UniversalSensitivityAnalyzer();
        if (this.sensitivityMethod.getSelectedItem().equals(this.rsaString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.RSA);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.mgeString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.MaximumGradient);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.eemString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.ElementaryEffects);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.eem2String)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.ElementaryEffectsNonAbs);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.eem3String)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.ElementaryEffectsVariance);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.fosiString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.FOSI1);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.fosiString2)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.FOSI2);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.tosiString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.TOSI);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.interactionString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.Interaction);
        } else if (this.sensitivityMethod.getSelectedItem().equals(this.linearRegString)) {
            uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.LinearRegression);
        }
        uniSA.setUsingRegression(this.useANNRegression.isSelected());
        uniSA.setParameterNormalizationMethod((SimpleInterpolation.NormalizationMethod)((Object)this.parameterNormalizationMethod.getSelectedItem()));
        uniSA.setObjectiveNormalizationMethod((SimpleInterpolation.NormalizationMethod)((Object)this.objectiveNormalizationMethod.getSelectedItem()));
        uniSA.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SensitivityToolbox.this.setState(arg.toString());
            }
        });
        int n = counter;
        double sampleSize = 0.0;
        try {
            sampleSize = Double.parseDouble(this.sampleCountFieldRegression.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.panel, "Please enter a real valued number for sample size!");
            return;
        }
        uniSA.setSampleCount((int)sampleSize);
        double[][] data = new double[3][n];
        String[] categoryName = new String[n];
        uniSA.setup(xData, p2);
        if (this.doQualityEstimation.isSelected()) {
            this.regressionErrorField.setText(Double.toString(uniSA.calculateError()));
        }
        this.sampleCountField.setText(Integer.toString(p2.getSize()));
        double[][] sensitivity = null;
        if (this.doVarianceEstimation.isSelected()) {
            sensitivity = uniSA.getUncertaintyOfSensitivity();
        } else {
            double[] sA = uniSA.getSensitivity();
            sensitivity = new double[n][3];
            for (int i = 0; i < n; ++i) {
                sensitivity[i][0] = sA[i];
                sensitivity[i][1] = sA[i];
                sensitivity[i][2] = sA[i];
            }
        }
        for (int i = 0; i < n; ++i) {
            data[0][i] = sensitivity[i][0];
            data[1][i] = sensitivity[i][1] - sensitivity[i][0];
            data[2][i] = sensitivity[i][2] - sensitivity[i][1];
            categoryName[i] = xData[i].getName();
            System.out.println("Sensitivity for:\t" + xData[i].getName() + "\t" + data[0][i]);
            System.out.println("Variance for:\t" + xData[i].getName() + "\t" + data[1][i]);
        }
        this.dataset1 = DatasetUtilities.createCategoryDataset((Comparable[])new String[]{"Sensitivity (low)", "Sensitivity (mean)", "Sensitivity (high)"}, (Comparable[])categoryName, (double[][])data);
        ((CategoryPlot)this.chart.getPlot()).setDataset(0, this.dataset1);
        ((CategoryPlot)this.chart.getPlot()).getRenderer().setSeriesPaint(0, (Paint)new Color(0, 255, 0));
        ((CategoryPlot)this.chart.getPlot()).getRenderer().setSeriesPaint(1, (Paint)new Color(255, 50, 50));
        ((CategoryPlot)this.chart.getPlot()).getRenderer().setSeriesPaint(2, (Paint)new Color(255, 0, 0));
    }
}

