/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import Jama.Matrix;
import jams.JAMS;
import jams.data.Attribute;
import jams.gui.WorkerDlg;
import jams.gui.input.CalendarInput;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIState;
import jams.math.distributions.CDF_Normal;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Measurement;
import optas.data.TimeSerie;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.MCAT5Plot;
import optas.regression.GaussianProcessRegression;
import optas.regression.gaussian.HyperParameter;
import optas.regression.gaussian.cov.CovarianceFunction;
import optas.regression.gaussian.mean.MeanFunction;
import optas.regression.likelihood.LikelihoodFunction;
import optas.tools.PatchedChartPanel;
import optas.tools.Tools;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GPOutputUncertainty
extends MCAT5Plot {
    double beta = 0.1;
    int L = 0;
    TreeSet<Double> ys = new TreeSet();
    ArrayList<Double> ys_array = new ArrayList();
    Measurement sim = null;
    XYPlot hydrograph = new XYPlot();
    PatchedChartPanel chartPanel1 = null;
    JPanel informationPanel = new JPanel();
    JPanel mainPanel = null;
    JComboBox covMethods = new JComboBox<CovarianceFunction>(CovarianceFunction.getCovFunctions());
    JComboBox meanMethods = new JComboBox<MeanFunction>(MeanFunction.getMeanFunctions());
    JComboBox likMethods = new JComboBox<LikelihoodFunction>(LikelihoodFunction.getLikelihoodFunctions());
    JTextField normalizationParameterField = new JTextField(5);
    JTextField[] covParameter = null;
    JTextField[] meanParameter = null;
    JTextField[] likParameter = null;
    JTextField betaParameter = new JTextField(5);
    JLabel processInformation = new JLabel();
    CalendarInput trainStartDate = new CalendarInput();
    CalendarInput trainEndDate = new CalendarInput();
    JButton optimizeParameters = new JButton("Optimize Hyperparameter");
    JButton calcRegression = new JButton("Calculate Regression");
    JTable tsTable = new JTable(new Object[][]{{Boolean.TRUE, "test"}}, new String[]{"x", "y"});
    GaussianProcessRegression gp = new GaussianProcessRegression();
    double[][] x = null;
    int index = 2123;
    boolean initData = false;

    public GPOutputUncertainty() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"SIMULATED_TIMESERIE"), Measurement.class, 0, 10));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class, 0, 1));
        this.init();
    }

    void setReadyForOptimization(boolean value) {
        this.optimizeParameters.setEnabled(value);
    }

    private void init() {
        JFreeChart chart1 = ChartFactory.createTimeSeriesChart((String)JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"), (String)"time", (String)"discharge", null, (boolean)true, (boolean)true, (boolean)false);
        this.hydrograph = chart1.getXYPlot();
        chart1.getPlot().setBackgroundPaint((Paint)Color.white);
        chart1.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        XYDifferenceRenderer renderer_uncert = new XYDifferenceRenderer((Paint)Color.LIGHT_GRAY, (Paint)Color.LIGHT_GRAY, false);
        XYLineAndShapeRenderer renderer_obs = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer renderer_sim = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer renderer_gp = new XYLineAndShapeRenderer();
        renderer_uncert.setBaseFillPaint((Paint)Color.LIGHT_GRAY);
        renderer_uncert.setPaint((Paint)Color.BLACK);
        renderer_obs.setBaseLinesVisible(true);
        renderer_obs.setBaseShapesVisible(false);
        renderer_obs.setOutlinePaint((Paint)Color.BLUE);
        renderer_obs.setPaint((Paint)Color.BLUE);
        renderer_obs.setStroke((Stroke)new BasicStroke(2.0f));
        renderer_sim.setBaseLinesVisible(true);
        renderer_sim.setBaseShapesVisible(false);
        renderer_sim.setOutlinePaint((Paint)Color.RED);
        renderer_sim.setPaint((Paint)Color.RED);
        renderer_sim.setStroke((Stroke)new BasicStroke(0.25f));
        renderer_gp.setBaseLinesVisible(true);
        renderer_gp.setBaseShapesVisible(false);
        renderer_gp.setOutlinePaint((Paint)Color.ORANGE);
        renderer_gp.setPaint((Paint)Color.ORANGE);
        renderer_gp.setStroke((Stroke)new BasicStroke(1.0f));
        this.hydrograph.setRenderer(3, (XYItemRenderer)renderer_uncert);
        this.hydrograph.setRenderer(0, (XYItemRenderer)renderer_obs);
        this.hydrograph.setRenderer(1, (XYItemRenderer)renderer_sim);
        this.hydrograph.setRenderer(2, (XYItemRenderer)renderer_gp);
        this.hydrograph.getDomainAxis().setLabel(JAMS.i18n((String)"TIME"));
        DateAxis axis = (DateAxis)this.hydrograph.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        this.hydrograph.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        this.mainPanel = new JPanel(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        JPanel configurationPanel = new JPanel();
        configurationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "GP - Configuration"));
        GroupLayout confPanelLayout = new GroupLayout(configurationPanel);
        configurationPanel.setLayout(confPanelLayout);
        JLabel covMethodLabel = new JLabel("covariance method:");
        JLabel meanMethodLabel = new JLabel("mean method:");
        JLabel likelihoodMethodLabel = new JLabel("likelihood method:");
        JLabel betaParameterLabel = new JLabel("beta");
        this.trainStartDate.setBorder((Border)BorderFactory.createTitledBorder("Training Start"));
        this.trainEndDate.setBorder((Border)BorderFactory.createTitledBorder("Training End"));
        confPanelLayout.setHorizontalGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(confPanelLayout.createSequentialGroup().addComponent(covMethodLabel).addGap(5).addComponent(this.covMethods, 100, 150, 200)).addGroup(confPanelLayout.createSequentialGroup().addComponent(meanMethodLabel).addGap(5).addComponent(this.meanMethods, 100, 150, 200)).addGroup(confPanelLayout.createSequentialGroup().addComponent(likelihoodMethodLabel).addGap(5).addComponent(this.likMethods, 100, 150, 200)).addGroup(confPanelLayout.createSequentialGroup().addComponent(betaParameterLabel).addGap(5).addComponent(this.betaParameter, 100, 150, 200)).addGroup(confPanelLayout.createSequentialGroup().addComponent((Component)this.trainStartDate, 200, 275, 350)).addGroup(confPanelLayout.createSequentialGroup().addComponent((Component)this.trainEndDate, 200, 275, 350)));
        confPanelLayout.setVerticalGroup(confPanelLayout.createSequentialGroup().addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(covMethodLabel).addComponent(this.covMethods, 25, 30, 35)).addGap(5, 10, 15).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(meanMethodLabel).addComponent(this.meanMethods, 25, 30, 35)).addGap(5, 10, 15).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(likelihoodMethodLabel).addComponent(this.likMethods, 25, 30, 35)).addGap(5, 10, 15).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(betaParameterLabel).addGap(5).addComponent(this.betaParameter, 25, 30, 35)).addGap(5, 10, 15).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.trainStartDate, 60, 70, 80)).addGap(5, 10, 15).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.trainEndDate, 60, 70, 80)));
        JScrollPane scrollPane = new JScrollPane(this.tsTable);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Timeseries"));
        JScrollPane infoPanelScrollPane = new JScrollPane(this.informationPanel);
        infoPanelScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "GP - Information"));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)((Object)this.chartPanel1)).addGroup(layout.createSequentialGroup().addComponent(configurationPanel).addComponent(infoPanelScrollPane, 550, 550, 600).addComponent(scrollPane, 100, 150, 250)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.chartPanel1)).addGroup(layout.createParallelGroup().addComponent(configurationPanel, 150, 200, 400).addComponent(infoPanelScrollPane, 150, 200, 400).addComponent(scrollPane, 150, 200, 400)));
        this.covMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPOutputUncertainty.this.gp.setCovFunction((CovarianceFunction)GPOutputUncertainty.this.covMethods.getSelectedItem());
                GPOutputUncertainty.this.updateInfoPanel();
            }
        });
        this.meanMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPOutputUncertainty.this.gp.setMeanFunction((MeanFunction)GPOutputUncertainty.this.meanMethods.getSelectedItem());
                GPOutputUncertainty.this.updateInfoPanel();
            }
        });
        this.likMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPOutputUncertainty.this.gp.setLikelihoodFunction((LikelihoodFunction)GPOutputUncertainty.this.likMethods.getSelectedItem());
                GPOutputUncertainty.this.updateInfoPanel();
            }
        });
        this.updateInfoPanel();
        this.setReadyForOptimization(false);
        this.calcRegression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPOutputUncertainty.this.redraw();
            }
        });
        this.optimizeParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkerDlg progress = new WorkerDlg(GUIState.getMainWindow(), "Updating plot");
                progress.setInderminate(true);
                progress.setTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int i;
                            GPOutputUncertainty.this.gp.optimizeHyperParameters();
                            HyperParameter hyp = GPOutputUncertainty.this.gp.getHyperParameter();
                            for (i = 0; i < hyp.mean.length; ++i) {
                                GPOutputUncertainty.this.meanParameter[i].setText(Double.toString(hyp.mean[i]));
                            }
                            for (i = 0; i < hyp.cov.length; ++i) {
                                GPOutputUncertainty.this.covParameter[i].setText(Double.toString(hyp.cov[i]));
                            }
                            for (i = 0; i < hyp.lik.length; ++i) {
                                GPOutputUncertainty.this.likParameter[i].setText(Double.toString(hyp.lik[i]));
                            }
                            GPOutputUncertainty.this.redraw();
                        }
                        catch (Exception e) {
                            System.out.println(e.toString());
                            e.printStackTrace();
                        }
                    }
                });
                progress.execute();
            }
        });
        ValueChangeListener trainPeriodChangeListener = new ValueChangeListener(){

            public void valueChanged() {
                GPOutputUncertainty.this.hydrograph.clearDomainMarkers();
                Attribute.Calendar startDate = GPOutputUncertainty.this.trainStartDate.getCalendarValue();
                Attribute.Calendar endDate = GPOutputUncertainty.this.trainEndDate.getCalendarValue();
                if (startDate == null || endDate == null) {
                    return;
                }
                IntervalMarker marker = new IntervalMarker((double)startDate.getTimeInMillis(), (double)endDate.getTimeInMillis());
                marker.setPaint((Paint)Color.GREEN);
                marker.setAlpha(0.2f);
                GPOutputUncertainty.this.hydrograph.addDomainMarker((Marker)marker);
            }
        };
        this.trainStartDate.addValueChangeListener(trainPeriodChangeListener);
        this.trainEndDate.addValueChangeListener(trainPeriodChangeListener);
        this.redraw();
        if (this.hydrograph.getRangeAxis() != null) {
            this.hydrograph.getRangeAxis().setAutoRange(true);
        }
        if (this.hydrograph.getDomainAxis() != null) {
            this.hydrograph.getDomainAxis().setAutoRange(true);
        }
    }

    private void updateInfoPanel() {
        this.informationPanel.removeAll();
        JPanel covParameterPanel = new JPanel();
        covParameterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "cov. Parameter"));
        JPanel meanParameterPanel = new JPanel();
        meanParameterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "mean. Parameter"));
        JPanel likParameterPanel = new JPanel();
        likParameterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "lik. Parameter"));
        String oldText = "";
        if (this.processInformation != null) {
            oldText = this.processInformation.getText();
        }
        this.processInformation = new JLabel(oldText);
        this.processInformation.setBorder(BorderFactory.createTitledBorder("Information"));
        GroupLayout infoPanelLayout = new GroupLayout(this.informationPanel);
        this.informationPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(infoPanelLayout.createSequentialGroup().addGap(5, 10, 15).addComponent(this.optimizeParameters).addComponent(this.calcRegression)).addGroup(infoPanelLayout.createSequentialGroup().addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(covParameterPanel).addComponent(meanParameterPanel).addComponent(likParameterPanel)).addComponent(this.processInformation)));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createSequentialGroup().addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.optimizeParameters).addComponent(this.calcRegression)).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(infoPanelLayout.createSequentialGroup().addComponent(covParameterPanel).addComponent(meanParameterPanel).addComponent(likParameterPanel)).addComponent(this.processInformation)));
        HyperParameter hyp = this.gp.getHyperParameter();
        if (hyp == null) {
            return;
        }
        this.covParameter = new JTextField[hyp.cov.length];
        GroupLayout covParameterPanelLayout = new GroupLayout(covParameterPanel);
        covParameterPanel.setLayout(covParameterPanelLayout);
        GroupLayout.ParallelGroup horzGroup = covParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup vertGroup = covParameterPanelLayout.createSequentialGroup();
        for (int i = 0; i < hyp.cov.length; ++i) {
            this.covParameter[i] = new JTextField(15);
            this.covParameter[i].setText(Double.toString(hyp.cov[i]));
            JLabel covParameterLabel = new JLabel("cov_p_" + i);
            vertGroup.addGroup(covParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(covParameterLabel).addComponent(this.covParameter[i], 15, 20, 25));
            horzGroup.addGroup(covParameterPanelLayout.createSequentialGroup().addComponent(covParameterLabel, 100, 100, 100).addGap(5).addComponent(this.covParameter[i], 100, 150, 200));
        }
        covParameterPanelLayout.setHorizontalGroup(horzGroup);
        covParameterPanelLayout.setVerticalGroup(vertGroup);
        this.meanParameter = new JTextField[hyp.mean.length];
        GroupLayout meanParameterPanelLayout = new GroupLayout(meanParameterPanel);
        meanParameterPanel.setLayout(meanParameterPanelLayout);
        horzGroup = meanParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        vertGroup = meanParameterPanelLayout.createSequentialGroup();
        for (int i = 0; i < hyp.mean.length; ++i) {
            this.meanParameter[i] = new JTextField(15);
            this.meanParameter[i].setText(Double.toString(hyp.mean[i]));
            JLabel meanParameterLabel = new JLabel("mean_p_" + i);
            vertGroup.addGroup(meanParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(meanParameterLabel).addComponent(this.meanParameter[i], 15, 20, 25));
            horzGroup.addGroup(meanParameterPanelLayout.createSequentialGroup().addComponent(meanParameterLabel, 100, 100, 100).addGap(5).addComponent(this.meanParameter[i], 100, 150, 200));
        }
        meanParameterPanelLayout.setHorizontalGroup(horzGroup);
        meanParameterPanelLayout.setVerticalGroup(vertGroup);
        this.likParameter = new JTextField[hyp.lik.length];
        GroupLayout likParameterPanelLayout = new GroupLayout(likParameterPanel);
        likParameterPanel.setLayout(likParameterPanelLayout);
        horzGroup = likParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        vertGroup = likParameterPanelLayout.createSequentialGroup();
        for (int i = 0; i < hyp.lik.length; ++i) {
            this.likParameter[i] = new JTextField(15);
            this.likParameter[i].setText(Double.toString(hyp.lik[i]));
            JLabel likParameterLabel = new JLabel("lik_p_" + i);
            vertGroup.addGroup(likParameterPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(likParameterLabel).addComponent(this.likParameter[i], 15, 20, 25));
            horzGroup.addGroup(likParameterPanelLayout.createSequentialGroup().addComponent(likParameterLabel, 100, 100, 100).addGap(5).addComponent(this.likParameter[i], 100, 150, 200));
        }
        likParameterPanelLayout.setHorizontalGroup(horzGroup);
        likParameterPanelLayout.setVerticalGroup(vertGroup);
    }

    private double calcE2(double[] sim, double[] obs) {
        double mean_obs = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            mean_obs += obs[i];
        }
        mean_obs /= (double)obs.length;
        double num = 0.0;
        double denum = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            num += (sim[i] - obs[i]) * (sim[i] - obs[i]);
            denum += (obs[i] - mean_obs) * (obs[i] - mean_obs);
        }
        return 1.0 - num / denum;
    }

    private String provideBasicInformation(double nlZ, TimeSerie ts_obs, TimeSerie ts_sim, TimeSerie ts_lb, TimeSerie ts_ub, TimeSerie ts_exp, int trainSamples, int testSamples) {
        String htmlFile = "<html><body>%1</body></html>";
        String innerText = "";
        double[] obs = new double[ts_obs.getTimesteps()];
        double[] sim = new double[ts_sim.getTimesteps()];
        double[] exp = new double[ts_sim.getTimesteps()];
        for (int i = 0; i < ts_obs.getTimesteps(); ++i) {
            obs[i] = ts_obs.getValue(i);
            sim[i] = ts_sim.getValue(i);
            exp[i] = ts_exp.getValue(i);
        }
        double e2 = this.calcE2(obs, sim);
        double e2_gp = this.calcE2(obs, exp);
        double mean_uncert = 0.0;
        double mean_uncert_pos = 0.0;
        double mean_uncert_neg = 0.0;
        double hit_ratio = 0.0;
        double mean_obs = 0.0;
        for (int i = 0; i < obs.length; ++i) {
            mean_uncert += ts_ub.getValue(i) - ts_lb.getValue(i);
            mean_obs += obs[i];
            mean_uncert_pos += ts_ub.getValue(i) - sim[i];
            mean_uncert_neg += -(ts_lb.getValue(i) - sim[i]);
            if (!(obs[i] >= ts_lb.getValue(i)) || !(obs[i] <= ts_ub.getValue(i))) continue;
            hit_ratio += 1.0;
        }
        mean_uncert /= (double)obs.length;
        mean_uncert_pos /= (double)obs.length;
        mean_uncert_neg /= (double)obs.length;
        hit_ratio /= (double)obs.length;
        DecimalFormat df = new DecimalFormat("###.##");
        innerText = innerText + "training samples: " + df.format(trainSamples) + "<br>";
        innerText = innerText + "test samples: " + df.format(testSamples - trainSamples) + "<br>";
        innerText = innerText + "marginal liklihood: " + df.format(nlZ) + "<br>";
        innerText = innerText + "mean uncertainty: " + df.format(mean_uncert) + " ( " + df.format(100.0 * mean_uncert / (mean_obs /= (double)obs.length)) + "% )<br>";
        innerText = innerText + "mean uncertainty (+): " + df.format(mean_uncert_pos) + " ( " + df.format(100.0 * mean_uncert_pos / mean_obs) + "% )<br>";
        innerText = innerText + "mean uncertainty (-): " + df.format(mean_uncert_neg) + " ( " + df.format(100.0 * mean_uncert_neg / mean_obs) + "% )<br>";
        innerText = innerText + "hit ratio: " + df.format(hit_ratio) + "<br>";
        innerText = innerText + "simulation quality (NSE): " + df.format(e2) + "<br>";
        innerText = innerText + "regression quality (NSE): " + df.format(e2_gp) + "<br>";
        htmlFile = htmlFile.replaceAll("%1", innerText);
        return htmlFile;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        int i2;
        if (!this.isRequestFulfilled()) {
            return;
        }
        Set<String> tsSet = this.getDataSource().getDatasets(Measurement.class);
        TimeSerie[] ts = new Measurement[tsSet.size()];
        int counter = 0;
        for (String name : tsSet) {
            ts[counter++] = (Measurement)this.getDataSource().getDataSet(name);
        }
        if (!this.initData) {
            this.tsTable.setModel(new TimeSeriesTableModel(ts));
            this.tsTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                }
            });
            this.initData = true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        Measurement obs = (Measurement)p[1].get(0);
        this.sim = (Measurement)p[0].get(0);
        int T = obs.getTimesteps();
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.tsTable.getModel().getRowCount(); ++i3) {
            if (!((Boolean)this.tsTable.getModel().getValueAt(i3, 0)).booleanValue()) continue;
            rows.add(i3);
        }
        int n = rows.size();
        for (int i4 = 0; i4 < this.tsTable.getModel().getRowCount(); ++i4) {
            if (this.tsTable.getModel().getValueAt(i4, 1).toString().compareTo(this.sim.toString()) != 0 || this.tsTable.getModel().getValueAt(i4, 0) != Boolean.FALSE) continue;
            this.tsTable.getModel().setValueAt(Boolean.TRUE, i4, 0);
            return;
        }
        Attribute.Calendar startDate = this.trainStartDate.getCalendarValue();
        Attribute.Calendar endDate = this.trainEndDate.getCalendarValue();
        if (startDate == null) {
            this.trainStartDate.setDate(this.sim.getTime(0));
            this.trainStartDate.setTime(this.sim.getTime(0));
            startDate = this.trainStartDate.getCalendarValue();
        }
        if (endDate == null) {
            this.trainEndDate.setDate(this.sim.getTime(this.sim.getTimesteps() / 2));
            this.trainEndDate.setTime(this.sim.getTime(this.sim.getTimesteps() / 2));
            endDate = this.trainEndDate.getCalendarValue();
        }
        this.hydrograph.clearDomainMarkers();
        IntervalMarker marker = new IntervalMarker((double)startDate.getTimeInMillis(), (double)endDate.getTimeInMillis());
        marker.setPaint((Paint)Color.GREEN);
        marker.setAlpha(0.2f);
        this.hydrograph.addDomainMarker((Marker)marker);
        int trainStart = 0;
        int trainEnd = 0;
        while (trainStart < T && startDate.getTimeInMillis() > obs.getTime(trainStart++).getTime()) {
        }
        while (trainEnd < T && endDate.getTimeInMillis() > obs.getTime(trainEnd++).getTime()) {
        }
        int D = trainEnd - trainStart;
        this.x = new double[D][n];
        for (int i5 = 0; i5 < n; ++i5) {
            int row = (Integer)rows.get(i5);
            TimeSerie input_ts = (TimeSerie)this.tsTable.getModel().getValueAt(row, 1);
            for (int j = trainStart; j < trainEnd; ++j) {
                this.x[j - trainStart][i5] = input_ts.getValue(j);
            }
        }
        double[] y = new double[D];
        double[] simArray = new double[D];
        for (int i6 = trainStart; i6 < trainEnd; ++i6) {
            y[i6 - trainStart] = -(obs.getValue(i6) - this.sim.getValue(i6));
            simArray[i6 - trainStart] = this.sim.getValue(i6);
        }
        this.beta = Tools.readField(this.betaParameter, this.beta);
        NQTTransformation nqt = new NQTTransformation(y, simArray);
        double[] Y = nqt.transform(y, simArray);
        LikelihoodFunction lik = (LikelihoodFunction)this.likMethods.getSelectedItem();
        MeanFunction mean = (MeanFunction)this.meanMethods.getSelectedItem();
        CovarianceFunction cov = (CovarianceFunction)this.covMethods.getSelectedItem();
        this.gp.setCovFunction(cov);
        this.gp.setLikelihoodFunction(lik);
        this.gp.setMeanFunction(mean);
        this.gp.setTrainingDataset(this.x, Y);
        HyperParameter hyp = this.gp.getHyperParameter();
        if (this.covParameter != null) {
            for (i2 = 0; i2 < this.covParameter.length; ++i2) {
                hyp.cov[i2] = Tools.readField(this.covParameter[i2], hyp.cov[i2]);
            }
        }
        if (this.meanParameter != null) {
            for (i2 = 0; i2 < this.meanParameter.length; ++i2) {
                hyp.mean[i2] = Tools.readField(this.meanParameter[i2], hyp.mean[i2]);
            }
        }
        if (this.likParameter != null) {
            for (i2 = 0; i2 < this.likParameter.length; ++i2) {
                hyp.lik[i2] = Tools.readField(this.likParameter[i2], hyp.lik[i2]);
            }
        }
        double[][] xs = new double[T][n];
        for (int i7 = 0; i7 < rows.size(); ++i7) {
            int row = (Integer)rows.get(i7);
            TimeSerie input_ts = (TimeSerie)this.tsTable.getModel().getValueAt(row, 1);
            for (int j = 0; j < T; ++j) {
                xs[j][i7] = input_ts.getValue(j);
            }
        }
        Matrix[] result = this.gp.inference(xs);
        int TEST_LIMIT = 2000;
        double[][] xs_test = new double[TEST_LIMIT][1];
        for (int i8 = 0; i8 < TEST_LIMIT; ++i8) {
            xs_test[i8][0] = i8;
        }
        Matrix[] result2 = this.gp.inference(xs_test);
        System.out.println("Lower conf\tUpper conf\texp");
        double[] upperBound2 = new double[TEST_LIMIT];
        double[] lowerBound2 = new double[TEST_LIMIT];
        double[] expected2 = new double[TEST_LIMIT];
        for (i = 0; i < TEST_LIMIT; ++i) {
            upperBound2[i] = result2[0].get(0, i) + 2.0 * Math.sqrt(result2[1].get(0, i));
            lowerBound2[i] = result2[0].get(0, i) - 2.0 * Math.sqrt(result2[1].get(0, i));
            expected2[i] = result2[0].get(0, i);
        }
        upperBound2 = nqt.inv_transform(upperBound2);
        lowerBound2 = nqt.inv_transform(lowerBound2);
        expected2 = nqt.inv_transform(expected2);
        for (i = 0; i < TEST_LIMIT; ++i) {
            System.out.println(i + "\t" + Math.max((double)i - ((double)i + this.beta) * lowerBound2[i], 0.0) + "\t" + Math.max((double)i - ((double)i + this.beta) * upperBound2[i], 0.0) + "\t" + Math.max((double)i - ((double)i + this.beta) * expected2[i], 0.0) + "\t");
        }
        TimeSeries dataset1 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"LOWER_CONFIDENCE_BOUND")));
        TimeSeries dataset2 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"UPPER_CONFIDENCE_BOUND")));
        TimeSeries dataset3 = new TimeSeries((Comparable)((Object)obs.name));
        TimeSeries dataset4 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"SIM")));
        TimeSeries dataset5 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MEDIAN")));
        double[] upperBound = new double[T];
        double[] lowerBound = new double[T];
        double[] expected = new double[T];
        for (int i9 = 0; i9 < T; ++i9) {
            upperBound[i9] = result[0].get(0, i9) + 2.0 * Math.sqrt(result[1].get(0, i9));
            lowerBound[i9] = result[0].get(0, i9) - 2.0 * Math.sqrt(result[1].get(0, i9));
            expected[i9] = result[0].get(0, i9);
        }
        upperBound = nqt.inv_transform(upperBound);
        lowerBound = nqt.inv_transform(lowerBound);
        expected = nqt.inv_transform(expected);
        TimeSerie ts_lb = null;
        TimeSerie ts_ub = null;
        TimeSerie ts_exp = null;
        try {
            double[] lb = new double[T];
            double[] ub = new double[T];
            double[] exp = new double[T];
            for (int i10 = 0; i10 < T; ++i10) {
                lb[i10] = Math.max(this.sim.getValue(i10) - (this.sim.getValue(i10) + this.beta) * lowerBound[i10], 0.0);
                ub[i10] = Math.max(this.sim.getValue(i10) - (this.sim.getValue(i10) + this.beta) * upperBound[i10], 0.0);
                exp[i10] = Math.max(this.sim.getValue(i10) - (this.sim.getValue(i10) + this.beta) * expected[i10], 0.0);
            }
            ts_lb = new TimeSerie(ub, obs.getTimeDomain(), "lb", null);
            ts_ub = new TimeSerie(lb, obs.getTimeDomain(), "ub", null);
            ts_exp = new TimeSerie(exp, obs.getTimeDomain(), "exp", null);
        }
        catch (DataSet.MismatchException me) {
            me.printStackTrace();
        }
        String info = this.provideBasicInformation(this.gp.getMarginalLikelihood(), obs, this.sim, ts_lb, ts_ub, ts_exp, this.x.length, xs.length);
        this.processInformation.setText(info);
        this.processInformation.revalidate();
        for (int i11 = 0; i11 < T; ++i11) {
            Day d = new Day(obs.getTime(i11));
            dataset1.add((RegularTimePeriod)d, ts_lb.getValue(i11));
            dataset2.add((RegularTimePeriod)d, ts_ub.getValue(i11));
            dataset3.add((RegularTimePeriod)d, obs.getValue(i11));
            dataset4.add((RegularTimePeriod)d, this.sim.getValue(i11));
            dataset5.add((RegularTimePeriod)d, ts_exp.getValue(i11));
        }
        TimeSeriesCollection obs_runoff = new TimeSeriesCollection();
        obs_runoff.addSeries(dataset3);
        this.hydrograph.setDataset(0, (XYDataset)obs_runoff);
        TimeSeriesCollection interval = new TimeSeriesCollection();
        interval.addSeries(dataset1);
        interval.addSeries(dataset2);
        TimeSeriesCollection simCollection = new TimeSeriesCollection();
        simCollection.addSeries(dataset4);
        this.hydrograph.setDataset(1, (XYDataset)simCollection);
        this.hydrograph.setDataset(3, (XYDataset)interval);
        TimeSeriesCollection median_ensemble = new TimeSeriesCollection();
        median_ensemble.addSeries(dataset5);
        this.hydrograph.setDataset(2, (XYDataset)median_ensemble);
        this.updateInfoPanel();
        this.setReadyForOptimization(true);
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    public JPanel getPanel1() {
        return this.mainPanel;
    }

    public static void main(String[] args) {
        DataCollection dc = DataCollection.createFromFile(new File("E:/Vortraege und Paper/2013-10-17 KOS/Hymod/output/current/nsga_save2.cdat"));
        try {
            DataRequestPanel d = new DataRequestPanel(new GPOutputUncertainty(), dc);
            JFrame plotWindow = new JFrame("Gaussian Processes Output Uncertainty");
            plotWindow.setDefaultCloseOperation(2);
            plotWindow.setLayout(new BorderLayout());
            plotWindow.setVisible(true);
            plotWindow.setSize(800, 700);
            plotWindow.add((Component)d, "Center");
        }
        catch (MCAT5Plot.NoDataException noDataException) {
            // empty catch block
        }
    }

    class TimeSeriesTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"select", "name"};
        private Object[][] data = null;

        TimeSeriesTableModel(TimeSerie[] ts) {
            this.data = new Object[ts.length][2];
            for (int i = 0; i < ts.length; ++i) {
                this.data[i][0] = Boolean.FALSE;
                this.data[i][1] = ts[i];
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return GPOutputUncertainty.this.sim == null || !this.getValueAt(row, 1).toString().equals(GPOutputUncertainty.this.sim.toString());
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private class NQTTransformation {
        public NQTTransformation(double[] err, double[] sim) {
            GPOutputUncertainty.this.L = err.length;
            double[] y2 = Arrays.copyOf(err, GPOutputUncertainty.this.L);
            GPOutputUncertainty.this.ys = new TreeSet();
            for (int i = 0; i < GPOutputUncertainty.this.L; ++i) {
                y2[i] = err[i] / (sim[i] + Math.exp(GPOutputUncertainty.this.beta));
                GPOutputUncertainty.this.ys.add(y2[i]);
            }
            GPOutputUncertainty.this.ys_array = new ArrayList();
            GPOutputUncertainty.this.ys_array.addAll(GPOutputUncertainty.this.ys);
        }

        private double single_transform(double err, TreeSet<Double> ys) {
            int c2;
            double t2;
            int c1;
            double t1;
            double p;
            int L = ys.size();
            Double ceil = ys.ceiling(err);
            Double floor = ys.floor(err);
            if (ceil == null) {
                ceil = ys.last();
            }
            if (floor == null) {
                floor = ys.first();
            }
            double l = ceil - floor;
            double wp = 1.0 - (ceil - err) / l;
            double wm = 1.0 - wp;
            if (l == 0.0) {
                wp = 1.0;
                wm = 0.0;
            }
            if ((p = wp * (t1 = (double)(c1 = ys.headSet(ceil, true).size()) / (double)(L + 1)) + wm * (t2 = (double)(c2 = ys.headSet(floor, true).size()) / (double)(L + 1))) <= 0.0 || p >= 1.0) {
                System.out.println("Error in NQT");
            }
            double Y = CDF_Normal.xnormi((double)p);
            return Y;
        }

        public double[] transform(double[] y, double[] sim) {
            double[] y2 = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                y2[i] = y[i] / (sim[i] + Math.exp(GPOutputUncertainty.this.beta));
            }
            double[] Y = new double[y.length];
            for (int i = 0; i < GPOutputUncertainty.this.L; ++i) {
                Y[i] = this.single_transform(y2[i], GPOutputUncertainty.this.ys);
            }
            return Y;
        }

        public double[] inv_transform(double[] Y) {
            double[] y = new double[Y.length];
            for (int i = 0; i < Y.length; ++i) {
                double p = CDF_Normal.normp((double)Y[i]);
                double index1 = Math.floor((double)(GPOutputUncertainty.this.L + 1) * p);
                double index2 = Math.ceil((double)(GPOutputUncertainty.this.L + 1) * p);
                double w1 = 1.0 - ((double)(GPOutputUncertainty.this.L + 1) * p - index1);
                double w2 = 1.0 - w1;
                if (index1 < 0.0) {
                    index1 = 0.0;
                }
                if (index2 >= (double)GPOutputUncertainty.this.L) {
                    index2 = GPOutputUncertainty.this.L - 1;
                }
                if (index2 < 0.0) {
                    index2 = 0.0;
                }
                if (index1 >= (double)GPOutputUncertainty.this.L) {
                    index1 = GPOutputUncertainty.this.L - 1;
                }
                y[i] = w1 * GPOutputUncertainty.this.ys_array.get((int)index1) + w2 * GPOutputUncertainty.this.ys_array.get((int)index2);
            }
            return y;
        }
    }
}

