/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class BestPredictionPlot
extends MCAT5Plot {
    XYPlot plot1 = new XYPlot();
    PatchedChartPanel chartPanel1 = null;

    public BestPredictionPlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class, 1, 10));
        this.init();
    }

    private void init() {
        this.plot1.setDomainAxis((ValueAxis)new DateAxis(JAMS.i18n((String)"TIME")));
        this.plot1.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
        JFreeChart chart1 = new JFreeChart((Plot)this.plot1);
        chart1.setTitle(JAMS.i18n((String)"BEST_PREDICTION_PLOT"));
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        this.chartPanel1.getChart().getPlot().setBackgroundPaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int i = 0; i < 7; ++i) {
            renderer.setSeriesLinesVisible(i, true);
            renderer.setSeriesShapesVisible(i, false);
        }
        renderer.setSeriesPaint(0, (Paint)Color.BLACK);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesPaint(2, (Paint)Color.RED);
        renderer.setSeriesPaint(3, (Paint)Color.YELLOW);
        renderer.setSeriesPaint(4, (Paint)Color.CYAN);
        renderer.setSeriesPaint(5, (Paint)Color.GREEN);
        renderer.setSeriesPaint(6, (Paint)Color.PINK);
        renderer.setStroke((Stroke)new BasicStroke(1.0f));
        this.plot1.setRenderer((XYItemRenderer)renderer);
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        TimeSerieEnsemble ts = (TimeSerieEnsemble)p[0].get(0);
        Measurement obs = (Measurement)p[1].get(0);
        ArrayList<DataSet> eff = p[2];
        long time_length = obs.getTimeDomain().getNumberOfTimesteps();
        TimeSeries[] bestTSDataset = new TimeSeries[eff.size() + 1];
        for (int i = 0; i < eff.size(); ++i) {
            EfficiencyEnsemble effEnsemble = (EfficiencyEnsemble)eff.get(i);
            int argbest = effEnsemble.findArgBest();
            bestTSDataset[i] = new TimeSeries((Comparable)((Object)("opt-" + eff.get((int)i).name)));
            int j = 0;
            while ((long)j < time_length) {
                Day d = new Day(obs.getTime(j));
                bestTSDataset[i].add((RegularTimePeriod)d, ts.get(j, argbest));
                ++j;
            }
            String tooltip = "<html><body>";
            for (int j2 = 0; j2 < eff.size(); ++j2) {
                EfficiencyEnsemble effEnsemble2 = (EfficiencyEnsemble)eff.get(j2);
                tooltip = tooltip + effEnsemble2.getName() + ":" + String.format("%.2f", effEnsemble2.getValue(argbest));
                if (j2 >= eff.size() - 1) continue;
                tooltip = tooltip + "<br>";
            }
            tooltip = tooltip + "</body></html>";
            this.plot1.getRenderer().setSeriesToolTipGenerator(i, (XYToolTipGenerator)new CustomXYToolTipGenerator(i, tooltip));
        }
        bestTSDataset[eff.size()] = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"OBSERVED")));
        int j = 0;
        while ((long)j < time_length) {
            Day d = new Day(obs.getTime(j));
            bestTSDataset[eff.size()].add((RegularTimePeriod)d, obs.getValue(j));
            ++j;
        }
        TimeSeriesCollection bestSeries = new TimeSeriesCollection();
        for (TimeSeries bestTSDataset1 : bestTSDataset) {
            bestSeries.addSeries(bestTSDataset1);
        }
        this.plot1.setDataset((XYDataset)bestSeries);
        if (this.plot1.getRangeAxis() != null) {
            this.plot1.getRangeAxis().setAutoRange(true);
        }
        if (this.plot1.getDomainAxis() != null) {
            this.plot1.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel1;
    }

    private class CustomXYToolTipGenerator
    implements XYToolTipGenerator {
        int index = 0;
        String tooltip = "";

        public CustomXYToolTipGenerator(int index, String tooltip) {
            this.tooltip = tooltip;
            this.index = index;
        }

        public String generateToolTip(XYDataset xyd, int i, int i1) {
            return this.tooltip;
        }
    }
}

