/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import optas.efficiencies.CorrelationError;
import optas.efficiencies.EfficienciesCalculator;
import optas.efficiencies.EfficiencyCalculator;
import optas.efficiencies.KGE;
import optas.efficiencies.KGEprime;
import optas.efficiencies.KGEprimeAllPar;
import optas.efficiencies.KGEprime_weighted;
import optas.efficiencies.LogLikelihood;
import optas.efficiencies.LogarithmicNashSutcliffe;
import optas.efficiencies.NashSutcliffe;
import optas.efficiencies.VolumeError;
import optas.efficiencies.WeightedEfficiencyCalculator;

@JAMSComponentDescription(title="UniversalEfficiencyCalculator", author="Christian Fischer, Nico Hachgenei", description="Calculates various efficiency measures", version="1.0_2", date="2024-06-24")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2018-11-01", comment="Increased number of decimal digits in output."), @VersionComments.Entry(version="1.0_2", date="2024-06-24", comment="added additional efficiency criteria (KGE', weighted KGE', 3 parts of KGE'), added weights for the 3 parts")})
public class UniversalEfficiencyCalculatorSerialized
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="names of measured attribute(s)", defaultValue="")
    public Attribute.String[] measurementAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="measured attribute(s)")
    public Attribute.Object[] measurement;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="names of simulated attribute(s)", defaultValue="")
    public Attribute.String[] simulationAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="simulated attribute(s)")
    public Attribute.Object[] simulation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Nash-Sutcliffe-Efficiency (power=1)", defaultValue="0")
    public Attribute.Double[] e1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Nash-Sutcliffe-Efficiency (power=2)", defaultValue="0")
    public Attribute.Double[] e2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: log. Nash-Sutcliffe-Efficiency (power=1)", defaultValue="0")
    public Attribute.Double[] le1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: log. Nash-Sutcliffe-Efficiency (power=2)", defaultValue="0")
    public Attribute.Double[] le2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Absolute Volume Error", defaultValue="0")
    public Attribute.Double[] ave;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: R\u00b2", defaultValue="0")
    public Attribute.Double[] r2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Relative Bias", defaultValue="0")
    public Attribute.Double[] bias;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized e1", defaultValue="0")
    public Attribute.Double[] e1_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized e2", defaultValue="0")
    public Attribute.Double[] e2_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized le1", defaultValue="0")
    public Attribute.Double[] le1_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized le2", defaultValue="0")
    public Attribute.Double[] le2_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized ave", defaultValue="0")
    public Attribute.Double[] ave_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized r2", defaultValue="0")
    public Attribute.Double[] r2_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized bias", defaultValue="0")
    public Attribute.Double[] bias_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: log. Maximumn Likelihood Efficiency", defaultValue="0")
    public Attribute.Double[] log_likelihood;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized log_likelihood", defaultValue="0")
    public Attribute.Double[] log_likelihood_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Kling-Gupta-Efficiency", defaultValue="0")
    public Attribute.Double[] kge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized kge", defaultValue="0")
    public Attribute.Double[] kge_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Kling-Gupta-Efficiency prime: corrected for cross-correlation of alpha (variability term) with beta (bias term)", defaultValue="0")
    public Attribute.Double[] kge_prime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized kge prime", defaultValue="0")
    public Attribute.Double[] kge_prime_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: weighted Kling-Gupta-Efficiency prime: corrected for cross-correlation of alpha (variability term) with beta (bias term) and weighted", defaultValue="0")
    public Attribute.Double[] kge_prime_w;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: Normalized weighted kge prime", defaultValue="0")
    public Attribute.Double[] kge_prime_w_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: r par of Kling-Gupta-Efficiency prime: corrected for cross-correlation of alpha (variability term) with beta (bias term)", defaultValue="0")
    public Attribute.Double[] kge_prime_r;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: gamma par of Kling-Gupta-Efficiency prime: corrected for cross-correlation of alpha (variability term) with beta (bias term)", defaultValue="0")
    public Attribute.Double[] kge_prime_gam;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="efficiency value: beta par of Kling-Gupta-Efficiency prime: corrected for cross-correlation of alpha (variability term) with beta (bias term)", defaultValue="0")
    public Attribute.Double[] kge_prime_bet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="weigth (scale-factor for r parameter in weighted KGE'", defaultValue="1")
    public Attribute.Double r_weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="weigth (scale-factor for gamma parameter in weighted KGE'", defaultValue="1")
    public Attribute.Double gamma_weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="weigth (scale-factor for beta parameter in weighted KGE'", defaultValue="1")
    public Attribute.Double beta_weight;
    public static final int RMSE = 0;
    public static final int NSE1 = 1;
    public static final int NSE2 = 2;
    public static final int LNSE1 = 3;
    public static final int LNSE2 = 4;
    public static final int AVE = 5;
    public static final int R2 = 6;
    public static final int RBIAS = 7;
    public static final int KGE = 8;
    public static final int KGEP = 9;
    public static String[] availableEfficiencies = new String[]{"Root Mean Square Error", "Nash Sutcliffe (e1)", "Nash Sutcliffe (e2)", "log Nash Sutcliffe (le1)", "log Nash Sutcliffe (le2)", "Average Volume Error", "r2", "relative bias", "KGE", "normalized KGE", "KGE prime", "normalized KGE prime", "weighted KGE prime", "normalized weighted KGE prime", "parameters of KGE prime and weighted KGE prime"};
    ArrayList<Double>[] measurementList;
    ArrayList<Double>[] simulationList;
    EfficiencyCalculator calcE1 = new NashSutcliffe(1.0);
    EfficiencyCalculator calcE2 = new NashSutcliffe(2.0);
    EfficiencyCalculator calcLe1 = new LogarithmicNashSutcliffe(1.0);
    EfficiencyCalculator calcLe2 = new LogarithmicNashSutcliffe(2.0);
    EfficiencyCalculator calcAve = new VolumeError(VolumeError.VolumeErrorType.Absolute);
    EfficiencyCalculator calcR2 = new CorrelationError();
    EfficiencyCalculator calcPBias = new VolumeError(VolumeError.VolumeErrorType.Relative);
    EfficiencyCalculator calcLogLikelihood = new LogLikelihood();
    EfficiencyCalculator calcKGE = new KGE();
    EfficiencyCalculator calcKGEprime = new KGEprime();
    WeightedEfficiencyCalculator calcKGEprime_w = new KGEprime_weighted();
    EfficienciesCalculator calcKGEprimeAllPar = new KGEprimeAllPar();
    int m = 0;
    boolean firstIteration = true;
    HashSet<Long> timeStepCache = new HashSet();
    DecimalFormat format = new DecimalFormat("######0.00000");

    public void init() {
        if (this.measurement.length != this.simulation.length) {
            this.getModel().getRuntime().sendHalt("Error: Number of measurement and simulation attributes in " + this.getInstanceName() + " does not fit!");
        }
        this.m = this.measurement.length;
        this.measurementList = new ArrayList[this.m];
        this.simulationList = new ArrayList[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.measurementList[i] = new ArrayList();
            this.simulationList[i] = new ArrayList();
        }
    }

    public void run() {
        for (int i = 0; i < this.m; ++i) {
            this.measurementList[i] = (ArrayList)this.measurement[i].getValue();
            this.simulationList[i] = (ArrayList)this.simulation[i].getValue();
        }
    }

    private String round(double r) {
        if (Double.MAX_VALUE == r) {
            return "[-]";
        }
        if (Double.isInfinite(r) && r > 0.0) {
            return "Infinity";
        }
        if (Double.isNaN(r)) {
            return "NaN";
        }
        if (Double.isInfinite(r) && r < 0.0) {
            return "-Infinity";
        }
        return this.format.format(r);
    }

    private void setObjective(double[] m, double[] s, int k, Attribute.Double[] field, Attribute.Double[] normalized_field, EfficiencyCalculator calc) {
        if (field != null && field.length > k && field[k] != null) {
            if (m.length == 0 || s.length == 0) {
                field[k].setValue(Double.NaN);
            } else {
                field[k].setValue(calc.calc(m, s));
            }
        }
        if (normalized_field != null && normalized_field.length > k && normalized_field[k] != null) {
            if (m.length == 0 || s.length == 0) {
                normalized_field[k].setValue(Double.MAX_VALUE);
            } else {
                double value = calc.calcNormative(m, s);
                if (Double.isNaN(value)) {
                    normalized_field[k].setValue(Double.MAX_VALUE);
                } else {
                    normalized_field[k].setValue(value);
                }
            }
        }
    }

    private void setObjective(double[] m, double[] s, int k, Attribute.Double[] field, Attribute.Double[] normalized_field, WeightedEfficiencyCalculator calc, double[] weights) {
        if (field != null && field.length > k && field[k] != null) {
            if (m.length == 0 || s.length == 0) {
                field[k].setValue(Double.NaN);
            } else {
                field[k].setValue(calc.calc(m, s, weights));
            }
        }
        if (normalized_field != null && normalized_field.length > k && normalized_field[k] != null) {
            if (m.length == 0 || s.length == 0) {
                normalized_field[k].setValue(Double.MAX_VALUE);
            } else {
                double value = calc.calcNormative(m, s, weights);
                if (Double.isNaN(value)) {
                    normalized_field[k].setValue(Double.MAX_VALUE);
                } else {
                    normalized_field[k].setValue(value);
                }
            }
        }
    }

    private void set4Objectives(double[] m, double[] s, int k, Attribute.Double[] field1, Attribute.Double[] field2, Attribute.Double[] field3, Attribute.Double[] field4, Attribute.Double[] normalized_field, EfficienciesCalculator calc) {
        if (field1 != null && field1.length > k && field1[k] != null) {
            if (m.length == 0 || s.length == 0) {
                field1[k].setValue(Double.NaN);
                field2[k].setValue(Double.NaN);
                field3[k].setValue(Double.NaN);
                field4[k].setValue(Double.NaN);
            } else {
                double[] fields = calc.calc(m, s);
                field1[k].setValue(fields[0]);
                field2[k].setValue(fields[1]);
                field3[k].setValue(fields[2]);
                field4[k].setValue(fields[3]);
            }
        }
        if (normalized_field != null && normalized_field.length > k && normalized_field[k] != null) {
            if (m.length == 0 || s.length == 0) {
                normalized_field[k].setValue(Double.MAX_VALUE);
            } else {
                double value = calc.calcNormative(m, s);
                if (Double.isNaN(value)) {
                    normalized_field[k].setValue(Double.MAX_VALUE);
                } else {
                    normalized_field[k].setValue(value);
                }
            }
        }
    }

    public void cleanup() {
        double[] weights = new double[]{this.r_weight.getValue(), this.gamma_weight.getValue(), this.beta_weight.getValue()};
        this.firstIteration = false;
        this.getModel().getRuntime().println("");
        this.getModel().getRuntime().println("************************************************************");
        this.getModel().getRuntime().println("*******UniversalEfficiencyCalculator: " + this.getInstanceName());
        if (this.e1 == null || this.e1.length < this.m) {
            this.e1 = new Attribute.Double[this.m];
        }
        if (this.e2 == null || this.e2.length < this.m) {
            this.e2 = new Attribute.Double[this.m];
        }
        if (this.le1 == null || this.le1.length < this.m) {
            this.le1 = new Attribute.Double[this.m];
        }
        if (this.le2 == null || this.le2.length < this.m) {
            this.le2 = new Attribute.Double[this.m];
        }
        if (this.r2 == null || this.r2.length < this.m) {
            this.r2 = new Attribute.Double[this.m];
        }
        if (this.ave == null || this.ave.length < this.m) {
            this.ave = new Attribute.Double[this.m];
        }
        if (this.bias == null || this.bias.length < this.m) {
            this.bias = new Attribute.Double[this.m];
        }
        if (this.e1_normalized == null || this.e1_normalized.length < this.m) {
            this.e1_normalized = new Attribute.Double[this.m];
        }
        if (this.e2_normalized == null || this.e2_normalized.length < this.m) {
            this.e2_normalized = new Attribute.Double[this.m];
        }
        if (this.le1_normalized == null || this.le1_normalized.length < this.m) {
            this.le1_normalized = new Attribute.Double[this.m];
        }
        if (this.le2_normalized == null || this.le2_normalized.length < this.m) {
            this.le2_normalized = new Attribute.Double[this.m];
        }
        if (this.r2_normalized == null || this.r2_normalized.length < this.m) {
            this.r2_normalized = new Attribute.Double[this.m];
        }
        if (this.ave_normalized == null || this.ave_normalized.length < this.m) {
            this.ave_normalized = new Attribute.Double[this.m];
        }
        if (this.bias_normalized == null || this.bias_normalized.length < this.m) {
            this.bias_normalized = new Attribute.Double[this.m];
        }
        if (this.kge == null || this.kge.length < this.m) {
            this.kge = new Attribute.Double[this.m];
        }
        if (this.kge_normalized == null || this.kge_normalized.length < this.m) {
            this.kge_normalized = new Attribute.Double[this.m];
        }
        if (this.kge_prime == null || this.kge_prime.length < this.m) {
            this.kge_prime = new Attribute.Double[this.m];
        }
        if (this.kge_prime_normalized == null || this.kge_prime_normalized.length < this.m) {
            this.kge_prime_normalized = new Attribute.Double[this.m];
        }
        if (this.kge_prime_w == null || this.kge_prime_w.length < this.m) {
            this.kge_prime_w = new Attribute.Double[this.m];
        }
        if (this.kge_prime_w_normalized == null || this.kge_prime_w_normalized.length < this.m) {
            this.kge_prime_w_normalized = new Attribute.Double[this.m];
        }
        if (this.kge_prime_r == null || this.kge_prime_r.length < this.m) {
            this.kge_prime_r = new Attribute.Double[this.m];
        }
        if (this.kge_prime_gam == null || this.kge_prime_gam.length < this.m) {
            this.kge_prime_gam = new Attribute.Double[this.m];
        }
        if (this.kge_prime_bet == null || this.kge_prime_bet.length < this.m) {
            this.kge_prime_bet = new Attribute.Double[this.m];
        }
        for (int k = 0; k < this.m; ++k) {
            double[] m = new double[this.measurementList[k].size()];
            double[] s = new double[this.simulationList[k].size()];
            for (int i = 0; i < this.measurementList[k].size(); ++i) {
                m[i] = this.measurementList[k].get(i);
                s[i] = this.simulationList[k].get(i);
            }
            if (this.e1[k] == null) {
                this.e1[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.e2[k] == null) {
                this.e2[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.le1[k] == null) {
                this.le1[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.le2[k] == null) {
                this.le2[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.r2[k] == null) {
                this.r2[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.ave[k] == null) {
                this.ave[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.bias[k] == null) {
                this.bias[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge[k] == null) {
                this.kge[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime[k] == null) {
                this.kge_prime[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_r[k] == null) {
                this.kge_prime_r[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_gam[k] == null) {
                this.kge_prime_gam[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_bet[k] == null) {
                this.kge_prime_bet[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_w[k] == null) {
                this.kge_prime_w[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.e1_normalized[k] == null) {
                this.e1_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.e2_normalized[k] == null) {
                this.e2_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.le1_normalized[k] == null) {
                this.le1_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.le2_normalized[k] == null) {
                this.le2_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.r2_normalized[k] == null) {
                this.r2_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.ave_normalized[k] == null) {
                this.ave_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.bias_normalized[k] == null) {
                this.bias_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_normalized[k] == null) {
                this.kge_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_normalized[k] == null) {
                this.kge_prime_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            if (this.kge_prime_w_normalized[k] == null) {
                this.kge_prime_w_normalized[k] = DefaultDataFactory.getDataFactory().createDouble();
            }
            this.setObjective(m, s, k, this.e1, this.e1_normalized, this.calcE1);
            this.setObjective(m, s, k, this.e2, this.e2_normalized, this.calcE2);
            this.setObjective(m, s, k, this.le1, this.le1_normalized, this.calcLe1);
            this.setObjective(m, s, k, this.le2, this.le2_normalized, this.calcLe2);
            this.setObjective(m, s, k, this.ave, this.ave_normalized, this.calcAve);
            this.setObjective(m, s, k, this.r2, this.r2_normalized, this.calcR2);
            this.setObjective(m, s, k, this.bias, this.bias_normalized, this.calcPBias);
            this.setObjective(m, s, k, this.log_likelihood, this.log_likelihood_normalized, this.calcLogLikelihood);
            this.setObjective(m, s, k, this.kge, this.kge_normalized, this.calcKGE);
            this.set4Objectives(m, s, k, this.kge_prime, this.kge_prime_r, this.kge_prime_gam, this.kge_prime_bet, this.kge_prime_normalized, this.calcKGEprimeAllPar);
            this.setObjective(m, s, k, this.kge_prime_w, this.kge_prime_w_normalized, this.calcKGEprime_w, weights);
            this.getModel().getRuntime().println("************************************************************");
            this.getModel().getRuntime().println("*******Measurement: " + this.measurementAttributeName[k]);
            this.getModel().getRuntime().println("*******Simulation : " + this.simulationAttributeName[k]);
            this.getModel().getRuntime().println("*******E1:    " + this.round(this.e1[k].getValue()) + "  (" + this.round(this.e1_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******E2:    " + this.round(this.e2[k].getValue()) + "  (" + this.round(this.e2_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******logE1: " + this.round(this.le1[k].getValue()) + "  (" + this.round(this.le1_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******logE2: " + this.round(this.le2[k].getValue()) + "  (" + this.round(this.le2_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******AVE:   " + this.round(this.ave[k].getValue()) + "  (" + this.round(this.ave_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******R2:    " + this.round(this.r2[k].getValue()) + "  (" + this.round(this.r2_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******Bias:  " + this.round(this.bias[k].getValue()) + "  (" + this.round(this.bias_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******KGE:   " + this.round(this.kge[k].getValue()) + "  (" + this.round(this.kge_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******KGE prime:   " + this.round(this.kge_prime[k].getValue()) + "  (" + this.round(this.kge_prime_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******KGE prime weighted:   " + this.round(this.kge_prime_w[k].getValue()) + "  (" + this.round(this.kge_prime_w_normalized[k].getValue()) + ")");
            this.getModel().getRuntime().println("*******KGE prime r:   " + this.round(this.kge_prime_r[k].getValue()));
            this.getModel().getRuntime().println("*******KGE prime gamma:   " + this.round(this.kge_prime_gam[k].getValue()));
            this.getModel().getRuntime().println("*******KGE prime beta:   " + this.round(this.kge_prime_bet[k].getValue()));
        }
        this.getModel().getRuntime().println("************************************************************");
    }
}

