/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import optas.efficiencies.EfficiencyCalculator;

public class LogarithmicNashSutcliffe
extends EfficiencyCalculator {
    double pow = 2.0;

    public LogarithmicNashSutcliffe() {
    }

    public LogarithmicNashSutcliffe(double pow) {
        this.pow = pow;
    }

    @Override
    public double calc(double[] m, double[] s) {
        int i;
        double rsme = 0.0;
        double var = 0.0;
        double avg = 0.0;
        for (i = 0; i < m.length; ++i) {
            if (!(m[i] > 0.0)) continue;
            avg += Math.log(m[i]);
        }
        avg /= (double)m.length;
        for (i = 0; i < m.length; ++i) {
            if (!(m[i] > 0.0 & s[i] > 0.0)) continue;
            rsme += Math.pow(Math.abs(Math.log(m[i]) - Math.log(s[i])), this.pow);
            var += Math.pow(Math.abs(Math.log(m[i]) - avg), this.pow);
        }
        return 1.0 - rsme / var;
    }

    @Override
    public double calcNormative(double[] t1, double[] t2) {
        return 1.0 - this.calc(t1, t2);
    }
}

