/*
 * Decompiled with CFR 0.152.
 */
package optas.datamining.kernels;

import optas.datamining.kernels.Kernel;

public class SimpleRationalQuadratic
extends Kernel {
    public SimpleRationalQuadratic(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = 2;
        this.KernelParameterCount = 2;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        this.KernelParameterNames[0] = "alpha";
        this.KernelParameterNames[1] = "sigma";
        return this.KernelParameterNames;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y);
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[1] * this.theta[1];
        }
        return Math.pow(1.0 + r / (2.0 * this.theta[0]), -this.theta[0]) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

