/*
 * Decompiled with CFR 0.152.
 */
package optas.datamining.kernels;

import Jama.Matrix;
import optas.datamining.kernels.Kernel;

public class NeuralNetworkFull
extends Kernel {
    Matrix nnKernel = null;
    int d;

    public NeuralNetworkFull(int inputDim) {
        this.inputDim = inputDim;
        this.d = inputDim + 1;
        this.parameterCount = this.d * (this.d + 1) / 2 + 1;
        this.KernelParameterCount = this.d * (this.d + 1) / 2 + 1;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        for (int i = 0; i < this.inputDim; ++i) {
            this.KernelParameterNames[i] = "P_i" + i;
        }
        return this.KernelParameterNames;
    }

    @Override
    public boolean SetParameter(double[] theta) {
        if (theta.length < this.parameterCount) {
            return false;
        }
        this.theta = theta;
        this.nnKernel = new Matrix(this.d, this.d);
        Matrix G = new Matrix(this.d, this.d);
        int counter = 0;
        for (int i = 0; i < this.d; ++i) {
            for (int j = i; j < this.d; ++j) {
                G.set(j, i, 0.0);
                G.set(i, j, 5.0 * Math.log(theta[counter]));
                ++counter;
            }
        }
        this.nnKernel = G.times(G.transpose());
        return true;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        Matrix mx = new Matrix(1, x.length + 1);
        Matrix my = new Matrix(y.length + 1, 1);
        for (int i = 0; i < x.length; ++i) {
            mx.set(0, i + 1, x[i]);
            my.set(i + 1, 0, y[i]);
        }
        mx.set(0, 0, 1.0);
        my.set(0, 0, 1.0);
        double value1 = mx.times(this.nnKernel).times(my).get(0, 0);
        double value2 = mx.times(this.nnKernel).times(mx.transpose()).get(0, 0);
        double value3 = my.transpose().times(this.nnKernel).times(my).get(0, 0);
        double noise = 0.0;
        if (index1 == index2) {
            noise = 0.0;
        }
        return 0.6366197723675814 * Math.asin((1.0 + 2.0 * value1) / Math.sqrt((1.0 + 2.0 * value2) * (1.0 + 2.0 * value3))) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        Matrix mx = new Matrix(1, x.length + 1);
        Matrix my = new Matrix(y.length + 1, 1);
        for (int k = 0; k < x.length; ++k) {
            mx.set(0, k + 1, x[k]);
            my.set(k + 1, 0, y[k]);
        }
        mx.set(0, 0, 1.0);
        my.set(0, 0, 1.0);
        double xSy = mx.times(this.nnKernel).times(my).get(0, 0);
        double xSx = mx.times(this.nnKernel).times(mx.transpose()).get(0, 0);
        double ySy = my.transpose().times(this.nnKernel).times(my).get(0, 0);
        double v = Math.sqrt((1.0 + 2.0 * xSx) * (1.0 + 2.0 * ySy));
        double outer_derivative = 0.6366197723675814 / Math.sqrt(1.0 - 4.0 * xSy * xSy / (v * v));
        int t1 = d;
        int t2 = d;
        double u = 2.0 * xSy;
        double du = 2.0 * mx.get(0, t1) * my.get(t2, 0);
        double dv = (2.0 * mx.get(0, t1) * mx.get(0, t2) * (1.0 + 2.0 * ySy) + 2.0 * my.get(t1, 0) * my.get(t2, 0) * (1.0 + 2.0 * xSx)) / (2.0 * v);
        return outer_derivative * (du / v - u * dv / (v * v));
    }
}

