/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.data.Attribute;
import java.util.ArrayList;
import java.util.Date;
import optas.data.DataSet;
import optas.data.Ensemble;
import optas.data.SimpleEnsemble;
import optas.data.TimeFilter;
import optas.data.TimeSerie;

public class TimeSerieEnsemble
extends Ensemble {
    double[][] value;
    int currentIndex = 0;
    Attribute.TimeInterval timeInterval = null;
    ArrayList<TimeFilter> filter = new ArrayList();
    ArrayList<Integer> timeMap = new ArrayList();

    @Override
    public Ensemble clone() {
        TimeSerieEnsemble s = new TimeSerieEnsemble(this.name, this.size, this.timeInterval);
        for (int i = 0; i < this.size; ++i) {
            s.set(i, this.getId(i));
        }
        s.currentIndex = this.currentIndex;
        s.parent = this.parent;
        s.value = (double[][])this.value.clone();
        s.timeMap = (ArrayList)this.timeMap.clone();
        s.filter = (ArrayList)this.filter.clone();
        return s;
    }

    public TimeSerieEnsemble(String name, int size, Attribute.TimeInterval timeInterval) {
        super(size);
        this.name = name;
        this.value = new double[size][];
        this.timeInterval = timeInterval;
    }

    public void addTimeFilter(TimeFilter filter) {
        this.filter.add(filter);
        this.buildTimeMapping();
    }

    public void removeTimeFilter(TimeFilter filter) {
        this.filter.remove(filter);
        this.buildTimeMapping();
    }

    public ArrayList<TimeFilter> getTimeFilters() {
        return this.filter;
    }

    private void buildTimeMapping() {
        this.timeMap.clear();
        Attribute.Calendar c1 = this.timeInterval.getStart().clone();
        for (int i = 0; i < this.value[0].length; ++i) {
            c1.add(this.timeInterval.getTimeUnit(), this.timeInterval.getTimeUnitCount());
            Date d = (Date)c1.getTime().clone();
            boolean isFiltered = false;
            for (TimeFilter f : this.filter) {
                if (!f.isFiltered(d)) continue;
                isFiltered = true;
                break;
            }
            if (isFiltered) continue;
            this.timeMap.add(i);
        }
    }

    public SimpleEnsemble sumTS() {
        SimpleEnsemble e = new SimpleEnsemble("sum of" + this.name, this.size);
        for (int i = 0; i < this.size; ++i) {
            double v = 0.0;
            Integer id = this.getId(i);
            for (int t = 0; t < this.getTimesteps(); ++t) {
                v += this.get(t, id);
            }
            e.set(i, id, v);
        }
        return e;
    }

    public void add(Integer id, double[] value) {
        super.set(this.currentIndex, id);
        this.value[this.currentIndex] = value;
        if (this.timeMap.isEmpty()) {
            this.buildTimeMapping();
        }
        ++this.currentIndex;
    }

    public Date getDate(int time) {
        int time2 = 0;
        time2 = this.filter.isEmpty() ? time : this.timeMap.get(time);
        Attribute.Calendar c1 = this.timeInterval.getStart().clone();
        c1.add(this.timeInterval.getTimeUnit(), this.timeInterval.getTimeUnitCount() * time2);
        return c1.getTime();
    }

    public int getTimesteps() {
        if (this.filter.isEmpty()) {
            return this.value[0].length;
        }
        return this.timeMap.size();
    }

    public double get(int time, Integer id) {
        if (this.filter.isEmpty()) {
            return this.value[this.getIndex(id)][time];
        }
        return this.value[this.getIndex(id)][this.timeMap.get(time)];
    }

    public SimpleEnsemble get(int time) {
        SimpleEnsemble s = new SimpleEnsemble("timestep:" + time, this.size);
        s.parent = this;
        for (int i = 0; i < this.size; ++i) {
            Integer id = this.getId(i);
            s.add(id, this.value[i][this.timeMap.get(time)]);
        }
        return s;
    }

    public double[] getValue(Integer id) {
        int index = this.getIndex(id);
        return this.value[index];
    }

    public TimeSerie getTimeSerie(Integer id) {
        try {
            return new TimeSerie(this.getValue(id), this.getTimesteps(), "max of " + this.name, this.parent);
        }
        catch (DataSet.MismatchException me) {
            return null;
        }
    }

    public TimeSerie getMax() {
        double[] max = new double[this.getTimesteps()];
        for (int t = 0; t < this.getTimesteps(); ++t) {
            max[t] = Double.NEGATIVE_INFINITY;
            for (int mc = 0; mc < this.getSize(); ++mc) {
                max[t] = Math.max(this.get(t, this.getId(mc)), max[t]);
            }
        }
        try {
            return new TimeSerie(max, this.getTimesteps(), "max of " + this.name, this.parent);
        }
        catch (DataSet.MismatchException me) {
            return null;
        }
    }

    public TimeSerie getMin() {
        double[] max = new double[this.getTimesteps()];
        for (int t = 0; t < this.getTimesteps(); ++t) {
            max[t] = Double.POSITIVE_INFINITY;
            for (int mc = 0; mc < this.getSize(); ++mc) {
                max[t] = Math.min(this.get(t, this.getId(mc)), max[t]);
            }
        }
        try {
            return new TimeSerie(max, this.getTimesteps(), "min of " + this.name, this.parent);
        }
        catch (DataSet.MismatchException me) {
            return null;
        }
    }

    public Attribute.TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public void removeId(Integer id) {
        int index = this.getIndex(id);
        super.removeId(id);
        --this.currentIndex;
        this.value[index] = this.value[this.size];
    }
}

