/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.stores.J2KTSDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import optas.data.DataSet;
import optas.data.TimeFilter;

public class TimeSerie
extends DataSet {
    private float[] set;
    private int timeLength;
    private Attribute.TimeInterval range;
    ArrayList<TimeFilter> filter = new ArrayList();
    ArrayList<Integer> timeMap = new ArrayList();

    public TimeSerie(TimeSerie set) {
        this.set = set.set;
        this.timeLength = set.timeLength;
        this.range = set.range;
        this.name = set.name;
    }

    public TimeSerie(double[] value, Attribute.TimeInterval range, String name, DataSet parent) throws DataSet.MismatchException {
        this.set = new float[value.length];
        this.name = name;
        for (int i = 0; i < value.length; ++i) {
            this.set[i] = (float)value[i];
        }
        this.parent = parent;
        this.range = range;
        this.timeLength = (int)range.getNumberOfTimesteps();
        if (this.set.length != this.timeLength) {
            throw new DataSet.MismatchException("mismatch between timeInterval:" + range.toString() + " and provided number of data values:" + this.set.length + "(expected: " + this.timeLength + ")");
        }
    }

    public TimeSerie(double[] value, int range, String name, DataSet parent) throws DataSet.MismatchException {
        this.set = new float[value.length];
        this.name = name;
        for (int i = 0; i < value.length; ++i) {
            this.set[i] = (float)value[i];
        }
        this.parent = parent;
        this.timeLength = range;
        if (this.set.length != this.timeLength) {
            throw new DataSet.MismatchException("mismatch between timeInterval:" + range + " and provided number of data values:" + this.set.length);
        }
    }

    public void addTimeFilter(TimeFilter filter) {
        this.filter.add(filter);
        this.buildTimeMapping();
    }

    public void removeTimeFilter(TimeFilter filter) {
        if (filter == null) {
            this.filter.clear();
        }
        this.filter.remove(filter);
        this.buildTimeMapping();
    }

    private void buildTimeMapping() {
        this.timeMap.clear();
        for (int i = 0; i < this.set.length; ++i) {
            Date d = this.getUnfilteredTime(i);
            boolean isFiltered = false;
            for (TimeFilter f : this.filter) {
                if (!f.isFiltered(d)) continue;
                isFiltered = true;
                break;
            }
            if (isFiltered) continue;
            this.timeMap.add(i);
        }
    }

    public ArrayList<TimeFilter> getTimeFilters() {
        return this.filter;
    }

    public int getTimesteps() {
        if (this.filter.isEmpty()) {
            return this.set.length;
        }
        return this.timeMap.size();
    }

    public int findArgMin() {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.timeLength; ++i) {
            if ((double)this.set[i] == JAMS.getMissingDataValue() || !((double)this.set[i] < min)) continue;
            min = this.set[i];
            index = i;
        }
        if (index == -1 && this.set.length > 0) {
            return 0;
        }
        return index;
    }

    public int findArgMax() {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.timeLength; ++i) {
            if ((double)this.set[i] == JAMS.getMissingDataValue() || !((double)this.set[i] > max)) continue;
            max = this.set[i];
            index = i;
        }
        if (index == -1 && this.set.length > 0) {
            return 0;
        }
        return index;
    }

    public double getMin() {
        return this.set[this.findArgMin()];
    }

    public double getMax() {
        return this.set[this.findArgMax()];
    }

    public double getValue(int time) {
        if (this.filter.isEmpty()) {
            return this.set[time];
        }
        return this.set[this.timeMap.get(time)];
    }

    private Date getUnfilteredTime(int time) {
        Attribute.Calendar c = this.range.getStart().clone();
        c.add(this.range.getTimeUnit(), time * this.range.getTimeUnitCount());
        return c.getTime();
    }

    public Date getTime(int time) {
        if (!this.filter.isEmpty()) {
            time = this.timeMap.get(time);
        }
        Attribute.Calendar c = this.range.getStart().clone();
        c.add(this.range.getTimeUnit(), time * this.range.getTimeUnitCount());
        return c.getTime();
    }

    public Attribute.TimeInterval getTimeDomain() {
        if (this.filter.isEmpty()) {
            return this.range;
        }
        Attribute.TimeInterval range = DefaultDataFactory.getDataFactory().createTimeInterval();
        range.setTimeUnit(this.range.getTimeUnit());
        range.setTimeUnitCount(this.range.getTimeUnitCount());
        range.getStart().setTime(this.getTime(0));
        range.getEnd().setTime(this.getTime(this.getTimesteps() - 1));
        return range;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.hashCode(this.set);
        hash = 53 * hash + this.timeLength;
        hash = 53 * hash + (this.range != null ? this.range.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static TimeSerie createFromJ2KTSDataStore(J2KTSDataStore store, int index, String name) {
        Attribute.TimeInterval range = DefaultDataFactory.getDataFactory().createTimeInterval();
        range.setStart(store.getStartDate());
        range.setEnd(store.getEndDate());
        range.setTimeUnit(store.getTimeUnit());
        range.setTimeUnitCount(store.getTimeUnitCount());
        long count = range.getNumberOfTimesteps();
        double[] value = new double[(int)count];
        int i = 0;
        while (store.hasNext()) {
            value[i++] = store.getNext().getData()[index].getDouble();
        }
        try {
            return new TimeSerie(value, range, name, null);
        }
        catch (DataSet.MismatchException me) {
            return null;
        }
    }

    public static TimeSerie createFromJ2KTSDataStore(J2KTSDataStore store, String selectedAttribute, String name) {
        ArrayList list = store.getDataSetDefinition().getAttributeNames();
        int index = list.indexOf(name);
        if (index == -1) {
            return null;
        }
        return TimeSerie.createFromJ2KTSDataStore(store, index, name);
    }
}

