/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import optas.optimizer.management.SampleFactory;

public class RankingTable {
    private RankedSample[] table;
    private double alpha = 0.1;
    private SampleFactory.Sample[] candidates = null;

    public RankingTable(List<SampleFactory.Sample> samples) {
        this.table = new RankedSample[samples.size()];
        int i = 0;
        for (SampleFactory.Sample sample : samples) {
            this.table[i] = new RankedSample(sample);
            ++i;
        }
    }

    public SampleFactory.Sample[] getCandidates() {
        return this.candidates;
    }

    public void computeRankings() {
        int efficiency;
        int m = this.table[0].sample.F().length;
        this.candidates = new SampleFactory.Sample[m];
        for (efficiency = 0; efficiency < m; ++efficiency) {
            Arrays.sort(this.table, new SampleColumnComparator(efficiency));
            int rank = 1;
            for (RankedSample rs : this.table) {
                int n = efficiency;
                rs.rank[n] = rs.rank[n] + rank;
                ++rank;
            }
        }
        for (efficiency = 0; efficiency < m; ++efficiency) {
            int maxRank = (int)Math.ceil(this.alpha * (double)this.table.length);
            SampleFactory.Sample bestSample = null;
            int bestRank = Integer.MAX_VALUE;
            for (RankedSample rs : this.table) {
                int curRank = 0;
                if (rs.rank[efficiency] > maxRank) continue;
                for (int i = 0; i < m; ++i) {
                    curRank += rs.rank[i];
                }
                if (curRank >= bestRank) continue;
                bestRank = curRank;
                bestSample = rs.sample;
            }
            this.candidates[efficiency] = bestSample;
        }
    }

    public String toString() {
        String s = "";
        for (RankedSample rs : this.table) {
            s = s + rs.rank + " ";
            s = s + Arrays.toString(rs.sample.F()) + "\n";
        }
        return s;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private class SampleColumnComparator
    implements Comparator<RankedSample> {
        private int column;

        public SampleColumnComparator(int col) {
            this.column = col;
        }

        @Override
        public int compare(RankedSample o1, RankedSample o2) {
            double d = o1.sample.F()[this.column] - o2.sample.F()[this.column];
            if (Double.isNaN(o1.sample.F()[this.column])) {
                return -1;
            }
            if (Double.isNaN(o2.sample.F()[this.column])) {
                return 1;
            }
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    private class RankedSample {
        public int[] rank;
        public SampleFactory.Sample sample;

        public RankedSample(SampleFactory.Sample s) {
            this.rank = new int[s.F().length];
            this.sample = s;
        }
    }
}

