/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.data.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import optas.data.DataSet;
import optas.data.SpatialDataSet;
import optas.data.TimeSerie;

public class Modelrun
extends DataSet {
    private ArrayList<DataSet> datasets;
    private HashMap<Class, ArrayList<DataSet>> map;
    private SpatialDataSet spatialDataSet = null;
    private Integer id;
    Attribute.TimeInterval timeDomain;
    static final long serialVersionUID = -9046263815810640999L;

    public Modelrun(Integer id, Attribute.TimeInterval timeDomain) {
        this.timeDomain = timeDomain;
        this.datasets = new ArrayList();
        this.map = new HashMap();
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public Attribute.TimeInterval getTimeDomain() {
        return this.timeDomain;
    }

    public Iterator<DataSet> getDatasets() {
        return this.datasets.iterator();
    }

    public DataSet getDataset(String name) {
        for (DataSet d : this.datasets) {
            if (!d.name.equals(name)) continue;
            return d;
        }
        return null;
    }

    public boolean hasSpatialDataSet() {
        return this.spatialDataSet != null;
    }

    public SpatialDataSet getSpatialDataSet() {
        return this.spatialDataSet;
    }

    public void addDataSet(DataSet set) throws DataSet.MismatchException {
        this.addDataSet(null, set);
    }

    public void addDataSet(Integer areaID, DataSet set) throws DataSet.MismatchException {
        if (set instanceof TimeSerie) {
            this.addTimeSerie((TimeSerie)set);
        }
        if (areaID != null) {
            if (!this.hasSpatialDataSet()) {
                this.spatialDataSet = new SpatialDataSet();
            }
            this.spatialDataSet.addDatasetForAreaID(areaID, set);
        }
        this.registerDataSet(set);
    }

    private void registerDataSet(DataSet set) {
        set.parent = this;
        this.datasets.add(set);
        if (!this.map.containsKey(set.getClass())) {
            this.map.put(set.getClass(), new ArrayList());
        }
        this.map.get(set.getClass()).add(set);
    }

    public void removeDataset(String name) {
        for (DataSet d : this.datasets) {
            if (!d.name.equals(name)) continue;
            this.datasets.remove(d);
            for (ArrayList<DataSet> list : this.map.values()) {
                if (!list.contains(d)) continue;
                list.remove(d);
            }
        }
    }

    private void addTimeSerie(TimeSerie timeserie) throws DataSet.MismatchException {
        if (this.timeDomain == null) {
            this.timeDomain = timeserie.getTimeDomain();
        } else if (!this.timeDomain.equals(timeserie.getTimeDomain())) {
            throw new DataSet.MismatchException("time domains of different series do not match:" + this.timeDomain.toString() + " vs. " + timeserie.getTimeDomain());
        }
        timeserie.parent = this;
    }

    public DataSet getDatasets(Class clazz, int index) {
        return this.map.get(clazz).get(index);
    }

    public int getDatasetCount(Class clazz) {
        return this.map.get(clazz).size();
    }

    public void changeId(Integer id) {
        this.id = id;
    }
}

