/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import optas.data.DataSet;

public abstract class Ensemble
extends DataSet {
    protected int size;
    private Integer[] id;
    private HashMap<Integer, Integer> map = new HashMap();

    public abstract Ensemble clone();

    public Ensemble(int size) {
        this.size = size;
        this.id = new Integer[size];
    }

    public Ensemble(Ensemble e) {
        super(e);
        this.size = e.size;
        this.id = e.id;
        this.map = e.map;
    }

    protected void update() {
        for (int i = 0; i < this.id.length; ++i) {
            this.map.put(this.id[i], new Integer(i));
        }
    }

    protected int getIndex(Integer id) {
        return this.map.get(id);
    }

    protected void set(int index, Integer id) {
        this.map.put(this.id[index], null);
        this.id[index] = id;
        this.map.put(id, index);
    }

    public Integer getId(int index) {
        return this.id[index];
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public Integer[] getIds() {
        return Arrays.copyOf(this.id, this.size);
    }

    public void retainIds(Integer[] ids) {
        TreeSet<Integer> set1 = new TreeSet<Integer>();
        set1.addAll(Arrays.asList(ids));
        TreeSet<Integer> set2 = new TreeSet<Integer>();
        set2.addAll(Arrays.asList(this.getIds()));
        set2.removeAll(set1);
        for (Integer i : set2) {
            this.removeId(i);
        }
    }

    public void removeId(Integer id) {
        --this.size;
        int index = this.getIndex(id);
        this.map.remove(id);
        if (this.size > 0 && index != this.size) {
            this.id[index] = this.id[this.size];
            this.map.put(this.id[index], index);
        }
    }
}

