/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Observable;
import java.util.TreeSet;
import optas.SA.ErrorStatistics;
import optas.SA.FAST;
import optas.SA.GradientSensitivityAnalysis;
import optas.SA.LinearRegression;
import optas.SA.MorrisMethod;
import optas.SA.RegionalSensitivityAnalysis;
import optas.SA.SensitivityAnalyzer;
import optas.SA.SobolsMethod;
import optas.core.AbstractDataSerie;
import optas.core.AbstractFunction;
import optas.data.DataCollection;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.optimizer.management.SampleFactory;
import optas.regression.Interpolation;
import optas.regression.SimpleInterpolation;
import optas.regression.SimpleNeuralNetwork;

public class UniversalSensitivityAnalyzer
extends Observable {
    SAMethod method = SAMethod.RSA;
    SensitivityAnalyzer sa = null;
    SimpleInterpolation I = null;
    boolean usingRegression = false;
    SimpleInterpolation.NormalizationMethod parameterNormalizationMethod = SimpleInterpolation.NormalizationMethod.Linear;
    SimpleInterpolation.NormalizationMethod objectiveNormalizationMethod = SimpleInterpolation.NormalizationMethod.Linear;
    SimpleEnsemble[] xData = null;
    EfficiencyEnsemble yData = null;
    double[][] range = null;
    int sampleCount = 2000;
    int n = 0;

    public void setParameterNormalizationMethod(SimpleInterpolation.NormalizationMethod normalizationMethod) {
        this.parameterNormalizationMethod = normalizationMethod;
    }

    public void setObjectiveNormalizationMethod(SimpleInterpolation.NormalizationMethod normalizationMethod) {
        this.objectiveNormalizationMethod = normalizationMethod;
    }

    public SimpleInterpolation.NormalizationMethod getParameterNormalizationMethod() {
        return this.parameterNormalizationMethod;
    }

    public SimpleInterpolation.NormalizationMethod getObjectiveNormalizationMethod() {
        return this.objectiveNormalizationMethod;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public SAMethod getMethod() {
        return this.method;
    }

    public void setMethod(SAMethod method) {
        switch (method) {
            case RSA: {
                this.sa = new RegionalSensitivityAnalysis();
                break;
            }
            case MaximumGradient: {
                this.sa = new GradientSensitivityAnalysis();
                break;
            }
            case ElementaryEffects: {
                this.sa = new MorrisMethod();
                break;
            }
            case ElementaryEffectsNonAbs: {
                this.sa = new MorrisMethod(MorrisMethod.Measure.NonAbsolute);
                break;
            }
            case ElementaryEffectsVariance: {
                this.sa = new MorrisMethod(MorrisMethod.Measure.Variance);
                break;
            }
            case FOSI1: {
                this.sa = new FAST(FAST.Measure.FirstOrder);
                break;
            }
            case FOSI2: {
                this.sa = new SobolsMethod(SobolsMethod.Measure.FirstOrder);
                break;
            }
            case TOSI: {
                this.sa = new SobolsMethod(SobolsMethod.Measure.Total);
                break;
            }
            case Interaction: {
                this.sa = new SobolsMethod(SobolsMethod.Measure.Interaction);
                break;
            }
            case LinearRegression: {
                this.sa = new LinearRegression();
            }
        }
    }

    public void setSamplingMethod(SensitivityAnalyzer.SamplingMethod sm) {
        this.sa.setSamplingMethod(sm);
    }

    public boolean isUsingRegression() {
        return this.usingRegression;
    }

    public void setUsingRegression(boolean flag) {
        this.usingRegression = flag;
    }

    public double setup(SimpleEnsemble[] xData, EfficiencyEnsemble yData) {
        return this.setup(xData, yData, new SimpleNeuralNetwork());
    }

    protected void setState(String state) {
        this.setChanged();
        this.notifyObservers(state);
    }

    public double setup(SimpleEnsemble[] xData, EfficiencyEnsemble yData, SimpleInterpolation interpolationAlgorithm) {
        this.setState("setup sensitivity analysis");
        this.xData = xData;
        this.yData = yData;
        this.n = xData.length;
        this.range = new double[this.n][2];
        double error = 0.0;
        if (this.usingRegression) {
            this.I = interpolationAlgorithm;
            if (this.I == null) {
                this.I = new SimpleNeuralNetwork();
            }
            this.I.setData(xData, yData);
            this.I.setxNormalizationMethod(this.parameterNormalizationMethod);
            this.I.setyNormalizationMethod(this.objectiveNormalizationMethod);
            error = this.I.init();
        }
        for (int i = 0; i < this.n; ++i) {
            this.range[i][0] = xData[i].getMin();
            this.range[i][1] = xData[i].getMax();
        }
        if (this.usingRegression) {
            this.sa.setModel(new AbstractFunction(){
                int counter = 0;
                SampleFactory factory = new SampleFactory();

                @Override
                public int getInputDimension() {
                    return UniversalSensitivityAnalyzer.this.n;
                }

                @Override
                public int getOutputDimension() {
                    return 1;
                }

                @Override
                public double[][] getRange() {
                    return UniversalSensitivityAnalyzer.this.range;
                }

                @Override
                public String[] getInputFactorNames() {
                    String[] names = new String[UniversalSensitivityAnalyzer.this.n];
                    for (int i = 0; i < this.getInputDimension(); ++i) {
                        names[i] = UniversalSensitivityAnalyzer.this.xData[i].getName();
                    }
                    return names;
                }

                @Override
                public String[] getOutputFactorNames() {
                    return new String[]{UniversalSensitivityAnalyzer.this.yData.getName()};
                }

                @Override
                public double[] evaluate(double[] x) {
                    if (UniversalSensitivityAnalyzer.this.usingRegression) {
                        return UniversalSensitivityAnalyzer.this.I.getInterpolatedValue(x);
                    }
                    return null;
                }

                @Override
                public void log(String msg) {
                    System.out.println(msg);
                }
            });
            this.sa.setSampleSize(this.sampleCount);
        } else {
            this.sa.setModel(new AbstractDataSerie(){
                int counter = 0;
                SampleFactory factory = new SampleFactory();

                @Override
                public void reset() {
                    this.counter = 0;
                    this.factory = new SampleFactory();
                }

                @Override
                public int getInputDimension() {
                    return UniversalSensitivityAnalyzer.this.n;
                }

                @Override
                public int getOutputDimension() {
                    return 1;
                }

                @Override
                public double[][] getRange() {
                    return UniversalSensitivityAnalyzer.this.range;
                }

                @Override
                public String[] getInputFactorNames() {
                    String[] names = new String[UniversalSensitivityAnalyzer.this.n];
                    for (int i = 0; i < this.getInputDimension(); ++i) {
                        names[i] = UniversalSensitivityAnalyzer.this.xData[i].getName();
                    }
                    return names;
                }

                @Override
                public String[] getOutputFactorNames() {
                    return new String[]{UniversalSensitivityAnalyzer.this.yData.getName()};
                }

                @Override
                public SampleFactory.Sample getNext() {
                    double[] x = new double[this.getInputDimension()];
                    if (this.counter >= UniversalSensitivityAnalyzer.this.xData[0].getSize()) {
                        return null;
                    }
                    int nextId = UniversalSensitivityAnalyzer.this.xData[0].getId(this.counter++);
                    for (int i = 0; i < x.length; ++i) {
                        x[i] = UniversalSensitivityAnalyzer.this.xData[i].getValue(nextId);
                    }
                    return this.factory.getSampleSO(x, UniversalSensitivityAnalyzer.this.yData.getValue(nextId));
                }

                @Override
                public void log(String msg) {
                    System.out.println(msg);
                }
            });
            this.sa.setSampleSize(this.yData.getSize());
        }
        return error;
    }

    public SimpleEnsemble[] getXDataSet() {
        return this.xData;
    }

    public EfficiencyEnsemble getYDataSet() {
        return this.yData;
    }

    public double[][][] getInteractionsUncertainty() {
        int j;
        this.setState("calculating uncertainty of interaction effects");
        double[][][] result = new double[this.n][this.n][3];
        ArrayList<T[]> statistics = new ArrayList<T[]>();
        double[][] mean = new double[this.n][this.n];
        double[][] sigma = new double[this.n][this.n];
        double[][] min = new double[this.n][this.n];
        double[][] max = new double[this.n][this.n];
        double currentMaxError = 1000.0;
        double maxAcceptedError = 0.01;
        for (int j2 = 0; j2 < this.n; ++j2) {
            for (int k = 0; k < this.n; ++k) {
                min[j2][k] = Double.MAX_VALUE;
                max[j2][k] = Double.MIN_VALUE;
            }
        }
        double z = 1.96;
        int i = 0;
        while (i++ < 10 || currentMaxError > maxAcceptedError) {
            this.setup(this.xData, this.yData);
            this.setState("<html>Calculating Interaction Effects ... <br>Iteration: " + i + "<br>Error: " + String.format(Locale.ENGLISH, "%.4f", currentMaxError) + " ( max: " + String.format(Locale.ENGLISH, "%.4f", maxAcceptedError) + ")</html>");
            double[][] sensitivityIndex = new double[this.n][this.n];
            sensitivityIndex = this.getInteractions();
            if (sensitivityIndex == null) {
                return null;
            }
            statistics.add(Arrays.copyOf(sensitivityIndex, this.n));
            for (int j3 = 0; j3 < this.n; ++j3) {
                for (int k = 0; k < this.n; ++k) {
                    double[] dArray = mean[j3];
                    int n = k;
                    dArray[n] = dArray[n] + sensitivityIndex[j3][k];
                    sigma[j3][k] = 0.0;
                    min[j3][k] = Math.min(min[j3][k], sensitivityIndex[j3][k]);
                    max[j3][k] = Math.max(max[j3][k], sensitivityIndex[j3][k]);
                }
            }
            double K = statistics.size();
            int l = 0;
            while ((double)l < K) {
                for (int j4 = 0; j4 < this.n; ++j4) {
                    int k = 0;
                    while (k < this.n) {
                        double v = ((double[][])statistics.get(l))[j4][k] - mean[j4][k] / K;
                        double[] dArray = sigma[j4];
                        int n = k++;
                        dArray[n] = dArray[n] + v * v;
                    }
                }
                ++l;
            }
            currentMaxError = 0.0;
            for (int j5 = 0; j5 < this.n; ++j5) {
                for (int k = 0; k < this.n; ++k) {
                    double[] dArray = sigma[j5];
                    int n = k;
                    dArray[n] = dArray[n] / (K - 1.0);
                    sigma[j5][k] = Math.sqrt(sigma[j5][k]);
                    double error_mean = z * sigma[j5][k] / Math.sqrt(K);
                    currentMaxError = Math.max(error_mean / mean[j5][k], currentMaxError);
                }
            }
            System.out.println("current error:" + currentMaxError);
        }
        for (j = 0; j < this.n; ++j) {
            int k = 0;
            while (k < this.n) {
                double[] dArray = mean[j];
                int n = k++;
                dArray[n] = dArray[n] / (double)statistics.size();
            }
        }
        System.out.println("******************************************");
        System.out.println("Uncertainty calculation finished");
        System.out.println("id\tmu\tsigma\tmin\tmax");
        for (j = 0; j < this.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                System.out.println(j + 1 + "-" + (k + 1) + "\t" + String.format(Locale.ENGLISH, "%.3f", mean[j][k]) + "\t" + String.format(Locale.ENGLISH, "%.4f", sigma[j][k]) + "\t" + String.format(Locale.ENGLISH, "%.3f", min[j][k]) + "\t" + String.format(Locale.ENGLISH, "%.3f", max[j][k]));
            }
        }
        System.out.println("******************************************");
        for (j = 0; j < this.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                result[j][k] = new double[]{mean[j][k] - 1.96 * sigma[j][k], mean[j][k], mean[j][k] + 1.96 * sigma[j][k]};
            }
        }
        return result;
    }

    public double[][] getInteractions() {
        if (this.sa instanceof SobolsMethod) {
            int i;
            double[][] s = new double[this.n][this.n];
            SobolsMethod v = (SobolsMethod)this.sa;
            for (i = 0; i < this.n; ++i) {
                s[i][i] = v.getSensitivity(i);
            }
            for (i = 0; i < this.n; ++i) {
                for (int j = i + 1; j < this.n; ++j) {
                    TreeSet<Integer> set = new TreeSet<Integer>();
                    set.add(i);
                    set.add(j);
                    s[i][j] = v.getSensitivity(set)[0];
                    s[j][i] = s[i][j] - s[i][i] - s[j][j];
                }
            }
            return s;
        }
        return null;
    }

    public double[] getSensitivity() {
        double[] result = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double s;
            result[i] = s = this.sa.getSensitivity(i);
        }
        return result;
    }

    public double[][] getUncertaintyOfSensitivity() {
        int j;
        double[][] result = new double[this.n][3];
        double currentMaxError = 1000.0;
        double maxAcceptedError = 0.025;
        double z = 1.96;
        int i = 0;
        ErrorStatistics<Double> stat = new ErrorStatistics<Double>(this.n);
        stat.setQuantileRange(0.0, 0.9);
        while (i++ < 10 || currentMaxError > maxAcceptedError) {
            double error = this.setup(this.xData, this.yData);
            this.setState("<html>Calculating Sensitivity Indicies ... <br>Iteration: " + i + "<br>Error: " + String.format(Locale.ENGLISH, "%.4f", currentMaxError) + " ( max: " + String.format(Locale.ENGLISH, "%.4f", maxAcceptedError) + ")</html>");
            double[] sensitivityIndex = new double[this.n];
            for (int j2 = 0; j2 < this.n; ++j2) {
                sensitivityIndex[j2] = this.sa.getSensitivity(j2);
            }
            stat.add(error, sensitivityIndex);
            double[] mean = stat.getMean();
            double[] sigma2 = stat.getVariance();
            int K = stat.getSize();
            if (K == 0) continue;
            currentMaxError = 0.0;
            for (int j3 = 0; j3 < this.n; ++j3) {
                double error_mean = z * Math.sqrt(sigma2[j3]) / Math.sqrt(K);
                currentMaxError = Math.max(error_mean / mean[j3], currentMaxError);
            }
            System.out.println("current error:" + currentMaxError);
        }
        double[] mean = stat.getMean();
        double[] min = stat.getMin();
        double[] max = stat.getMax();
        double[] sigma2 = stat.getVariance();
        double[] sigma = new double[this.n];
        for (j = 0; j < this.n; ++j) {
            sigma[j] = Math.sqrt(sigma2[j]);
        }
        System.out.println("******************************************");
        System.out.println("Uncertainty calculation finished");
        System.out.println("id\tmu\tsigma\tmin\tmax");
        for (j = 0; j < this.n; ++j) {
            System.out.println(j + 1 + "\t" + String.format(Locale.ENGLISH, "%.3f", mean[j]) + "\t" + String.format(Locale.ENGLISH, "%.4f", sigma[j]) + "\t" + String.format(Locale.ENGLISH, "%.3f", min[j]) + "\t" + String.format(Locale.ENGLISH, "%.3f", max[j]));
        }
        System.out.println("******************************************");
        for (j = 0; j < this.n; ++j) {
            result[j] = new double[]{mean[j] - 1.96 * sigma[j], mean[j], mean[j] + 1.96 * sigma[j]};
        }
        return result;
    }

    public double calculateError() {
        if (this.usingRegression) {
            this.setState("<html>Calculating Regression Error ... </html>");
            double[] error = this.I.estimateCrossValidationError(5, Interpolation.ErrorMethod.E2);
            double meanCrossValidationError = 0.0;
            for (int i = 0; i < error.length; ++i) {
                meanCrossValidationError += error[i];
            }
            return meanCrossValidationError /= (double)error.length;
        }
        return 0.0;
    }

    public static void main2(String[] args) {
        DataCollection collection = DataCollection.createFromFile(new File("E:\\ModelData\\Testgebiete\\SynthFunction\\Zakharov\\output\\20140403_101642\\zakharov.cdat"));
        String buffer = "";
        for (int i = 100; i < 101; ++i) {
            collection.filter("ID", 0.0, i, false);
            UniversalSensitivityAnalyzer usa = new UniversalSensitivityAnalyzer();
            usa.setMethod(SAMethod.RSA);
            usa.setSamplingMethod(SensitivityAnalyzer.SamplingMethod.URS);
            usa.setObjectiveNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            usa.setParameterNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            usa.setSampleCount(50000);
            usa.setUsingRegression(true);
            SimpleEnsemble x1 = collection.getSimpleEnsemble("x1");
            SimpleEnsemble x2 = collection.getSimpleEnsemble("x2");
            EfficiencyEnsemble y = (EfficiencyEnsemble)collection.getDataSet("y");
            usa.setup(new SimpleEnsemble[]{x1, x2}, y);
            usa.getSensitivity();
        }
    }

    public static void main(String[] args) {
        DataCollection collection = DataCollection.createFromFile(new File(args[0]));
        String buffer = "";
        for (int i = 5; i < 251; i += 5) {
            collection.filter("ID", 0.0, i, false);
            UniversalSensitivityAnalyzer usa = new UniversalSensitivityAnalyzer();
            usa.setMethod(SAMethod.RSA);
            usa.setSamplingMethod(SensitivityAnalyzer.SamplingMethod.URS);
            usa.setObjectiveNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            usa.setParameterNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            usa.setSampleCount(50000);
            usa.setUsingRegression(true);
            SimpleEnsemble x1 = collection.getSimpleEnsemble("x1");
            SimpleEnsemble x2 = collection.getSimpleEnsemble("x2");
            EfficiencyEnsemble y = (EfficiencyEnsemble)collection.getDataSet("y");
            usa.setup(new SimpleEnsemble[]{x1, x2}, y);
            System.out.println("E2 after " + i + " : " + usa.calculateError());
            double[][] r1 = usa.getUncertaintyOfSensitivity();
            usa.setSamplingMethod(SensitivityAnalyzer.SamplingMethod.URSStatic);
            double[][] r2 = usa.getUncertaintyOfSensitivity();
            buffer = buffer + String.format("%d\t%.3f\t%.3f\t%.3f\t%.3f\t\t%.3f\t%.3f\t%.3f\t%.3f\n", i, r1[0][1], r1[0][2] - r1[0][0], r1[1][1], r1[1][2] - r1[1][0], r2[0][1], r2[0][2] - r2[0][0], r2[1][1], r2[1][2] - r2[1][0]);
            System.out.println("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n" + buffer + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            collection.clearIDFilter();
        }
    }

    public static enum SAMethod {
        RSA,
        MaximumGradient,
        ElementaryEffects,
        ElementaryEffectsNonAbs,
        ElementaryEffectsVariance,
        FOSI1,
        FOSI2,
        TOSI,
        Interaction,
        LinearRegression;

    }
}

