/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.Arrays;
import java.util.TreeSet;
import optas.SA.UniversalSensitivityAnalyzer;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerieEnsemble;
import optas.regression.SimpleInterpolation;
import optas.tools.ObservableProgress;

public class TemporalSensitivityAnalysis
extends ObservableProgress {
    SimpleEnsemble[] parameter;
    EfficiencyEnsemble o;
    TimeSerieEnsemble ts;
    Measurement obs;
    double[][] temporalSensitivityIndex = null;
    int T = 0;
    int size = 0;
    int n = 0;
    int windowSize = 1;
    double[][] range = null;
    boolean isInit = false;
    boolean isCalculated = false;

    public TemporalSensitivityAnalysis(SimpleEnsemble[] parameter, EfficiencyEnsemble o, TimeSerieEnsemble ts, Measurement obs) {
        this.parameter = parameter;
        this.o = o;
        this.ts = ts;
        this.obs = obs;
        this.T = obs.getTimesteps();
        this.n = parameter.length;
        if (this.n == 0) {
            return;
        }
        this.size = parameter[0].getSize();
        for (int i = 0; i < this.n; ++i) {
            if (parameter[i].getSize() == this.size) continue;
            return;
        }
        if (ts.getSize() != this.size) {
            return;
        }
        this.range = this.getParameterRange();
        this.isInit = false;
        this.isCalculated = false;
    }

    protected double[] getLowBound() {
        double[] lb = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            lb[j] = this.parameter[j].getMin();
        }
        return lb;
    }

    protected double[] getUpBound() {
        double[] ub = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            ub[j] = this.parameter[j].getMax();
        }
        return ub;
    }

    protected double[] transformFromUnitCube(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = this.range[i][0] + x[i] * (this.range[i][1] - this.range[i][0]);
        }
        return y;
    }

    protected double[] transformToUnitCube(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = (x[i] - this.range[i][0]) / (this.range[i][1] - this.range[i][0]);
        }
        return y;
    }

    protected final double[][] getParameterRange() {
        if (this.range == null) {
            this.range = new double[this.n][2];
            for (int j = 0; j < this.n; ++j) {
                this.range[j][0] = this.parameter[j].getMin();
                this.range[j][1] = this.parameter[j].getMax();
            }
        }
        return this.range;
    }

    public double[][] calculate() {
        SimpleEnsemble[] parameterCut = new SimpleEnsemble[this.parameter.length];
        Integer[] ids = this.o.sort();
        Integer[] new_ids = Arrays.copyOfRange(ids, 0, (int)(0.95 * (double)ids.length));
        Integer[] idsO = this.o.getIds();
        Integer[] idsP = this.parameter[0].getIds();
        Integer[] idsTS = this.ts.getIds();
        TreeSet<Integer> setO = new TreeSet<Integer>();
        setO.addAll(Arrays.asList(idsO));
        TreeSet<Integer> setP = new TreeSet<Integer>();
        setP.addAll(Arrays.asList(idsO));
        TreeSet<Integer> setTS = new TreeSet<Integer>();
        setTS.addAll(Arrays.asList(idsO));
        if (!setO.containsAll(setP)) {
            setP.removeAll(setO);
            System.out.println("missing ids in O" + setP.toArray());
        }
        if (!setO.containsAll(setTS)) {
            setTS.removeAll(setO);
            System.out.println("missing ids in O" + setTS.toArray());
        }
        if (!setP.containsAll(setO)) {
            setO.removeAll(setP);
            System.out.println("missing ids in P" + setO.toArray());
        }
        if (!setP.containsAll(setTS)) {
            setTS.removeAll(setP);
            System.out.println("missing ids in P" + setTS.toArray());
        }
        if (!setTS.containsAll(setO)) {
            setO.removeAll(setTS);
            System.out.println("missing ids in TS" + setP.toArray());
        }
        if (!setTS.containsAll(setP)) {
            setP.removeAll(setTS);
            System.out.println("missing ids in TS" + setP.toArray());
        }
        for (int i = 0; i < this.parameter.length; ++i) {
            parameterCut[i] = (SimpleEnsemble)this.parameter[i].clone();
            parameterCut[i].retainIds(new_ids);
        }
        EfficiencyEnsemble oCut = (EfficiencyEnsemble)this.o.clone();
        oCut.retainIds(new_ids);
        TimeSerieEnsemble tsCut = (TimeSerieEnsemble)this.ts.clone();
        tsCut.retainIds(new_ids);
        this.temporalSensitivityIndex = this.calcTemporalSensitivity(parameterCut, tsCut);
        return this.temporalSensitivityIndex;
    }

    private double[][] calcTemporalSensitivity(SimpleEnsemble[] parameter, TimeSerieEnsemble ts) {
        this.log("Calculating Temporal Sensitivity Index");
        if (this.isCalculated) {
            return this.temporalSensitivityIndex;
        }
        this.setProgress(0.0);
        UniversalSensitivityAnalyzer SA = new UniversalSensitivityAnalyzer();
        SA.setMethod(UniversalSensitivityAnalyzer.SAMethod.RSA);
        SA.setObjectiveNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
        SA.setParameterNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
        SA.setSampleCount(2000);
        SA.setUsingRegression(false);
        double[][] sensitivity = new double[this.n][this.T];
        for (int i = 0; i < this.T; ++i) {
            int j;
            SimpleEnsemble sumOfWindow = null;
            for (int j2 = i - this.windowSize; j2 < i + this.windowSize; ++j2) {
                int k = Math.min(Math.max(0, j2), this.T - 1);
                SimpleEnsemble s = ts.get(k);
                double observationT = this.obs.getValue(k);
                s.calcPlus(-observationT);
                s.calcAbs();
                if (sumOfWindow == null) {
                    sumOfWindow = s;
                    continue;
                }
                sumOfWindow.calcPlus(s);
            }
            EfficiencyEnsemble e = new EfficiencyEnsemble(sumOfWindow, false);
            SA.setup(parameter, e);
            double[] result = SA.getSensitivity();
            double sum = 0.0;
            for (j = 0; j < this.n; ++j) {
                sensitivity[j][i] = result[j];
                sum += result[j];
            }
            for (j = 0; j < this.n; ++j) {
                double[] dArray = sensitivity[j];
                int n = i;
                dArray[n] = dArray[n] / sum;
            }
            this.setProgress((double)i / (double)this.T);
        }
        this.isCalculated = true;
        return sensitivity;
    }
}

