/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.io.File;
import java.util.ArrayList;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import optas.SA.TemporalSensitivityAnalysis;
import optas.core.AbstractFunction;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerieEnsemble;
import optas.optimizer.management.SampleFactory;
import optas.regression.Interpolation;
import optas.regression.TimeSerieNeuralNetwork;
import optas.sampler.SobolsSequence;

public class SobolsMethodTemporal
extends TemporalSensitivityAnalysis {
    SimpleEnsemble[] x;
    protected int L;
    protected int sampleSize = 2000;
    int MAIN_EFFECT = 0;
    int TOTAL_EFFECT = 1;
    double[][] A = null;
    double[][] B = null;
    double[] x0A = null;
    double[] x0B = null;
    double[][] yA = null;
    double[][] yB = null;
    double[] EyA = null;
    double[] VyA = null;
    TimeSerieNeuralNetwork I;
    TimeSerieEnsemble tsStar;
    double[][][] sensitivityIndex;
    double samplesCurrent;
    double samplesTotal;

    public SobolsMethodTemporal(SimpleEnsemble[] parameter, EfficiencyEnsemble o, TimeSerieEnsemble ts, Measurement obs) {
        super(parameter, o, ts, obs);
    }

    public void loadNetworkState(File networkStateFile) {
        this.init(networkStateFile);
    }

    public void saveNetworkState(File networkStateFile) {
        this.I.save(networkStateFile);
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
        this.isInit = false;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    protected void sampleData(int size) {
        this.log("Sample data");
        this.samplesCurrent = 0.0;
        this.samplesTotal = size;
        this.x = new SimpleEnsemble[this.n];
        for (int j = 0; j < this.n; ++j) {
            this.x[j] = new SimpleEnsemble(this.parameter[j].name + "(*)", size);
        }
        this.tsStar = new TimeSerieEnsemble(this.ts.name, size, this.ts.getTimeInterval());
        SobolsSequence sampler = new SobolsSequence();
        sampler.setFunction(new AbstractFunction(){

            @Override
            public int getInputDimension() {
                return SobolsMethodTemporal.this.n;
            }

            @Override
            public int getOutputDimension() {
                return SobolsMethodTemporal.this.T;
            }

            @Override
            public double[][] getRange() {
                double[][] range = new double[SobolsMethodTemporal.this.I.getN()][2];
                for (int i = 0; i < SobolsMethodTemporal.this.I.getN(); ++i) {
                    range[i][0] = SobolsMethodTemporal.this.getLowBound()[i];
                    range[i][1] = SobolsMethodTemporal.this.getUpBound()[i];
                }
                return range;
            }

            @Override
            public double[] evaluate(double[] x) {
                SobolsMethodTemporal.this.setProgress(SobolsMethodTemporal.this.samplesCurrent / SobolsMethodTemporal.this.samplesTotal);
                return SobolsMethodTemporal.this.I.getInterpolatedValue(x);
            }

            @Override
            public void log(String msg) {
                System.out.println(msg);
            }
        });
        sampler.setDebugMode(false);
        sampler.setMaxn(size);
        sampler.optimize();
        this.log("Sampling finished");
        ArrayList<SampleFactory.Sample> result = sampler.getSamples();
        for (int i = 0; i < result.size(); ++i) {
            SampleFactory.Sample s = result.get(i);
            for (int j = 0; j < this.n; ++j) {
                this.x[j].add(i, s.x[j]);
            }
            this.tsStar.add(i, s.F());
        }
        this.L = result.size();
    }

    private void updateData() {
        this.log("Generate Data");
        this.setProgress(0.0);
        this.sampleData(5000);
        this.log("Resample Data");
        this.setProgress(0.0);
        int Lh = this.L / 2;
        this.A = new double[Lh][];
        this.B = new double[Lh][];
        this.yA = new double[Lh][];
        this.yB = new double[Lh][];
        this.x0A = new double[this.n];
        this.x0B = new double[this.n];
        this.EyA = new double[this.T];
        this.VyA = new double[this.T];
        for (int i = 0; i < Lh; ++i) {
            this.setProgress((double)i / (double)Lh);
            int id_iA = this.x[0].getId(i);
            int id_iB = this.x[0].getId(i + Lh);
            for (int j = 0; j < this.n; ++j) {
                this.x0A[j] = this.x[j].getValue(id_iA);
                this.x0B[j] = this.x[j].getValue(id_iB);
            }
            this.A[i] = this.transformToUnitCube(this.x0A);
            this.yA[i] = this.tsStar.getValue(id_iA);
            this.B[i] = this.transformToUnitCube(this.x0B);
            this.yB[i] = this.tsStar.getValue(id_iB);
            for (int t = 0; t < this.T; ++t) {
                int n = t;
                this.EyA[n] = this.EyA[n] + this.yA[i][t];
                int n2 = t;
                this.VyA[n2] = this.VyA[n2] + this.yA[i][t] * this.yA[i][t];
            }
        }
        for (int t = 0; t < this.T; ++t) {
            int n = t;
            this.EyA[n] = this.EyA[n] / (double)Lh;
            this.VyA[t] = this.VyA[t] / (double)Lh - this.EyA[t] * this.EyA[t];
        }
    }

    protected double[] getInterpolation(double[] x) {
        return this.I.getInterpolatedValue(x);
    }

    private void init(File f) {
        this.log("Initialize Temporal Sensitivity Analysis");
        this.setProgress(0.0);
        this.I = new TimeSerieNeuralNetwork();
        this.log("Setup Interpolation method");
        for (Observer o : this.getObservers()) {
            this.I.addObserver(o);
        }
        this.I.setData(this.parameter, this.ts);
        if (f != null) {
            this.I.load(f);
        }
        this.I.init();
        this.updateData();
        this.isInit = true;
        this.calcSensitivity();
    }

    @Override
    public double[][] calculate() {
        super.calculate();
        this.log("Calculating Sensitivity Indicies");
        if (!this.isInit) {
            this.init(null);
        }
        double[][] sensitivity = new double[this.n][this.T];
        for (int i = 0; i < this.n; ++i) {
            for (int t = 0; t < this.T; ++t) {
                sensitivity[i][t] = this.sensitivityIndex[i][t][this.TOTAL_EFFECT];
            }
        }
        for (int t = 0; t < this.T; ++t) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.n; ++i) {
                sum += sensitivity[i][t];
            }
            for (i = 0; i < this.n; ++i) {
                if (!(sensitivity[i][t] < 0.025 * sum)) continue;
                sensitivity[i][t] = 0.0;
            }
            sum = 0.0;
            for (i = 0; i < this.n; ++i) {
                sum += sensitivity[i][t];
            }
            for (i = 0; i < this.n; ++i) {
                double[] dArray = sensitivity[i];
                int n = t;
                dArray[n] = dArray[n] / sum;
            }
        }
        return sensitivity;
    }

    private void calcSensitivity() {
        if (!this.isInit) {
            this.init(null);
        }
        this.sensitivityIndex = new double[this.n][][];
        for (int i = 0; i < this.n; ++i) {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(i);
            this.log("Calculating Sensitivity for " + this.x[i].name);
            this.sensitivityIndex[i] = this.calcSensitivity(set);
        }
    }

    public double[][] calcSensitivity(Set<Integer> indexSet) {
        if (!this.isInit) {
            this.init(null);
        }
        double[][] sensitivityIndex = new double[this.T][2];
        int Lh = this.L / 2;
        double[][] C = new double[Lh][this.n];
        double[][] D = new double[Lh][this.n];
        double[][] yC = new double[Lh][];
        double[][] yD = new double[Lh][];
        for (int i = 0; i < Lh; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (indexSet.contains(j)) {
                    C[i][j] = this.A[i][j];
                    D[i][j] = this.B[i][j];
                    continue;
                }
                C[i][j] = this.B[i][j];
                D[i][j] = this.A[i][j];
            }
            yC[i] = this.getInterpolation(this.transformFromUnitCube(C[i]));
            yD[i] = this.getInterpolation(this.transformFromUnitCube(D[i]));
            this.setProgress((double)i / (double)Lh);
        }
        for (int t = 0; t < this.T; ++t) {
            double ti1 = 0.0;
            double ti2 = 0.0;
            for (int i = 0; i < Lh; ++i) {
                ti1 += this.yA[i][t] * yC[i][t];
                ti2 += this.yA[i][t] * yD[i][t];
            }
            double VyAC = (ti1 /= (double)Lh) - this.EyA[t] * this.EyA[t];
            double VyBC = (ti2 /= (double)Lh) - this.EyA[t] * this.EyA[t];
            sensitivityIndex[t][this.MAIN_EFFECT] = Math.max(VyAC / this.VyA[t], 0.0);
            sensitivityIndex[t][this.TOTAL_EFFECT] = Math.max(1.0 - VyBC / this.VyA[t], 0.0);
        }
        return sensitivityIndex;
    }

    public double[] getCVError(int K) {
        return this.I.estimateCrossValidationError(K, Interpolation.ErrorMethod.E2);
    }
}

