/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import optas.SA.SensitivityAnalyzer;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.optimizer.management.SampleFactory;

public class RegionalSensitivityAnalysis
extends SensitivityAnalyzer {
    int currentIndex = 0;
    SimpleEnsemble[] x = null;

    @Override
    public void calculate() {
        int k;
        int j;
        super.calculate();
        ArrayList<Integer> behavourialBox = new ArrayList<Integer>();
        ArrayList<Integer> nonBehavourialBox = new ArrayList<Integer>();
        ArrayList<SampleFactory.Sample> s = this.getRandomSampling();
        this.x = new SimpleEnsemble[this.n];
        for (int j2 = 0; j2 < this.n; ++j2) {
            this.x[j2] = new SimpleEnsemble(Integer.toString(j2), s.size());
        }
        EfficiencyEnsemble y = new EfficiencyEnsemble("y", s.size(), true);
        for (int i = 0; i < s.size(); ++i) {
            SampleFactory.Sample sample = s.get(i);
            for (j = 0; j < this.n; ++j) {
                this.x[j].add(i, sample.x[j]);
            }
            y.add(i, sample.F()[0]);
        }
        EfficiencyEnsemble likelihood = y.CalculateLikelihood();
        Integer[] sortedIds = likelihood.sort();
        this.sensitivityIndex = new double[this.n];
        for (j = 0; j < this.sampleSize; ++j) {
            if (j > this.sampleSize / 2) {
                behavourialBox.add(sortedIds[j]);
                continue;
            }
            nonBehavourialBox.add(sortedIds[j]);
        }
        for (int i = 0; i < this.n; ++i) {
            this.currentIndex = i;
            Collections.sort(behavourialBox, new Comparator<Integer>(){

                @Override
                public int compare(Integer i, Integer j) {
                    double vj;
                    double vi = RegionalSensitivityAnalysis.this.x[RegionalSensitivityAnalysis.this.currentIndex].getValue(i);
                    if (vi < (vj = RegionalSensitivityAnalysis.this.x[RegionalSensitivityAnalysis.this.currentIndex].getValue(j))) {
                        return -1;
                    }
                    if (vi == vj) {
                        return 0;
                    }
                    return 1;
                }
            });
            Collections.sort(nonBehavourialBox, new Comparator<Integer>(){

                @Override
                public int compare(Integer i, Integer j) {
                    double vj;
                    double vi = RegionalSensitivityAnalysis.this.x[RegionalSensitivityAnalysis.this.currentIndex].getValue(i);
                    if (vi < (vj = RegionalSensitivityAnalysis.this.x[RegionalSensitivityAnalysis.this.currentIndex].getValue(j))) {
                        return -1;
                    }
                    if (vi == vj) {
                        return 0;
                    }
                    return 1;
                }
            });
            double behavourialDistribution = 0.0;
            double nonBehavourialDistribution = 0.0;
            double step1 = 1.0 / (double)behavourialBox.size();
            double step2 = 1.0 / (double)nonBehavourialBox.size();
            int k2 = 0;
            this.sensitivityIndex[i] = 0.0;
            for (int k3 = 0; k3 < behavourialBox.size(); ++k3) {
                double value = this.x[this.currentIndex].getValue((Integer)behavourialBox.get(k3));
                double value2 = this.x[this.currentIndex].getValue((Integer)nonBehavourialBox.get(k2));
                while (value2 < value && k2 < nonBehavourialBox.size() - 1) {
                    value2 = this.x[this.currentIndex].getValue((Integer)nonBehavourialBox.get(++k2));
                    nonBehavourialDistribution += step2;
                }
                if (!(Math.abs((behavourialDistribution += step1) - nonBehavourialDistribution) > this.sensitivityIndex[i])) continue;
                this.sensitivityIndex[i] = Math.abs(behavourialDistribution - nonBehavourialDistribution);
            }
        }
        double sum = 0.0;
        for (k = 0; k < this.n; ++k) {
            sum += this.sensitivityIndex[k];
        }
        k = 0;
        while (k < this.n) {
            int n = k++;
            this.sensitivityIndex[n] = this.sensitivityIndex[n] / sum;
        }
    }
}

