/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.Random;
import optas.SA.SensitivityAnalyzer;

public class MorrisMethod
extends SensitivityAnalyzer {
    final double p = 30.0;
    final double R = 75.0;
    final double delta = 0.1;
    double[][] distributions = null;
    double[] mean;
    double[] meanstar;
    double[] sigma;
    Random rnd = new Random();
    Measure measure = Measure.Absolute;

    public MorrisMethod() {
    }

    public MorrisMethod(Measure m) {
        this.measure = m;
    }

    private int[] generatePermutation() {
        int i;
        int[] map = new int[this.n];
        int[] set = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            set[i] = i;
        }
        for (i = 0; i < this.n; ++i) {
            int index = this.rnd.nextInt(this.n - i);
            map[i] = set[index];
            set[index] = set[this.n - i - 1];
        }
        return map;
    }

    @Override
    public void calculate() {
        int j;
        super.calculate();
        this.distributions = new double[75][this.n];
        this.mean = new double[this.n];
        this.meanstar = new double[this.n];
        this.sigma = new double[this.n];
        int i = 0;
        while ((double)i < 75.0) {
            int j2;
            double[] values = new double[this.n + 1];
            double[] x0 = new double[this.n];
            for (j2 = 0; j2 < this.n; ++j2) {
                x0[j2] = this.rnd.nextDouble();
            }
            for (j2 = 0; j2 < this.n; ++j2) {
                if (this.rnd.nextBoolean()) {
                    int n = j2;
                    x0[n] = x0[n] + 0.1;
                    if (!(x0[j2] > 1.0)) continue;
                    int n2 = j2;
                    x0[n2] = x0[n2] - 0.2;
                    continue;
                }
                int n = j2;
                x0[n] = x0[n] - 0.1;
                if (!(x0[j2] < 0.0)) continue;
                int n3 = j2;
                x0[n3] = x0[n3] + 0.2;
            }
            int[] map = this.generatePermutation();
            values[0] = this.evaluateModel(x0);
            for (j = 0; j < this.n; ++j) {
                int index = map[j];
                boolean up = this.rnd.nextBoolean();
                if (up) {
                    int n = index;
                    x0[n] = x0[n] + 0.1;
                } else {
                    int n = index;
                    x0[n] = x0[n] - 0.1;
                }
                values[j + 1] = this.evaluateModel(x0);
                this.distributions[i][index] = values[j + 1] - values[j];
                if (up) {
                    int n = index;
                    this.mean[n] = this.mean[n] + this.distributions[i][index];
                } else {
                    int n = index;
                    this.mean[n] = this.mean[n] - this.distributions[i][index];
                }
                int n = index;
                this.meanstar[n] = this.meanstar[n] + Math.abs(this.distributions[i][index]);
            }
            ++i;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (j = 0; j < this.n; ++j) {
            int n = j;
            this.mean[n] = this.mean[n] / 75.0;
            int n4 = j;
            this.meanstar[n4] = this.meanstar[n4] / 75.0;
            int i2 = 0;
            while ((double)i2 < 75.0) {
                int n5 = j;
                this.sigma[n5] = this.sigma[n5] + Math.pow(Math.abs(this.distributions[i2][j]) - this.meanstar[j], 2.0);
                ++i2;
            }
            int n6 = j;
            this.sigma[n6] = this.sigma[n6] / 75.0;
            this.sigma[j] = Math.sqrt(this.sigma[j]);
            sum1 += this.meanstar[j];
            sum2 += this.mean[j];
        }
        for (j = 0; j < this.n; ++j) {
            if (this.measure == Measure.Absolute) {
                this.sensitivityIndex[j] = this.meanstar[j];
                continue;
            }
            if (this.measure == Measure.NonAbsolute) {
                this.sensitivityIndex[j] = this.mean[j];
                continue;
            }
            if (this.measure != Measure.Variance) continue;
            this.sensitivityIndex[j] = this.sigma[j];
        }
    }

    public static enum Measure {
        Absolute,
        NonAbsolute,
        Variance;

    }
}

