/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import jams.aggregators.Aggregator;
import jams.aggregators.DoubleArrayAggregator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ErrorStatistics<T extends Comparable> {
    TreeMap<T, double[]> data;
    double lowQ;
    double upQ;
    int n;

    public ErrorStatistics(int n) {
        this.n = n;
        this.data = new TreeMap();
    }

    public void add(T key, double[] value) {
        this.data.put(key, value);
    }

    public void setQuantileRange(double lowQ, double upQ) {
        this.lowQ = lowQ;
        this.upQ = upQ;
    }

    private SortedMap<T, double[]> getInterQuantileMap() {
        Comparable fromKey = null;
        Comparable toKey = null;
        double q = 0.0;
        double delta = 1.0 / (double)this.data.size();
        for (Comparable key : this.data.keySet()) {
            if (!((q += delta) >= this.lowQ) || !(q <= this.upQ)) continue;
            if (fromKey == null) {
                fromKey = key;
            }
            toKey = key;
        }
        if (fromKey == null || toKey == null) {
            return null;
        }
        return this.data.subMap(fromKey, toKey);
    }

    private double[] aggregate(Aggregator<double[]> a) {
        SortedMap<T, double[]> subMap = this.getInterQuantileMap();
        if (subMap == null) {
            return null;
        }
        a.init();
        for (Comparable key : subMap.keySet()) {
            double[] value = (double[])subMap.get(key);
            a.consider((Object)value);
        }
        a.finish();
        return (double[])a.get();
    }

    public double[] getMin() {
        return this.aggregate((Aggregator<double[]>)DoubleArrayAggregator.create((Aggregator.AggregationMode)Aggregator.AggregationMode.MINIMUM, (int)this.n));
    }

    public double[] getMax() {
        return this.aggregate((Aggregator<double[]>)DoubleArrayAggregator.create((Aggregator.AggregationMode)Aggregator.AggregationMode.MAXIMUM, (int)this.n));
    }

    public double[] getMean() {
        return this.aggregate((Aggregator<double[]>)DoubleArrayAggregator.create((Aggregator.AggregationMode)Aggregator.AggregationMode.AVERAGE, (int)this.n));
    }

    public double[] getVariance() {
        return this.aggregate((Aggregator<double[]>)DoubleArrayAggregator.create((Aggregator.AggregationMode)Aggregator.AggregationMode.VARIANCE, (int)this.n));
    }

    public int getSize() {
        SortedMap<T, double[]> subMap = this.getInterQuantileMap();
        if (subMap == null) {
            return 0;
        }
        return this.getInterQuantileMap().size();
    }
}

