/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.encog.bot.BotError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUtility {
    public static final String ENCODE = "UTF-8";
    public static final int BUFFER_SIZE = 8192;
    public static final int RANDOM_LENGTH = 36;
    private static Random random = new Random();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String boundary;
    private final OutputStream os;
    private boolean first;

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, ENCODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String getBoundary() {
        return "---------------------------" + FormUtility.randomString() + FormUtility.randomString() + FormUtility.randomString();
    }

    public static Map<String, String> parse(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) {
                string3 = FormUtility.encode(string3);
                hashMap.put(string3, null);
                continue;
            }
            String string4 = stringTokenizer2.nextToken();
            string4 = FormUtility.encode(string4);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    public FormUtility(OutputStream outputStream, String string) {
        this.os = outputStream;
        this.boundary = string;
        this.first = true;
    }

    public void add(String string, File file) {
        block5: {
            try {
                if (this.boundary != null) {
                    int n;
                    this.boundary();
                    this.writeName(string);
                    this.write("; filename=\"");
                    this.write(file.getName());
                    this.write("\"");
                    this.newline();
                    this.write("Content-Type: ");
                    String string2 = URLConnection.guessContentTypeFromName(file.getName());
                    if (string2 == null) {
                        string2 = "application/octet-stream";
                    }
                    this.writeln(string2);
                    this.newline();
                    byte[] byArray = new byte[8192];
                    FileInputStream fileInputStream = new FileInputStream(file);
                    while ((n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length)) >= 0) {
                        this.os.write(byArray, 0, n);
                    }
                    this.newline();
                }
            }
            catch (IOException iOException) {
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug("Exception", (Throwable)iOException);
            }
        }
    }

    public void add(String string, String string2) {
        if (this.boundary != null) {
            this.boundary();
            this.writeName(string);
            this.newline();
            this.newline();
            this.writeln(string2);
        } else {
            if (!this.first) {
                this.write("&");
            }
            this.write(FormUtility.encode(string));
            this.write("=");
            this.write(FormUtility.encode(string2));
        }
        this.first = false;
    }

    private void boundary() {
        this.write("--");
        this.write(this.boundary);
    }

    public void complete() {
        try {
            if (this.boundary != null) {
                this.boundary();
                this.writeln("--");
                this.os.flush();
            }
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BotError(iOException);
        }
    }

    private void newline() {
        this.write("\r\n");
    }

    private void write(String string) {
        try {
            this.os.write(string.getBytes());
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BotError(iOException);
        }
    }

    protected void writeln(String string) {
        this.write(string);
        this.newline();
    }

    private void writeName(String string) {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(string);
        this.write("\"");
    }
}

