/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieUtility {
    private final Map<String, String> map = new HashMap<String, String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Map<String, String> getMap() {
        return this.map;
    }

    public void loadCookies(URLConnection uRLConnection) {
        String string;
        int n = 1;
        do {
            if ((string = uRLConnection.getHeaderFieldKey(n)) != null && string.equalsIgnoreCase("Set-Cookie")) {
                string = uRLConnection.getHeaderField(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.map.put(string2, string3);
            }
            ++n;
        } while (string != null);
    }

    public void saveCookies(URLConnection uRLConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = this.map.keySet();
        for (String string : set) {
            String string2 = this.map.get(string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(string + "=" + string2);
        }
        uRLConnection.setRequestProperty("Cookie", stringBuilder.toString());
    }
}

