/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.encog.EncogError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Directory {
    public static final int BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(Directory.class);

    public static void copyFile(File file, File file2) {
        try {
            byte[] byArray = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            int n = 0;
            while (n != -1) {
                n = fileInputStream.read(byArray);
                if (n == -1) continue;
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new EncogError(iOException);
        }
    }

    public static boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    Directory.deleteDirectory(file2);
                    continue;
                }
                if (file2.delete()) continue;
                throw new EncogError("Failed to delete: " + file2.toString() + "\nFile may be in use.");
            }
        }
        return file.delete();
    }

    public static String readStream(InputStream inputStream) {
        try {
            StringBuffer stringBuffer = new StringBuffer(1024);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) > -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            LOGGER.error("Exception", (Throwable)iOException);
            throw new EncogError(iOException);
        }
    }

    public static String readTextFile(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(1024);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) > -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            LOGGER.error("Exception", (Throwable)iOException);
            throw new EncogError(iOException);
        }
    }

    private Directory() {
    }
}

