/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.downsample;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.encog.EncogError;
import org.encog.util.ImageSize;
import org.encog.util.downsample.Downsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RGBDownsample
implements Downsample {
    private int[] pixelMap;
    private double ratioX;
    private double ratioY;
    private int imageHeight;
    private int imageWidth;
    private int downSampleLeft;
    private int downSampleRight;
    private int downSampleTop;
    private int downSampleBottom;
    private int currentRed;
    private int currentBlue;
    private int currentGreen;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public double[] downSample(Image image, int n, int n2) {
        this.processImage(image);
        double[] dArray = new double[n * n2 * 3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.imageWidth, this.imageWidth, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)interruptedException);
            }
            throw new EncogError(interruptedException);
        }
        this.pixelMap = (int[])pixelGrabber.getPixels();
        this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)n2;
        this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)n;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.downSampleRegion(j, i);
                dArray[n3++] = this.currentRed;
                dArray[n3++] = this.currentGreen;
                dArray[n3++] = this.currentBlue;
            }
        }
        return dArray;
    }

    public void downSampleRegion(int n, int n2) {
        int n3 = (int)((double)this.downSampleLeft + (double)n * this.ratioX);
        int n4 = (int)((double)this.downSampleTop + (double)n2 * this.ratioY);
        int n5 = (int)((double)n3 + this.ratioX);
        int n6 = (int)((double)n4 + this.ratioY);
        n5 = Math.min(this.imageWidth, n5);
        n6 = Math.min(this.imageHeight, n6);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = n4; i < n6; ++i) {
            for (int j = n3; j < n5; ++j) {
                int n11 = j + i * this.imageWidth;
                int n12 = this.pixelMap[n11];
                int n13 = n12 >> 16 & 0xFF;
                int n14 = n12 >> 8 & 0xFF;
                int n15 = n12 & 0xFF;
                n7 += n13;
                n8 += n14;
                n9 += n15;
                ++n10;
            }
        }
        this.currentRed = n7 / n10;
        this.currentGreen = n8 / n10;
        this.currentBlue = n9 / n10;
    }

    public void findBounds() {
        int n;
        for (n = 0; n < this.imageHeight; ++n) {
            if (this.hLineClear(n)) continue;
            this.downSampleTop = n;
            break;
        }
        for (n = this.imageHeight - 1; n >= 0; --n) {
            if (this.hLineClear(n)) continue;
            this.downSampleBottom = n;
            break;
        }
        for (n = 0; n < this.imageWidth; ++n) {
            if (this.vLineClear(n)) continue;
            this.downSampleLeft = n;
            break;
        }
        for (n = this.imageWidth - 1; n >= 0; --n) {
            if (this.vLineClear(n)) continue;
            this.downSampleRight = n;
            break;
        }
    }

    public int getCurrentBlue() {
        return this.currentBlue;
    }

    public int getCurrentGreen() {
        return this.currentGreen;
    }

    public int getCurrentRed() {
        return this.currentRed;
    }

    public int getDownSampleBottom() {
        return this.downSampleBottom;
    }

    public int getDownSampleLeft() {
        return this.downSampleLeft;
    }

    public int getDownSampleRight() {
        return this.downSampleRight;
    }

    public int getDownSampleTop() {
        return this.downSampleTop;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int[] getPixelMap() {
        return this.pixelMap;
    }

    public double getRatioX() {
        return this.ratioX;
    }

    public double getRatioY() {
        return this.ratioY;
    }

    private boolean hLineClear(int n) {
        for (int i = 0; i < this.imageWidth; ++i) {
            if (this.pixelMap[n * this.imageWidth + i] == -1) continue;
            return false;
        }
        return true;
    }

    public void processImage(Image image) {
        ImageSize imageSize = new ImageSize(image);
        this.imageHeight = imageSize.getHeight();
        this.imageWidth = imageSize.getWidth();
        this.downSampleLeft = 0;
        this.downSampleTop = 0;
        this.downSampleRight = this.imageWidth;
        this.downSampleBottom = this.imageHeight;
        this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)this.getImageWidth();
        this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)this.getImageHeight();
    }

    public void setCurrentBlue(int n) {
        this.currentBlue = n;
    }

    public void setCurrentGreen(int n) {
        this.currentGreen = n;
    }

    public void setCurrentRed(int n) {
        this.currentRed = n;
    }

    public void setPixelMap(int[] nArray) {
        this.pixelMap = nArray;
    }

    private boolean vLineClear(int n) {
        for (int i = 0; i < this.imageHeight; ++i) {
            if (this.pixelMap[i * this.imageWidth + n] == -1) continue;
            return false;
        }
        return true;
    }
}

