/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.encog.EncogError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadHTML;
import org.encog.util.http.FormUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooSearch {
    private static final int MAX_TRIES = 5;
    private static final long RETRY_SLEEP = 5000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Collection<URL> doSearch(URL uRL) throws IOException {
        int n;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        InputStream inputStream = uRL.openStream();
        ReadHTML readHTML = new ReadHTML(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while ((n = readHTML.read()) != -1) {
            if (n == 0) {
                Tag tag = readHTML.getTag();
                if (tag.getName().equalsIgnoreCase("url")) {
                    stringBuilder.setLength(0);
                    bl = true;
                    continue;
                }
                if (!tag.getName().equalsIgnoreCase("/url")) continue;
                arrayList.add(new URL(stringBuilder.toString()));
                stringBuilder.setLength(0);
                bl = false;
                continue;
            }
            if (!bl) continue;
            stringBuilder.append((char)n);
        }
        return arrayList;
    }

    public Collection<URL> search(String string) throws IOException {
        Collection<URL> collection = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FormUtility formUtility = new FormUtility(byteArrayOutputStream, null);
        formUtility.add("appid", "YahooDemo");
        formUtility.add("results", "100");
        formUtility.add("query", string);
        formUtility.complete();
        URL uRL = new URL("http://search.yahooapis.com/WebSearchService/V1/webSearch?" + byteArrayOutputStream.toString());
        byteArrayOutputStream.close();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            try {
                collection = this.doSearch(uRL);
                bl = true;
            }
            catch (IOException iOException) {
                if (n == 5) {
                    throw iOException;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new EncogError("Interrupted");
                }
            }
            ++n;
        }
        return collection;
    }
}

