/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;

public final class EncogValidate {
    public static void validateNetworkForTraining(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        Layer layer = basicNetwork.getLayer("INPUT");
        Layer layer2 = basicNetwork.getLayer("OUTPUT");
        if (layer == null) {
            throw new NeuralNetworkError("This operation requires that the neural network have an input layer.");
        }
        if (layer2 == null) {
            throw new NeuralNetworkError("This operation requires that the neural network have an output layer.");
        }
        if (layer.getNeuronCount() != neuralDataSet.getInputSize()) {
            throw new NeuralNetworkError("The input layer size of " + layer.getNeuronCount() + " must match the training input size of " + neuralDataSet.getInputSize() + ".");
        }
        if (neuralDataSet.getIdealSize() > 0 && layer2.getNeuronCount() != neuralDataSet.getIdealSize()) {
            throw new NeuralNetworkError("The output layer size of " + layer2.getNeuronCount() + " must match the training input size of " + neuralDataSet.getIdealSize() + ".");
        }
    }

    private EncogValidate() {
    }
}

