/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.util.obj.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTagger {
    private final Map<Object, Integer> map = new HashMap<Object, Integer>();
    private int currentID = 1;
    private int depth;

    public void analyze(EncogPersistedObject encogPersistedObject) {
        try {
            this.depth = 0;
            this.assignObjectTag(encogPersistedObject);
            for (Field field : ReflectionUtil.getAllFields(encogPersistedObject.getClass())) {
                if (!ReflectionUtil.shouldAccessField(field, true)) continue;
                field.setAccessible(true);
                Object object = field.get(encogPersistedObject);
                this.tagField(object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistError(illegalAccessException);
        }
    }

    private void assignObjectTag(Object object) {
        if (object.getClass().getAnnotation(EGReferenceable.class) != null) {
            this.map.put(object, this.currentID);
            ++this.currentID;
        }
    }

    public void clear() {
        this.map.clear();
        this.currentID = 1;
    }

    public int getReference(Object object) {
        if (object == null) {
            return -1;
        }
        return this.map.get(object);
    }

    public boolean hasReference(Object object) {
        return this.map.containsKey(object);
    }

    private void tagCollection(Collection<?> collection) throws IllegalAccessException {
        for (Object obj : collection) {
            this.tagObject(obj);
        }
    }

    private void tagField(Object object) throws IllegalAccessException {
        ++this.depth;
        if (this.map.containsKey(object)) {
            return;
        }
        if (object != null) {
            if (object instanceof Collection) {
                this.tagCollection((Collection)object);
            } else {
                this.tagObject(object);
            }
        }
        --this.depth;
    }

    private void tagObject(Object object) throws IllegalAccessException {
        Collection<Field> collection = ReflectionUtil.getAllFields(object.getClass());
        this.assignObjectTag(object);
        for (Field field : collection) {
            Object object2;
            field.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(field, false) || ReflectionUtil.isPrimitive(object2 = field.get(object)) || ReflectionUtil.isSimple(object2)) continue;
            if (this.depth > 50) {
                throw new PersistError("Encog persistence is greater than 50 levels deep, closed loop likely.  Consider adding @EGReference tag near attribute: " + object.getClass().toString());
            }
            if (this.map.containsKey(object2)) continue;
            this.tagField(object2);
        }
    }
}

