/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.persist.persistors.generic.FieldMapping;

public class ObjectMapper {
    private final Map<Integer, Object> objectMap = new HashMap<Integer, Object>();
    private final List<FieldMapping> list = new ArrayList<FieldMapping>();

    public void addFieldMapping(int n, Field field, Object object) {
        this.list.add(new FieldMapping(n, field, object));
    }

    public void addObjectMapping(int n, Object object) {
        this.objectMap.put(n, object);
    }

    public void clear() {
        this.objectMap.clear();
        this.list.clear();
    }

    public void resolve() {
        try {
            for (FieldMapping fieldMapping : this.list) {
                Object object = this.objectMap.get(fieldMapping.getRef());
                fieldMapping.getField().setAccessible(true);
                fieldMapping.getField().set(fieldMapping.getTarget(), object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EncogError(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EncogError(illegalAccessException);
        }
    }
}

