/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.StringTokenizer;
import org.encog.engine.util.EngineArray;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.neural.networks.svm.SVMNetwork;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class SVMNetworkPersistor
implements Persistor {
    public static final String[] svm_type_table = new String[]{"c_svc", "nu_svc", "one_class", "epsilon_svr", "nu_svr"};
    public static final String[] kernel_type_table = new String[]{"linear", "polynomial", "rbf", "sigmoid", "precomputed"};
    public static final String TAG_INPUT = "input";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_MODELS = "models";
    public static final String TAG_DATA = "Data";
    public static final String TAG_ROW = "Row";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_TYPE_SVM = "typeSVM";
    public static final String TAG_TYPE_KERNEL = "typeKernel";
    public static final String TAG_DEGREE = "degree";
    public static final String TAG_GAMMA = "gamma";
    public static final String TAG_COEF0 = "coef0";
    public static final String TAG_NUMCLASS = "numClass";
    public static final String TAG_TOTALSV = "totalSV";
    public static final String TAG_RHO = "rho";
    public static final String TAG_LABEL = "label";
    public static final String TAG_PROB_A = "probA";
    public static final String TAG_PROB_B = "probB";
    public static final String TAG_NSV = "nSV";

    public EncogPersistedObject load(ReadXML readXML) {
        BasicPersistedObject basicPersistedObject = null;
        int n = -1;
        int n2 = -1;
        String string = readXML.getTag().getAttributes().get("name");
        String string2 = readXML.getTag().getAttributes().get("description");
        while (readXML.readToTag()) {
            if (readXML.is(TAG_INPUT, true)) {
                n = Integer.parseInt(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_OUTPUT, true)) {
                n2 = Integer.parseInt(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_MODELS, true)) {
                basicPersistedObject = new SVMNetwork(n, n2, false);
                this.handleModels(readXML, (SVMNetwork)basicPersistedObject);
                continue;
            }
            if (!readXML.is("SVMNetwork", false)) continue;
        }
        basicPersistedObject.setName(string);
        basicPersistedObject.setDescription(string2);
        return basicPersistedObject;
    }

    private void handleModels(ReadXML readXML, SVMNetwork sVMNetwork) {
        int n = 0;
        while (readXML.readToTag()) {
            if (readXML.is(TAG_MODEL, true)) {
                svm_parameter svm_parameter2 = new svm_parameter();
                svm_model svm_model2 = new svm_model();
                svm_model2.param = svm_parameter2;
                sVMNetwork.getModels()[n] = svm_model2;
                this.handleModel(readXML, sVMNetwork.getModels()[n]);
                ++n;
                continue;
            }
            if (!readXML.is(TAG_MODELS, false)) continue;
            break;
        }
    }

    private void handleModel(ReadXML readXML, svm_model svm_model2) {
        while (readXML.readToTag()) {
            int n;
            StringTokenizer stringTokenizer;
            int n2;
            if (readXML.is(TAG_TYPE_SVM, true)) {
                svm_model2.param.svm_type = n2 = EngineArray.findStringInArray(svm_type_table, readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_DEGREE, true)) {
                svm_model2.param.degree = Integer.parseInt(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_GAMMA, true)) {
                svm_model2.param.gamma = Double.parseDouble(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_COEF0, true)) {
                svm_model2.param.coef0 = Double.parseDouble(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_NUMCLASS, true)) {
                svm_model2.nr_class = Integer.parseInt(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_TOTALSV, true)) {
                svm_model2.l = Integer.parseInt(readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_RHO, true)) {
                n2 = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                svm_model2.rho = new double[n2];
                stringTokenizer = new StringTokenizer(readXML.readTextToTag());
                for (n = 0; n < n2; ++n) {
                    svm_model2.rho[n] = Double.parseDouble(stringTokenizer.nextToken());
                }
                continue;
            }
            if (readXML.is(TAG_LABEL, true)) {
                n2 = svm_model2.nr_class;
                svm_model2.label = new int[n2];
                stringTokenizer = new StringTokenizer(readXML.readTextToTag());
                for (n = 0; n < n2; ++n) {
                    svm_model2.label[n] = Integer.parseInt(stringTokenizer.nextToken());
                }
                continue;
            }
            if (readXML.is(TAG_PROB_A, true)) {
                n2 = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                svm_model2.probA = new double[n2];
                stringTokenizer = new StringTokenizer(readXML.readTextToTag());
                for (n = 0; n < n2; ++n) {
                    svm_model2.probA[n] = Double.parseDouble(stringTokenizer.nextToken());
                }
                continue;
            }
            if (readXML.is(TAG_PROB_B, true)) {
                n2 = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                svm_model2.probB = new double[n2];
                stringTokenizer = new StringTokenizer(readXML.readTextToTag());
                for (n = 0; n < n2; ++n) {
                    svm_model2.probB[n] = Double.parseDouble(stringTokenizer.nextToken());
                }
                continue;
            }
            if (readXML.is(TAG_NSV, true)) {
                n2 = svm_model2.nr_class;
                svm_model2.nSV = new int[n2];
                stringTokenizer = new StringTokenizer(readXML.readTextToTag());
                for (n = 0; n < n2; ++n) {
                    svm_model2.nSV[n] = Integer.parseInt(stringTokenizer.nextToken());
                }
                continue;
            }
            if (readXML.is(TAG_TYPE_KERNEL, true)) {
                svm_model2.param.kernel_type = n2 = EngineArray.findStringInArray(kernel_type_table, readXML.readTextToTag());
                continue;
            }
            if (readXML.is(TAG_DATA, true)) {
                this.handleData(readXML, svm_model2);
                continue;
            }
            if (!readXML.is(TAG_MODEL, false)) continue;
            break;
        }
    }

    private void handleData(ReadXML readXML, svm_model svm_model2) {
        int n = 0;
        int n2 = svm_model2.nr_class - 1;
        int n3 = svm_model2.l;
        svm_model2.sv_coef = new double[n2][n3];
        svm_model2.SV = new svm_node[n3][];
        while (readXML.readToTag()) {
            if (readXML.is(TAG_ROW, true)) {
                int n4;
                String string = readXML.readTextToTag();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f:");
                for (n4 = 0; n4 < n2; ++n4) {
                    svm_model2.sv_coef[n4][n] = Double.parseDouble(stringTokenizer.nextToken());
                }
                n4 = stringTokenizer.countTokens() / 2;
                svm_model2.SV[n] = new svm_node[n4];
                for (int i = 0; i < n4; ++i) {
                    svm_model2.SV[n][i] = new svm_node();
                    svm_model2.SV[n][i].index = Integer.parseInt(stringTokenizer.nextToken());
                    svm_model2.SV[n][i].value = Double.parseDouble(stringTokenizer.nextToken());
                }
                ++n;
                continue;
            }
            if (!readXML.is(TAG_DATA, false)) continue;
            break;
        }
    }

    public static void saveModel(WriteXML writeXML, svm_model svm_model2) {
        if (svm_model2 != null) {
            writeXML.beginTag(TAG_MODEL);
            svm_parameter svm_parameter2 = svm_model2.param;
            writeXML.addProperty(TAG_TYPE_SVM, svm_type_table[svm_parameter2.svm_type]);
            writeXML.addProperty(TAG_TYPE_KERNEL, kernel_type_table[svm_parameter2.kernel_type]);
            if (svm_parameter2.kernel_type == 1) {
                writeXML.addProperty(TAG_DEGREE, svm_parameter2.degree);
            }
            if (svm_parameter2.kernel_type == 1 || svm_parameter2.kernel_type == 2 || svm_parameter2.kernel_type == 3) {
                writeXML.addProperty(TAG_GAMMA, svm_parameter2.gamma);
            }
            if (svm_parameter2.kernel_type == 1 || svm_parameter2.kernel_type == 3) {
                writeXML.addProperty(TAG_COEF0, svm_parameter2.coef0);
            }
            int n = svm_model2.nr_class;
            int n2 = svm_model2.l;
            writeXML.addProperty(TAG_NUMCLASS, n);
            writeXML.addProperty(TAG_TOTALSV, n2);
            writeXML.addProperty(TAG_RHO, svm_model2.rho, n * (n - 1) / 2);
            writeXML.addProperty(TAG_LABEL, svm_model2.label, n);
            writeXML.addProperty(TAG_PROB_A, svm_model2.probA, n * (n - 1) / 2);
            writeXML.addProperty(TAG_PROB_B, svm_model2.probB, n * (n - 1) / 2);
            writeXML.addProperty(TAG_NSV, svm_model2.nSV, n);
            writeXML.beginTag(TAG_DATA);
            double[][] dArray = svm_model2.sv_coef;
            svm_node[][] svm_nodeArray = svm_model2.SV;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                stringBuilder.setLength(0);
                for (int j = 0; j < n - 1; ++j) {
                    stringBuilder.append(dArray[j][i] + " ");
                }
                svm_node[] svm_nodeArray2 = svm_nodeArray[i];
                if (svm_parameter2.kernel_type == 4) {
                    stringBuilder.append("0:" + (int)svm_nodeArray2[0].value);
                } else {
                    for (int j = 0; j < svm_nodeArray2.length; ++j) {
                        stringBuilder.append(svm_nodeArray2[j].index + ":" + svm_nodeArray2[j].value + " ");
                    }
                }
                writeXML.addProperty(TAG_ROW, stringBuilder.toString());
            }
            writeXML.endTag();
            writeXML.endTag();
        }
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("SVMNetwork", writeXML, encogPersistedObject, true);
        SVMNetwork sVMNetwork = (SVMNetwork)encogPersistedObject;
        writeXML.addProperty(TAG_INPUT, sVMNetwork.getInputCount());
        writeXML.addProperty(TAG_OUTPUT, sVMNetwork.getOutputCount());
        writeXML.beginTag(TAG_MODELS);
        for (int i = 0; i < sVMNetwork.getModels().length; ++i) {
            SVMNetworkPersistor.saveModel(writeXML, sVMNetwork.getModels()[i]);
        }
        writeXML.endTag();
        writeXML.endTag();
    }
}

