/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.ArrayList;
import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialBasisFunctionLayerPersistor
implements Persistor {
    public static final String PROPERTY_RBF = "rbf";
    public static final String PROPERTY_CENTERS = "centers";
    public static final String PROPERTY_PEAK = "peak";
    public static final String PROPERTY_WIDTH = "width";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EncogPersistedObject load(ReadXML readXML) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        RadialBasisFunction[] radialBasisFunctionArray = new RadialBasisFunction[]{};
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is("neurons", true)) {
                n = readXML.readIntToTag();
                continue;
            }
            if (readXML.is("x", true)) {
                n2 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is("y", true)) {
                n3 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is(PROPERTY_RBF, true)) {
                radialBasisFunctionArray = this.loadAllRBF(readXML);
                continue;
            }
            if (!readXML.is(string, false)) continue;
        }
        RadialBasisFunctionLayer radialBasisFunctionLayer = new RadialBasisFunctionLayer(n);
        radialBasisFunctionLayer.setRadialBasisFunction(radialBasisFunctionArray);
        radialBasisFunctionLayer.setX(n2);
        radialBasisFunctionLayer.setY(n3);
        return radialBasisFunctionLayer;
    }

    private RadialBasisFunction[] loadAllRBF(ReadXML readXML) {
        RadialBasisFunction[] radialBasisFunctionArray;
        ArrayList<RadialBasisFunction> arrayList = new ArrayList<RadialBasisFunction>();
        while (readXML.readToTag() && !readXML.is(PROPERTY_RBF, false)) {
            radialBasisFunctionArray = readXML.getTag().getName();
            RadialBasisFunction radialBasisFunction = this.loadRBF((String)radialBasisFunctionArray, readXML);
            arrayList.add(radialBasisFunction);
        }
        radialBasisFunctionArray = new RadialBasisFunction[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            radialBasisFunctionArray[i] = (RadialBasisFunction)arrayList.get(i);
        }
        return radialBasisFunctionArray;
    }

    private RadialBasisFunction loadRBF(String string, ReadXML readXML) {
        RadialBasisFunction radialBasisFunction;
        Class<?> clazz = ReflectionUtil.resolveEncogClass(string);
        if (clazz == null) {
            throw new NeuralNetworkError("Unknown activation function type: " + string);
        }
        try {
            radialBasisFunction = (RadialBasisFunction)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new PersistError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistError(illegalAccessException);
        }
        while (readXML.readToTag() && !readXML.is(string, false)) {
            String string2;
            if (readXML.is(PROPERTY_CENTERS, true)) {
                string2 = readXML.readTextToTag();
                double[] dArray = NumberList.fromList(CSVFormat.EG_FORMAT, string2);
                radialBasisFunction.setCenters(dArray);
                continue;
            }
            if (readXML.is(PROPERTY_PEAK, true)) {
                string2 = readXML.readTextToTag();
                double d = Double.parseDouble(string2);
                radialBasisFunction.setPeak(d);
                continue;
            }
            if (!readXML.is(PROPERTY_WIDTH, true)) continue;
            string2 = readXML.readTextToTag();
            double d = Double.parseDouble(string2);
            radialBasisFunction.setWidth(d);
        }
        return radialBasisFunction;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("RadialBasisFunctionLayer", writeXML, encogPersistedObject, false);
        RadialBasisFunctionLayer radialBasisFunctionLayer = (RadialBasisFunctionLayer)encogPersistedObject;
        writeXML.addProperty("neurons", radialBasisFunctionLayer.getNeuronCount());
        writeXML.addProperty("x", radialBasisFunctionLayer.getX());
        writeXML.addProperty("y", radialBasisFunctionLayer.getY());
        this.saveRBF(writeXML, radialBasisFunctionLayer);
        writeXML.endTag();
    }

    private void saveRBF(WriteXML writeXML, RadialBasisFunctionLayer radialBasisFunctionLayer) {
        writeXML.beginTag(PROPERTY_RBF);
        for (RadialBasisFunction radialBasisFunction : radialBasisFunctionLayer.getRadialBasisFunction()) {
            writeXML.beginTag(radialBasisFunction.getClass().getSimpleName());
            writeXML.addProperty(PROPERTY_CENTERS, radialBasisFunction.getCenters(), radialBasisFunction.getCenters().length);
            writeXML.addProperty(PROPERTY_PEAK, radialBasisFunction.getPeak());
            writeXML.addProperty(PROPERTY_WIDTH, radialBasisFunction.getWidth());
            writeXML.endTag();
        }
        writeXML.endTag();
    }
}

