/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.Map;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralDataSetPersistor
implements Persistor {
    public static final String TAG_ITEM = "Item";
    public static final String TAG_INPUT = "Input";
    public static final String TAG_IDEAL = "Ideal";
    private BasicNeuralDataSet currentDataSet;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private void handleItem(ReadXML readXML) {
        Map<String, String> map = readXML.readPropertyBlock();
        BasicNeuralDataPair basicNeuralDataPair = null;
        BasicNeuralData basicNeuralData = new BasicNeuralData(NumberList.fromList(CSVFormat.EG_FORMAT, map.get(TAG_INPUT)));
        if (map.containsKey(TAG_IDEAL)) {
            BasicNeuralData basicNeuralData2 = new BasicNeuralData(NumberList.fromList(CSVFormat.EG_FORMAT, map.get(TAG_IDEAL)));
            basicNeuralDataPair = new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
        } else {
            basicNeuralDataPair = new BasicNeuralDataPair(basicNeuralData);
        }
        this.currentDataSet.add(basicNeuralDataPair);
    }

    public EncogPersistedObject load(ReadXML readXML) {
        String string = readXML.getTag().getAttributes().get("name");
        String string2 = readXML.getTag().getAttributes().get("description");
        this.currentDataSet = new BasicNeuralDataSet();
        this.currentDataSet.setName(string);
        this.currentDataSet.setDescription(string2);
        while (readXML.readToTag()) {
            if (readXML.is(TAG_ITEM, true)) {
                this.handleItem(readXML);
                continue;
            }
            if (!readXML.is("TrainingData", false)) continue;
            break;
        }
        return this.currentDataSet;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("TrainingData", writeXML, encogPersistedObject, true);
        NeuralDataSet neuralDataSet = (NeuralDataSet)((Object)encogPersistedObject);
        StringBuilder stringBuilder = new StringBuilder();
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            writeXML.beginTag(TAG_ITEM);
            NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, neuralDataPair.getInput().getData());
            writeXML.addProperty(TAG_INPUT, stringBuilder.toString());
            if (neuralDataPair.getIdeal() != null) {
                NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, neuralDataPair.getIdeal().getData());
                writeXML.addProperty(TAG_IDEAL, stringBuilder.toString());
            }
            writeXML.endTag();
        }
        writeXML.endTag();
    }
}

