/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.OutputStream;
import java.util.Date;
import org.encog.Encog;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistWriter {
    private final WriteXML out;
    private final OutputStream fileOutput;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PersistWriter(PersistenceLocation persistenceLocation) {
        this.fileOutput = persistenceLocation.createOutputStream();
        this.out = new WriteXML(this.fileOutput);
    }

    public void begin() {
        this.out.beginDocument();
        this.out.beginTag("Document");
    }

    public void beginObjects() {
        this.out.beginTag("Objects");
    }

    public void close() {
        this.out.close();
    }

    public void end() {
        this.out.endTag();
        this.out.endDocument();
    }

    public void endObjects() {
        this.out.endTag();
    }

    public void mergeObjects(PersistenceLocation persistenceLocation, String string) {
        PersistReader persistReader = new PersistReader(persistenceLocation);
        persistReader.saveTo(this.out, string);
        persistReader.close();
    }

    public void modifyObject(PersistenceLocation persistenceLocation, String string, String string2, String string3) {
        PersistReader persistReader = new PersistReader(persistenceLocation);
        persistReader.saveModified(this.out, string, string2, string3);
        persistReader.close();
    }

    public void writeHeader() {
        this.out.beginTag("Header");
        this.out.addProperty("platform", "Java");
        this.out.addProperty("fileVersion", Encog.getInstance().getProperties().get("encog.file.version"));
        this.out.addProperty("encogVersion", Encog.getInstance().getProperties().get("encog.version"));
        this.out.addProperty("modified", new Date().toString());
        this.out.endTag();
    }

    public void writeObject(EncogPersistedObject encogPersistedObject) {
        Persistor persistor = encogPersistedObject.createPersistor();
        if (persistor == null) {
            String string = "Can't find a persistor for object of type " + encogPersistedObject.getClass().getName();
            if (this.logger.isErrorEnabled()) {
                this.logger.error(string);
            }
            throw new PersistError(string);
        }
        persistor.save(encogPersistedObject, this.out);
    }
}

