/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.parse.tags.read.ReadXML;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.PersistWriter;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.encog.persist.persistors.PersistorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncogMemoryCollection
implements EncogCollection {
    private PersistenceLocation location;
    private final Map<String, EncogPersistedObject> contents = new HashMap<String, EncogPersistedObject>();
    private int fileVersion;
    private String encogVersion;
    private String platform;
    private final List<DirectoryEntry> directory = new ArrayList<DirectoryEntry>();

    @Override
    public void add(String string, EncogPersistedObject encogPersistedObject) {
        this.contents.put(string, encogPersistedObject);
        encogPersistedObject.setCollection(this);
        encogPersistedObject.setName(string);
        this.buildDirectory();
    }

    @Override
    public void buildDirectory() {
        this.directory.clear();
        for (EncogPersistedObject encogPersistedObject : this.contents.values()) {
            DirectoryEntry directoryEntry = new DirectoryEntry(encogPersistedObject);
            this.directory.add(directoryEntry);
        }
    }

    @Override
    public void clear() {
        this.contents.clear();
        this.buildDirectory();
    }

    @Override
    public void delete(DirectoryEntry directoryEntry) {
        this.contents.remove(directoryEntry.getName());
        this.buildDirectory();
    }

    @Override
    public void delete(String string) {
        this.contents.remove(string);
        this.buildDirectory();
    }

    @Override
    public boolean exists(String string) {
        return this.contents.containsKey(string);
    }

    @Override
    public EncogPersistedObject find(DirectoryEntry directoryEntry) {
        return this.contents.get(directoryEntry.getName());
    }

    @Override
    public EncogPersistedObject find(String string) {
        return this.contents.get(string);
    }

    public Map<String, EncogPersistedObject> getContents() {
        return this.contents;
    }

    public List<DirectoryEntry> getDirectory() {
        return this.directory;
    }

    @Override
    public String getEncogVersion() {
        return this.encogVersion;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(PersistenceLocation persistenceLocation) {
        PersistReader persistReader = null;
        try {
            this.location = persistenceLocation;
            persistReader = new PersistReader(persistenceLocation);
            Map<String, String> map = persistReader.readHeader();
            if (map != null) {
                this.fileVersion = Integer.parseInt(map.get("fileVersion"));
                this.encogVersion = map.get("encogVersion");
                this.platform = map.get("platform");
            }
            persistReader.advanceObjectsCollection();
            ReadXML readXML = persistReader.getXMLInput();
            while (readXML.readToTag()) {
                if (readXML.is("Objects", false)) {
                    break;
                }
                String string = readXML.getTag().getName();
                String string2 = readXML.getTag().getAttributeValue("name");
                Persistor persistor = PersistorUtil.createPersistor(string);
                if (persistor == null) {
                    throw new PersistError("Do not know how to load: " + string);
                }
                EncogPersistedObject encogPersistedObject = persistor.load(readXML);
                this.contents.put(string2, encogPersistedObject);
                encogPersistedObject.setCollection(this);
            }
        }
        finally {
            this.buildDirectory();
            if (persistReader != null) {
                persistReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PersistenceLocation persistenceLocation) {
        PersistWriter persistWriter = null;
        persistWriter = new PersistWriter(persistenceLocation);
        try {
            this.location = persistenceLocation;
            persistWriter.begin();
            persistWriter.writeHeader();
            persistWriter.beginObjects();
            for (EncogPersistedObject encogPersistedObject : this.contents.values()) {
                persistWriter.writeObject(encogPersistedObject);
            }
            persistWriter.endObjects();
        }
        finally {
            this.buildDirectory();
            persistWriter.end();
            persistWriter.close();
        }
    }

    @Override
    public void updateProperties(String string, String string2, String string3) {
        EncogPersistedObject encogPersistedObject = this.contents.get(string);
        encogPersistedObject.setName(string2);
        encogPersistedObject.setDescription(string3);
        this.contents.remove(string);
        this.contents.put(string2, encogPersistedObject);
        this.buildDirectory();
    }

    @Override
    public PersistenceLocation getLocation() {
        return this.location;
    }
}

