/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse;

import java.io.IOException;
import java.io.InputStream;
import org.encog.bot.BotError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeekableInputStream
extends InputStream {
    public static final int INITIAL_DEPTH = 10;
    private final InputStream stream;
    private byte[] peekBytes;
    private int peekLength;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PeekableInputStream(InputStream inputStream) {
        this.stream = inputStream;
        this.peekBytes = new byte[10];
        this.peekLength = 0;
    }

    public int peek() {
        return this.peek(0);
    }

    public int peek(int n) {
        try {
            int n2;
            if (this.peekBytes.length <= n) {
                byte[] byArray = new byte[n + 10];
                for (n2 = 0; n2 < this.peekBytes.length; ++n2) {
                    byArray[n2] = this.peekBytes[n2];
                }
                this.peekBytes = byArray;
            }
            if (n >= this.peekLength) {
                int n3 = this.peekLength;
                n2 = n - this.peekLength + 1;
                int n4 = this.stream.read(this.peekBytes, n3, n2);
                if (n4 == -1) {
                    return -1;
                }
                this.peekLength = n + 1;
            }
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BotError(iOException);
        }
        return this.peekBytes[n];
    }

    public boolean peek(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.peek(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int read() {
        try {
            if (this.peekLength == 0) {
                return this.stream.read();
            }
            byte by = this.peekBytes[0];
            --this.peekLength;
            for (int i = 0; i < this.peekLength; ++i) {
                this.peekBytes[i] = this.peekBytes[i + 1];
            }
            return by;
        }
        catch (IOException iOException) {
            throw new BotError(iOException);
        }
    }

    public long skip(long l) {
        for (long i = l; i > 0L; --i) {
            this.read();
        }
        return l;
    }
}

