/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedForwardPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private ActivationFunction activation;
    private final List<Integer> hidden = new ArrayList<Integer>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        this.hidden.add(n);
    }

    public void clear() {
        this.hidden.clear();
    }

    public BasicNetwork generate() {
        int n = 50;
        BasicLayer basicLayer = new BasicLayer(this.activation, false, this.inputNeurons);
        BasicNetwork basicNetwork = new BasicNetwork();
        basicNetwork.addLayer(basicLayer);
        basicLayer.setX(50);
        basicLayer.setY(n);
        n += 150;
        for (Integer n2 : this.hidden) {
            BasicLayer basicLayer2 = new BasicLayer(this.activation, true, n2);
            basicNetwork.addLayer(basicLayer2);
            basicLayer2.setX(50);
            basicLayer2.setY(n);
            n += 150;
        }
        BasicLayer basicLayer3 = new BasicLayer(this.activation, true, this.outputNeurons);
        basicNetwork.addLayer(basicLayer3);
        basicLayer3.setX(50);
        basicLayer3.setY(n);
        n += 150;
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activation = activationFunction;
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }
}

