/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationCompetitive;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPNPattern
implements NeuralNetworkPattern {
    public static final String TAG_INSTAR = "INSTAR";
    public static final String TAG_OUTSTAR = "OUTSTAR";
    private int instarCount;
    private int outstarCount;
    private int inputCount;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A CPN already has a predefined hidden layer.  No additionalspecification is needed.");
        }
    }

    public void clear() {
        this.inputCount = 0;
        this.instarCount = 0;
        this.outstarCount = 0;
    }

    public BasicNetwork generate() {
        int n = 50;
        BasicNetwork basicNetwork = new BasicNetwork();
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputCount);
        basicNetwork.addLayer(basicLayer);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationCompetitive(), false, this.instarCount);
        basicNetwork.addLayer(basicLayer2);
        BasicLayer basicLayer3 = new BasicLayer(new ActivationLinear(), false, this.outstarCount);
        basicNetwork.addLayer(basicLayer3);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        basicLayer.setX(50);
        basicLayer.setY(n);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        basicLayer3.setX(50);
        basicLayer3.setY(n += 150);
        basicNetwork.tagLayer("INPUT", basicLayer);
        basicNetwork.tagLayer("OUTPUT", basicLayer3);
        basicNetwork.tagLayer(TAG_INSTAR, basicLayer2);
        basicNetwork.tagLayer(TAG_OUTSTAR, basicLayer3);
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.");
        }
        throw new PatternError("A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.");
    }

    public void setInputNeurons(int n) {
        this.inputCount = n;
    }

    public void setInstarCount(int n) {
        this.instarCount = n;
    }

    public void setOutputNeurons(int n) {
        this.outstarCount = n;
    }

    public void setOutstarCount(int n) {
        this.outstarCount = n;
    }
}

