/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADALINEPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("An ADALINE network has no hidden layers.");
        }
        throw new PatternError("An ADALINE network has no hidden layers.");
    }

    public void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    public BasicNetwork generate() {
        BasicNetwork basicNetwork = new BasicNetwork();
        int n = 50;
        BasicLayer basicLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer basicLayer2 = new BasicLayer(new ActivationLinear(), true, this.outputNeurons);
        basicNetwork.addLayer(basicLayer);
        basicNetwork.addLayer(basicLayer2);
        basicNetwork.getStructure().finalizeStructure();
        new RangeRandomizer(-0.5, 0.5).randomize(basicNetwork);
        basicLayer.setX(50);
        basicLayer.setY(n);
        basicLayer2.setX(50);
        basicLayer2.setY(n += 150);
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A ADALINE network can't specify a custom activation function.");
        }
        throw new PatternError("A ADALINE network can't specify a custom activation function.");
    }

    public void setInputNeurons(int n) {
        this.inputNeurons = n;
    }

    public void setOutputNeurons(int n) {
        this.outputNeurons = n;
    }
}

