/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovation;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATLinkGene;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genes.BasicGene;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.innovation.BasicInnovationList;
import org.encog.solve.genetic.innovation.Innovation;
import org.encog.solve.genetic.population.Population;

public class NEATInnovationList
extends BasicInnovationList {
    private long nextNeuronID = 0L;
    @EGReference
    private Population population;

    public NEATInnovationList() {
    }

    public NEATInnovationList(Population population, Chromosome chromosome, Chromosome chromosome2) {
        NEATInnovation nEATInnovation;
        BasicGene basicGene;
        this.population = population;
        for (Gene gene : chromosome2.getGenes()) {
            basicGene = (NEATNeuronGene)gene;
            nEATInnovation = new NEATInnovation((NEATNeuronGene)basicGene, population.assignInnovationID(), this.assignNeuronID());
            this.add(nEATInnovation);
        }
        for (Gene gene : chromosome.getGenes()) {
            basicGene = (NEATLinkGene)gene;
            nEATInnovation = new NEATInnovation(((NEATLinkGene)basicGene).getFromNeuronID(), ((NEATLinkGene)basicGene).getToNeuronID(), NEATInnovationType.NewLink, this.population.assignInnovationID());
            this.add(nEATInnovation);
        }
    }

    private long assignNeuronID() {
        return this.nextNeuronID++;
    }

    public NEATInnovation checkInnovation(long l, long l2, NEATInnovationType nEATInnovationType) {
        for (Innovation innovation : this.getInnovations()) {
            NEATInnovation nEATInnovation = (NEATInnovation)innovation;
            if (nEATInnovation.getFromNeuronID() != l || nEATInnovation.getToNeuronID() != l2 || nEATInnovation.getInnovationType() != nEATInnovationType) continue;
            return nEATInnovation;
        }
        return null;
    }

    public NEATNeuronGene createNeuronFromID(long l) {
        NEATNeuronGene nEATNeuronGene = new NEATNeuronGene(NEATNeuronType.Hidden, 0L, 0.0, 0.0);
        for (Innovation innovation : this.getInnovations()) {
            NEATInnovation nEATInnovation = (NEATInnovation)innovation;
            if (nEATInnovation.getNeuronID() != l) continue;
            nEATNeuronGene.setNeuronType(nEATInnovation.getNeuronType());
            nEATNeuronGene.setId(nEATInnovation.getNeuronID());
            nEATNeuronGene.setSplitY(nEATInnovation.getSplitY());
            nEATNeuronGene.setSplitX(nEATInnovation.getSplitX());
            return nEATNeuronGene;
        }
        return nEATNeuronGene;
    }

    public void createNewInnovation(long l, long l2, NEATInnovationType nEATInnovationType) {
        NEATInnovation nEATInnovation = new NEATInnovation(l, l2, nEATInnovationType, this.population.assignInnovationID());
        if (nEATInnovationType == NEATInnovationType.NewNeuron) {
            nEATInnovation.setNeuronID(this.assignNeuronID());
        }
        this.add(nEATInnovation);
    }

    public long createNewInnovation(long l, long l2, NEATInnovationType nEATInnovationType, NEATNeuronType nEATNeuronType, double d, double d2) {
        NEATInnovation nEATInnovation = new NEATInnovation(l, l2, nEATInnovationType, this.population.assignInnovationID(), nEATNeuronType, d, d2);
        if (nEATInnovationType == NEATInnovationType.NewNeuron) {
            nEATInnovation.setNeuronID(this.assignNeuronID());
        }
        this.add(nEATInnovation);
        return this.nextNeuronID - 1L;
    }
}

