/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.hebbian;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.TrainingError;

public class HebbianTraining
extends BasicTraining
implements LearningRate {
    private double learningRate;
    private final BasicNetwork network;
    private final NeuralDataSet training;
    private final boolean supervised;
    private final boolean oja;
    private final Layer outputLayer;
    private List<Synapse> outputSynapse = new ArrayList<Synapse>();

    public HebbianTraining(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl, double d) {
        this.network = basicNetwork;
        this.training = neuralDataSet;
        this.learningRate = d;
        this.supervised = neuralDataSet.getIdealSize() > 0;
        this.oja = bl;
        this.outputLayer = this.network.getLayer("OUTPUT");
        if (this.outputLayer == null) {
            throw new TrainingError("Can't use Hebbian training without an output layer.");
        }
        if (this.oja && this.supervised) {
            throw new TrainingError("Can't use OJA Hebbian training with supervised data.");
        }
        this.outputSynapse = this.network.getStructure().getPreviousSynapses(this.outputLayer);
        if (this.outputSynapse.size() == 0) {
            throw new TrainingError("Can't use Hebbian learning, the output layer has no inbound synapses.");
        }
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public NeuralDataSet getTraining() {
        return this.training;
    }

    public boolean isOja() {
        return this.oja;
    }

    public boolean isSupervised() {
        return this.supervised;
    }

    public void iteration() {
        this.preIteration();
        for (NeuralDataPair neuralDataPair : this.training) {
            for (Synapse synapse : this.outputSynapse) {
                this.trainSynapse(synapse, neuralDataPair);
            }
        }
        this.postIteration();
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }

    private void trainSynapse(Synapse synapse, NeuralDataPair neuralDataPair) {
        NeuralData neuralData = this.network.compute(neuralDataPair.getInput());
        double[] dArray = neuralDataPair.getInput().getData();
        double[] dArray2 = neuralData.getData();
        Matrix matrix = synapse.getMatrix();
        for (int i = 0; i < synapse.getToNeuronCount(); ++i) {
            double d = this.supervised ? neuralDataPair.getIdeal().getData(i) : this.learningRate;
            for (int j = 0; j < synapse.getFromNeuronCount(); ++j) {
                double d2 = this.oja ? dArray[j] - dArray2[i] * matrix.get(j, i) * dArray2[i] * this.learningRate : dArray[i] * dArray2[i] * d;
                matrix.add(j, i, d2);
            }
        }
    }
}

