/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive.neighborhood;

import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.engine.util.EngineArray;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.networks.training.competitive.neighborhood.NeighborhoodFunction;

public class NeighborhoodRBF
implements NeighborhoodFunction {
    private RadialBasisFunction rbf;
    private final int[] size;
    private int[] displacement;

    public NeighborhoodRBF(RBFEnum rBFEnum, int n, int n2) {
        int[] nArray = new int[]{n, n2};
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{1.0, 1.0};
        switch (rBFEnum) {
            case Gaussian: {
                this.rbf = new GaussianFunction(2);
                break;
            }
            case InverseMultiquadric: {
                this.rbf = new InverseMultiquadricFunction(2);
                break;
            }
            case Multiquadric: {
                this.rbf = new MultiquadricFunction(2);
                break;
            }
            case MexicanHat: {
                this.rbf = new MexicanHatFunction(2);
            }
        }
        this.rbf.setWidth(1.0);
        EngineArray.arrayCopy(dArray, this.rbf.getCenters());
        this.size = nArray;
        this.calculateDisplacement();
    }

    public NeighborhoodRBF(int[] nArray, RadialBasisFunction radialBasisFunction) {
        this.rbf = radialBasisFunction;
        this.size = nArray;
        this.calculateDisplacement();
    }

    private void calculateDisplacement() {
        this.displacement = new int[this.size.length];
        for (int i = 0; i < this.size.length; ++i) {
            int n = i == 0 ? 0 : (i == 1 ? this.size[0] : this.displacement[i - 1] * this.size[i - 1]);
            this.displacement[i] = n;
        }
    }

    public double function(int n, int n2) {
        double[] dArray = new double[this.displacement.length];
        int[] nArray = this.translateCoordinates(n);
        int[] nArray2 = this.translateCoordinates(n2);
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i] - nArray2[i];
        }
        return this.rbf.calculate(dArray);
    }

    public double getRadius() {
        return this.rbf.getWidth();
    }

    public RadialBasisFunction getRBF() {
        return this.rbf;
    }

    public void setRadius(double d) {
        this.rbf.setWidth(d);
    }

    private int[] translateCoordinates(int n) {
        int[] nArray = new int[this.displacement.length];
        int n2 = n;
        for (int i = this.displacement.length - 1; i >= 0; --i) {
            int n3 = this.displacement[i] > 0 ? n2 / this.displacement[i] : n2;
            n2 -= this.displacement[i] * n3;
            nArray[i] = n3;
        }
        return nArray;
    }
}

